/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.block.actions;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Optional;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.VertexSelectionDependantAction;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.XcosTab;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.configuration.ConfigurationManager;
import org.scilab.modules.xcos.configuration.model.DocumentType;
import org.scilab.modules.xcos.graph.ScicosParameters;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.BlockInterFunction;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.io.scicos.ScilabDirectHandler;
import org.scilab.modules.xcos.utils.BlockPositioning;
import org.scilab.modules.xcos.utils.XcosMessages;

public class BlockParametersAction
extends VertexSelectionDependantAction {
    public static final String NAME = XcosMessages.BLOCK_PARAMETERS;
    public static final String SMALL_ICON = "applications-system";
    public static final int MNEMONIC_KEY = 66;
    public static final int ACCELERATOR_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public BlockParametersAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return BlockParametersAction.createMenu((ScilabGraph)scilabGraph, BlockParametersAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.actionPerformed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed() {
        final XcosDiagram xcosDiagram = (XcosDiagram)this.getGraph(null);
        Object object = xcosDiagram.getSelectionCell();
        if (object != null && object instanceof XcosCell) {
            XcosCell xcosCell = (XcosCell)((Object)object);
            if (xcosCell.getKind() != Kind.BLOCK) {
                return;
            }
            final JavaController javaController = new JavaController();
            String[] stringArray = new String[1];
            javaController.getObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.INTERFACE_FUNCTION, stringArray);
            BlockInterFunction blockInterFunction = XcosCellFactory.lookForInterfunction(stringArray[0]);
            if (blockInterFunction.equals((Object)BlockInterFunction.SUPER_f)) {
                Object object2;
                XcosDiagram xcosDiagram2 = Xcos.findDiagram(xcosCell.getUID());
                if (xcosDiagram2 == null) {
                    xcosDiagram2 = new XcosDiagram(javaController, xcosCell.getUID(), xcosCell.getKind(), xcosCell.getId());
                    XcosCellFactory.insertChildren(javaController, xcosDiagram2);
                    object2 = Xcos.findRoot(xcosDiagram);
                    Xcos.getInstance().addDiagram((ScicosObjectOwner)object2, xcosDiagram2);
                    xcosDiagram2.setModified(false);
                    xcosDiagram2.setModified(Xcos.getInstance().isModified((ScicosObjectOwner)object2));
                    String[] stringArray2 = new String[]{""};
                    javaController.getObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.UID, stringArray2);
                    Optional<DocumentType> optional = ConfigurationManager.getInstance().streamTab().filter(documentType -> stringArray2[0].equals(documentType.getPath())).findFirst();
                    if (optional.isPresent()) {
                        xcosDiagram2.setGraphTab(optional.get().getUuid());
                    }
                    xcosDiagram2.getUndoManager().clear();
                    xcosDiagram2.installListeners();
                }
                if ((object2 = XcosTab.get(xcosDiagram2)) == null) {
                    XcosTab.restore(xcosDiagram2);
                } else {
                    object2.setCurrent();
                    object2.requestFocus();
                }
            } else {
                final BasicBlock basicBlock = (BasicBlock)xcosCell;
                if (basicBlock.isLocked()) {
                    return;
                }
                xcosDiagram.setCellsLocked(true);
                xcosDiagram.getAsComponent().getGraphControl().setCursor(Cursor.getPredefinedCursor(3));
                JavaController.register_view(Xcos.class.getName(), Xcos.getInstance().getXcosView());
                try {
                    Object object3;
                    ActionListener actionListener = new ActionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            xcosDiagram.getView().clear((Object)this, true, true);
                            xcosDiagram.getModel().beginUpdate();
                            try {
                                BasicBlock basicBlock2;
                                ScicosObjectOwner scicosObjectOwner = XcosCellFactory.getLastCreated();
                                if (scicosObjectOwner != null && scicosObjectOwner.getUID() != 0L && (basicBlock2 = XcosCellFactory.createBlock(javaController, scicosObjectOwner)) != null) {
                                    basicBlock.updateBlockSettings(javaController, xcosDiagram, basicBlock2);
                                }
                                BlockPositioning.updateBlockView(xcosDiagram, basicBlock);
                            }
                            finally {
                                xcosDiagram.getModel().endUpdate();
                                basicBlock.setLocked(false);
                                xcosDiagram.getAsComponent().getGraphControl().setCursor(Cursor.getPredefinedCursor(0));
                                xcosDiagram.setCellsLocked(false);
                                JavaController.unregister_view(Xcos.getInstance().getXcosView());
                            }
                        }
                    };
                    ScilabDirectHandler scilabDirectHandler = ScilabDirectHandler.acquire();
                    try {
                        object3 = new ScicosParameters(Xcos.findRoot(xcosDiagram), new ScicosObjectOwner(javaController, xcosDiagram.getUID(), xcosDiagram.getKind()));
                        scilabDirectHandler.writeContext(((ScicosParameters)object3).getAllContext(javaController));
                    }
                    finally {
                        scilabDirectHandler.release();
                    }
                    basicBlock.setLocked(true);
                    object3 = ScilabInterpreterManagement.buildCall((String)"scicos_new", (Object[])new Object[]{Long.toHexString(xcosCell.getUID())});
                    String string = ScilabInterpreterManagement.buildCall((String)"xcosBlockInterface", (Object[])new Object[]{stringArray[0].toCharArray(), "set", ((String)object3).toCharArray(), "context".toCharArray()});
                    ScilabInterpreterManagement.asynchronousScilabExec((ActionListener)actionListener, (String)"xcosCellCreated", (Object[])new Object[]{string.toCharArray()});
                }
                catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
                    basicBlock.setLocked(false);
                    xcosDiagram.getAsComponent().getGraphControl().setCursor(Cursor.getPredefinedCursor(0));
                    xcosDiagram.setCellsLocked(false);
                }
            }
        }
    }
}

