/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import org.scilab.modules.graph.ScilabComponent;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.actions.SimulationNotRunningAction;
import org.scilab.modules.xcos.actions.dialog.DebugLevelDialog;
import org.scilab.modules.xcos.graph.ScicosParameters;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class DebugLevelAction
extends SimulationNotRunningAction {
    public static final String NAME = XcosMessages.SET_DEBUG;
    public static final String SMALL_ICON = "";
    public static final int MNEMONIC_KEY = 0;
    public static final int ACCELERATOR_KEY = 0;

    public DebugLevelAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        XcosDiagram xcosDiagram = (XcosDiagram)this.getGraph(actionEvent);
        ScilabComponent scilabComponent = (ScilabComponent)xcosDiagram.getAsComponent();
        if (scilabComponent.isEditing()) {
            return;
        }
        DebugLevelDialog debugLevelDialog = new DebugLevelDialog((Component)xcosDiagram.getAsComponent(), new ScicosParameters(Xcos.findRoot(xcosDiagram), new ScicosObjectOwner(xcosDiagram.getUID(), xcosDiagram.getKind())));
        debugLevelDialog.pack();
        debugLevelDialog.setVisible(true);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return DebugLevelAction.createMenu((ScilabGraph)scilabGraph, DebugLevelAction.class);
    }

    public static enum DebugLevel {
        ZERO(0, XcosMessages.DEBUGLEVEL_0),
        ONE(1, XcosMessages.DEBUGLEVEL_1),
        TWO(2, XcosMessages.DEBUGLEVEL_2),
        THREE(3, XcosMessages.DEBUGLEVEL_3);

        private int level;
        private String debugName;

        private DebugLevel(int n2, String string2) {
            this.level = n2;
            this.debugName = string2;
        }

        public int getValue() {
            return this.level;
        }

        public String toString() {
            return this.debugName;
        }
    }
}

