/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.UpdateStatus;
import org.scilab.modules.xcos.View;
import org.scilab.modules.xcos.XcosViewListener;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;

public final class XcosView
extends View {
    private final EnumMap<Kind, ArrayList<Entry>> registeredListeners = new EnumMap(Kind.class);
    private final HashMap<Long, Object> visibleObjects = new HashMap();

    public HashMap<Long, Object> getVisibleObjects() {
        return this.visibleObjects;
    }

    @Override
    public final void objectCreated(final long l, final Kind kind) {
        List list = this.registeredListeners.get((Object)kind);
        if (list == null) {
            return;
        }
        for (final Entry entry : list) {
            if (entry.onCallerThread) {
                entry.listener.objectCreated(l, kind);
                continue;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    entry.listener.objectCreated(l, kind);
                }
            });
        }
    }

    @Override
    public final void objectReferenced(final long l, final Kind kind, final long l2) {
        List list = this.registeredListeners.get((Object)kind);
        if (list == null) {
            return;
        }
        for (final Entry entry : list) {
            if (entry.onCallerThread) {
                entry.listener.objectReferenced(l, kind, l2);
                continue;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    entry.listener.objectReferenced(l, kind, l2);
                }
            });
        }
    }

    @Override
    public final void objectUnreferenced(final long l, final Kind kind, final long l2) {
        List list = this.registeredListeners.get((Object)kind);
        if (list == null) {
            return;
        }
        for (final Entry entry : list) {
            if (entry.onCallerThread) {
                entry.listener.objectUnreferenced(l, kind, l2);
                continue;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    entry.listener.objectUnreferenced(l, kind, l2);
                }
            });
        }
    }

    @Override
    public final void objectDeleted(final long l, final Kind kind) {
        List list = this.registeredListeners.get((Object)kind);
        if (list == null) {
            return;
        }
        for (final Entry entry : list) {
            if (entry.onCallerThread) {
                entry.listener.objectDeleted(l, kind);
                continue;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    entry.listener.objectDeleted(l, kind);
                }
            });
        }
    }

    @Override
    public void objectCloned(long l, long l2, Kind kind) {
    }

    @Override
    public final void propertyUpdated(long l, Kind kind, ObjectProperties objectProperties, UpdateStatus updateStatus) {
        List list = this.registeredListeners.get((Object)kind);
        if (list == null) {
            return;
        }
        ScicosObjectOwner scicosObjectOwner = new ScicosObjectOwner(l, kind);
        for (Entry entry : list) {
            if (entry.onCallerThread) {
                if (!entry.listenedProperties.contains((Object)objectProperties)) continue;
                entry.listener.propertyUpdated(scicosObjectOwner, objectProperties, updateStatus);
                continue;
            }
            if (!entry.listenedProperties.contains((Object)objectProperties)) continue;
            SwingUtilities.invokeLater(new PropertyUpdatedRunnable(entry, scicosObjectOwner, objectProperties, updateStatus));
        }
    }

    public void addXcosViewListener(XcosViewListener xcosViewListener) {
        this.addXcosViewListener(xcosViewListener, EnumSet.allOf(Kind.class), false, EnumSet.allOf(ObjectProperties.class));
    }

    public void addXcosViewListener(XcosViewListener xcosViewListener, Kind kind) {
        this.addXcosViewListener(xcosViewListener, EnumSet.of(kind), false, EnumSet.allOf(ObjectProperties.class));
    }

    public void addXcosViewListener(XcosViewListener xcosViewListener, Kind kind, ObjectProperties objectProperties) {
        this.addXcosViewListener(xcosViewListener, EnumSet.of(kind), false, EnumSet.of(objectProperties));
    }

    public void addXcosViewListener(XcosViewListener xcosViewListener, boolean bl) {
        this.addXcosViewListener(xcosViewListener, EnumSet.allOf(Kind.class), bl, EnumSet.allOf(ObjectProperties.class));
    }

    public void addXcosViewListener(XcosViewListener xcosViewListener, EnumSet<Kind> enumSet, boolean bl, EnumSet<ObjectProperties> enumSet2) {
        for (Kind kind : enumSet) {
            ArrayList<Entry> arrayList = this.registeredListeners.get((Object)kind);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.registeredListeners.put(kind, arrayList);
            }
            arrayList.add(new Entry(bl, enumSet2, xcosViewListener));
        }
    }

    public void removeXcosViewListener(XcosViewListener xcosViewListener) {
        for (Kind kind : EnumSet.allOf(Kind.class)) {
            ArrayList<Entry> arrayList = this.registeredListeners.get((Object)kind);
            if (arrayList == null) continue;
            arrayList.removeIf(entry -> entry.listener == xcosViewListener);
        }
    }

    private static final class Entry {
        XcosViewListener listener;
        boolean onCallerThread;
        EnumSet<ObjectProperties> listenedProperties;

        public Entry(boolean bl, EnumSet<ObjectProperties> enumSet, XcosViewListener xcosViewListener) {
            this.listener = xcosViewListener;
            this.onCallerThread = bl;
            this.listenedProperties = enumSet;
        }
    }

    private static final class PropertyUpdatedRunnable
    implements Runnable {
        private final Entry e;
        private final ScicosObjectOwner owner;
        private final ObjectProperties property;
        private final UpdateStatus status;

        public PropertyUpdatedRunnable(Entry entry, ScicosObjectOwner scicosObjectOwner, ObjectProperties objectProperties, UpdateStatus updateStatus) {
            this.e = entry;
            this.owner = scicosObjectOwner;
            this.property = objectProperties;
            this.status = updateStatus;
        }

        @Override
        public void run() {
            this.e.listener.propertyUpdated(this.owner, this.property, this.status);
        }
    }
}

