/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.rosetta.ui;

import com.artenum.rosetta.interfaces.ui.OutputView;
import com.artenum.rosetta.util.BufferedWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;

public class BufferedOutputViewImpl
extends JTextPane
implements OutputView,
Runnable {
    private static final long serialVersionUID = 1L;
    private String activeStyle = "default";
    private String lastAppendedStyle;
    private BlockingQueue<StringBuffer> bufferQueue = new ArrayBlockingQueue<StringBuffer>(6);
    private LinkedList<String> styleQueue = new LinkedList();
    private StringBuffer currentWorkingBuffer;

    public BufferedOutputViewImpl() {
        Thread thread = new Thread(this);
        thread.setPriority(1);
        thread.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    StringBuffer buffer = this.bufferQueue.take();
                    String style = this.styleQueue.poll();
                    this.getStyledDocument().insertString(this.getStyledDocument().getLength(), buffer.toString(), this.getStyledDocument().getStyle(style));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void append(String content) {
        this.append(content, this.activeStyle);
    }

    public void append(String content, String styleName) {
        if (styleName.equals(this.lastAppendedStyle) && this.bufferQueue.size() > 1) {
            this.currentWorkingBuffer.append(content);
        } else {
            this.lastAppendedStyle = styleName;
            this.styleQueue.add(this.lastAppendedStyle);
            try {
                this.currentWorkingBuffer = new StringBuffer(content);
                this.bufferQueue.put(this.currentWorkingBuffer);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public Writer getErrorWriter() {
        return new BufferedWriter("default", this.bufferQueue, this.styleQueue);
    }

    public Writer getWriter() {
        return new BufferedWriter("default", this.bufferQueue, this.styleQueue);
    }

    public void reset() {
        try {
            this.getStyledDocument().remove(0, this.getStyledDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.setCaretPosition(0);
    }

    public void setCaretPositionToBeginning() {
        this.setCaretPosition(0);
    }

    public void setCaretPositionToEnd() {
        this.setCaretPosition(this.getStyledDocument().getLength());
    }

    public void setStyleName(String styleName) {
        this.activeStyle = styleName;
    }
}

