/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.PolylineData;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.renderer.CallRenderer;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.axes.AxesDrawer;
import org.scilab.modules.renderer.utils.AxesHandler;
import org.scilab.modules.renderer.utils.CommonHandler;
import org.scilab.modules.renderer.utils.EntityPicker;
import org.scilab.modules.renderer.utils.ObjectSearcher;
import org.scilab.modules.renderer.utils.PolylineHandler;

public class DataEditor {
    JPopupMenu menu;
    JMenuItem remove;
    JMenuItem insert;
    JMenuItem exit;
    polylineStyle savedStyle;
    Integer curPolyline = null;
    EntityPicker picker;
    EntityPicker.PickedPoint picked = null;
    Integer axes;
    Integer[] rClickPos = new Integer[]{0, 0};

    public DataEditor() {
        this.init();
    }

    private void init() {
        this.menu = new JPopupMenu();
        this.insert = new JMenuItem(Messages.gettext((String)"Insert"));
        this.insert.setToolTipText(Messages.gettext((String)"Insert a new point here"));
        this.remove = new JMenuItem(Messages.gettext((String)"Remove"));
        this.remove.setToolTipText(Messages.gettext((String)"Remove this point"));
        this.exit = new JMenuItem(Messages.gettext((String)"Exit"));
        this.exit.setToolTipText(Messages.gettext((String)"Leave data editor mode"));
        this.insert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataEditor.this.onClickInsert(DataEditor.this.rClickPos);
            }
        });
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataEditor.this.onClickRemove(DataEditor.this.picked.point);
            }
        });
        this.menu.add(this.insert);
        this.menu.add(this.remove);
        this.menu.add(this.exit);
        this.savedStyle = new polylineStyle();
        this.picker = new EntityPicker();
    }

    public void setLeaveAction(ActionListener actionListener) {
        this.exit.addActionListener(actionListener);
    }

    public void beginEdit(Integer n) {
        this.savedStyle.Save(n);
        this.savedStyle.changeToEditStyle(n);
        this.curPolyline = n;
        this.axes = new ObjectSearcher().searchParent(this.curPolyline, Integer.valueOf(1));
    }

    public void endEdit() {
        this.savedStyle.Restore(this.curPolyline);
    }

    public void onLeftMouseDown(MouseEvent mouseEvent) {
        this.picked = this.picker.pickPoint(this.curPolyline, mouseEvent.getX(), mouseEvent.getY());
        if (this.picked != null && this.picked.point != -1) {
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(this.curPolyline);
            Integer n = graphicObject.getParentFrameOrFigure();
            DrawerVisitor.getVisitor((Integer)n).getInteractionManager().setTranslationEnable(false);
        }
    }

    public void onLeftMouseRelease(MouseEvent mouseEvent) {
        if (this.picked != null && this.picked.point != -1) {
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(this.curPolyline);
            Integer n = graphicObject.getParentFrameOrFigure();
            DrawerVisitor.getVisitor((Integer)n).getInteractionManager().setTranslationEnable(true);
        }
    }

    public void onDrag(Integer[] integerArray, Integer[] integerArray2) {
        if (this.picked != null && this.picked.point != -1) {
            if (!this.picked.isSegment) {
                Vector3d vector3d;
                double[] dArray = (double[])PolylineData.getDataX((int)this.curPolyline);
                double[] dArray2 = (double[])PolylineData.getDataY((int)this.curPolyline);
                double[] dArray3 = (double[])PolylineData.getDataZ((int)this.curPolyline);
                Vector3d vector3d2 = new Vector3d(dArray[this.picked.point], dArray2[this.picked.point], dArray3[this.picked.point]);
                double[] dArray4 = new double[]{integerArray2[0].doubleValue(), integerArray2[1].doubleValue(), 1.0};
                double[] dArray5 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axes, (double[])dArray4);
                Axes axes = AxesHandler.getAxesFromUid((Integer)this.axes);
                double[] dArray6 = AxesDrawer.compute3dViewCoordinates((Axes)axes, (double[])dArray5);
                dArray5[2] = dArray5[2] + 1.0;
                double[] dArray7 = AxesDrawer.compute3dViewCoordinates((Axes)axes, (double[])dArray5);
                Vector3d vector3d3 = new Vector3d(dArray7);
                Vector3d vector3d4 = vector3d3.minus(vector3d = new Vector3d(dArray6));
                if (vector3d4.getZ() == 0.0) {
                    return;
                }
                double d = (vector3d2.getZ() - vector3d.getZ()) / vector3d4.getZ();
                Vector3d vector3d5 = vector3d4.times(d);
                vector3d5 = vector3d5.plus(vector3d);
                PolylineData.translatePoint((int)this.curPolyline, (int)this.picked.point, (double)(vector3d5.getX() - vector3d2.getX()), (double)(vector3d5.getY() - vector3d2.getY()), (double)0.0, (int)0, (int)0, (int)0);
            } else {
                PolylineHandler.getInstance().dragPolyline(this.curPolyline, integerArray, integerArray2);
            }
        }
    }

    public void onRightClick(MouseEvent mouseEvent) {
        this.picked = this.picker.pickPoint(this.curPolyline, mouseEvent.getX(), mouseEvent.getY());
        this.rClickPos[0] = mouseEvent.getX();
        this.rClickPos[1] = mouseEvent.getY();
        if (this.picked.point != -1) {
            if (!this.picked.isSegment) {
                this.remove.setEnabled(true);
                this.insert.setEnabled(false);
            } else {
                this.remove.setEnabled(false);
                this.insert.setEnabled(true);
            }
        } else {
            this.remove.setEnabled(false);
            this.insert.setEnabled(false);
        }
        this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void onLeftDoubleClick(MouseEvent mouseEvent) {
        this.picked = this.picker.pickPoint(this.curPolyline, mouseEvent.getX(), mouseEvent.getY());
        if (this.picked.point != -1) {
            if (!this.picked.isSegment) {
                PolylineData.removePoint((int)this.curPolyline, (int)this.picked.point);
            } else {
                double[] dArray = new double[]{1.0 * (double)mouseEvent.getX(), 1.0 * (double)mouseEvent.getY(), 1.0};
                double[] dArray2 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axes, (double[])dArray);
                double[] dArray3 = CommonHandler.computeIntersection((Integer)this.curPolyline, (int)this.picked.point, (double[])dArray2);
                PolylineData.insertPoint((int)this.curPolyline, (int)this.picked.point, (double)dArray3[0], (double)dArray3[1], (double)dArray3[2]);
            }
        }
    }

    void onClickRemove(int n) {
        PolylineData.removePoint((int)this.curPolyline, (int)n);
    }

    void onClickInsert(Integer[] integerArray) {
        this.picked = this.picker.pickPoint(this.curPolyline, integerArray[0].intValue(), integerArray[1].intValue());
        double[] dArray = new double[]{1.0 * (double)integerArray[0].intValue(), 1.0 * (double)integerArray[1].intValue(), 1.0};
        double[] dArray2 = CallRenderer.get2dViewFromPixelCoordinates((int)this.axes, (double[])dArray);
        double[] dArray3 = CommonHandler.computeIntersection((Integer)this.curPolyline, (int)this.picked.point, (double[])dArray2);
        PolylineData.insertPoint((int)this.curPolyline, (int)this.picked.point, (double)dArray3[0], (double)dArray3[1], (double)dArray3[2]);
    }

    public class polylineStyle {
        Integer lineFgColor;
        Integer lineBgColor;
        Double lineSize;
        Integer lineStyle;
        Boolean lineEnabled;
        Boolean filed;
        Boolean closed;
        Boolean interp;
        Integer markFgColor;
        Integer markBgColor;
        Boolean markEnabled;
        Integer markStyle;
        Integer markSizeUnit;
        Integer markSize;
        boolean canRestore = false;

        void Save(Integer n) {
            this.lineFgColor = (Integer)GraphicController.getController().getProperty(n, 195);
            this.lineBgColor = (Integer)GraphicController.getController().getProperty(n, 96);
            this.lineSize = (Double)GraphicController.getController().getProperty(n, 194);
            this.lineEnabled = (Boolean)GraphicController.getController().getProperty(n, 192);
            this.lineStyle = (Integer)GraphicController.getController().getProperty(n, 241);
            this.filed = (Boolean)GraphicController.getController().getProperty(n, 196);
            this.closed = (Boolean)GraphicController.getController().getProperty(n, 239);
            this.interp = (Boolean)GraphicController.getController().getProperty(n, 243);
            this.markFgColor = (Integer)GraphicController.getController().getProperty(n, 202);
            this.markBgColor = (Integer)GraphicController.getController().getProperty(n, 203);
            this.markEnabled = (Boolean)GraphicController.getController().getProperty(n, 198);
            this.markStyle = (Integer)GraphicController.getController().getProperty(n, 199);
            this.markSizeUnit = (Integer)GraphicController.getController().getProperty(n, 200);
            this.markSize = (Integer)GraphicController.getController().getProperty(n, 201);
            this.canRestore = true;
        }

        void Restore(Integer n) {
            if (this.canRestore) {
                GraphicController.getController().setProperty(n, 195, (Object)this.lineFgColor);
                GraphicController.getController().setProperty(n, 96, (Object)this.lineBgColor);
                GraphicController.getController().setProperty(n, 194, (Object)this.lineSize);
                GraphicController.getController().setProperty(n, 192, (Object)this.lineEnabled);
                GraphicController.getController().setProperty(n, 241, (Object)this.lineStyle);
                GraphicController.getController().setProperty(n, 196, (Object)this.filed);
                GraphicController.getController().setProperty(n, 239, (Object)this.closed);
                GraphicController.getController().setProperty(n, 243, (Object)this.interp);
                GraphicController.getController().setProperty(n, 202, (Object)this.markFgColor);
                GraphicController.getController().setProperty(n, 203, (Object)this.markBgColor);
                GraphicController.getController().setProperty(n, 198, (Object)this.markEnabled);
                GraphicController.getController().setProperty(n, 199, (Object)this.markStyle);
                GraphicController.getController().setProperty(n, 200, (Object)this.markSizeUnit);
                GraphicController.getController().setProperty(n, 201, (Object)this.markSize);
            }
        }

        private polylineStyle setDefaulStyle() {
            this.lineFgColor = -3;
            this.lineBgColor = -2;
            this.lineSize = 1.0;
            this.lineStyle = 1;
            this.lineEnabled = true;
            this.filed = false;
            this.closed = false;
            this.interp = false;
            this.markFgColor = -3;
            this.markBgColor = -2;
            this.markEnabled = true;
            this.markStyle = 11;
            this.markSizeUnit = 0;
            this.markSize = 6;
            this.canRestore = true;
            return this;
        }

        public void changeToEditStyle(Integer n) {
            polylineStyle polylineStyle2 = new polylineStyle();
            polylineStyle2.setDefaulStyle();
            polylineStyle2.Restore(n);
        }
    }
}

