/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.waitbar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.waitbar.SimpleWaitBar;

public class SwingScilabWaitBar
extends JFrame
implements SwingViewObject,
SimpleWaitBar {
    private static final long serialVersionUID = -5208590743368628657L;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 150;
    private Integer uid;
    private int elementId;
    private final JProgressBar progressBar;
    private final JLabel messageLabel;
    private final ImageIcon scilabIcon = new ImageIcon(FindIconHelper.findIcon((String)"scilab"));

    public SwingScilabWaitBar() {
        this.setIconImage(this.scilabIcon.getImage());
        GridBagLayout gridBagLayout = new GridBagLayout();
        Insets insets = new Insets(8, 4, 8, 4);
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setOpaque(true);
        this.setContentPane(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = insets;
        JLabel jLabel = new JLabel();
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jLabel.setIcon(this.scilabIcon);
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = insets;
        this.messageLabel = new JLabel();
        gridBagLayout.setConstraints(this.messageLabel, gridBagConstraints2);
        jPanel.add(this.messageLabel);
        this.messageLabel.setVisible(true);
        this.progressBar = new JProgressBar();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = insets;
        gridBagConstraints3.weightx = 1.0;
        gridBagLayout.setConstraints(this.progressBar, gridBagConstraints3);
        jPanel.add(this.progressBar);
        this.progressBar.setVisible(true);
        jPanel.setVisible(true);
        jPanel.doLayout();
        this.setSize(450, 150);
        this.setPreferredSize(new Dimension(450, 150));
        this.setMinimumSize(new Dimension(450, 150));
        if (ScilabConsole.isExistingConsole()) {
            this.setLocationRelativeTo((Component)((Object)ScilabConsole.getConsole().getAsSimpleConsole()));
        }
        this.setVisible(true);
        this.doLayout();
        this.pack();
    }

    @Override
    public void setElementId(int n) {
        this.elementId = n;
    }

    @Override
    public int getElementId() {
        return this.elementId;
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
    }

    @Override
    public void setMessage(String[] stringArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("<HTML>");
        for (n = 0; n < stringArray.length - 1; ++n) {
            stringBuffer.append(stringArray[n] + "<br>");
        }
        stringBuffer.append(stringArray[n] + "</HTML>");
        this.messageLabel.setText(stringBuffer.toString());
    }

    @Override
    public void setValue(int n) {
        this.progressBar.setValue(n);
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void setIndeterminateMode(boolean bl) {
        this.progressBar.setIndeterminate(bl);
        this.progressBar.setStringPainted(!bl);
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        if (n == 336) {
            this.setMessage((String[])object);
        } else if (n == 317) {
            this.setValue((Integer)object);
        }
    }
}

