/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.helpbrowser;

import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import javax.help.DefaultHelpHistoryModel;
import javax.help.HelpSet;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.help.plaf.basic.BasicContentViewerUI;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.html.HTMLDocument;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.gui.ScilabKeyStroke;
import org.scilab.modules.gui.bridge.helpbrowser.SwingScilabHelpBrowser;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.helpbrowser.ScilabHelpBrowser;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.gui.utils.WebBrowser;
import org.scilab.modules.localization.Messages;

public class SwingScilabHelpBrowserViewer
extends BasicContentViewerUI
implements MouseWheelListener {
    private static final String SCILAB_PROTO = "scilab://";
    private static final String FILE_PROTO = "file://";
    private static final String SCI = ScilabConstants.SCI.getPath().replaceAll("\\\\", "/");
    private static final String SHIFTEQ = "shiftEquals";
    private static final long serialVersionUID = -2593697956426596790L;
    private static final int[] fontSizes = new int[]{8, 10, 12, 14, 18, 24, 36};
    private static final boolean isMac = System.getProperty("os.name").toLowerCase().contains("mac");
    private static int currentFontSize = ConfigManager.getHelpFontSize();
    private JEditorPane accessibleHtml;
    private final JHelpContentViewer x;
    private List<HelpSet> helpSets;

    public SwingScilabHelpBrowserViewer(JHelpContentViewer jHelpContentViewer) {
        super(jHelpContentViewer);
        this.x = jHelpContentViewer;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SwingScilabHelpBrowserViewer((JHelpContentViewer)jComponent);
    }

    public JEditorPane getAccessibleHTML() {
        return this.accessibleHtml;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (hyperlinkEvent.getDescription().startsWith("http://") || hyperlinkEvent.getDescription().startsWith("https://") || hyperlinkEvent.getDescription().startsWith("ftp://")) {
                WebBrowser.openUrl(hyperlinkEvent.getURL(), hyperlinkEvent.getDescription());
            } else if (hyperlinkEvent.getDescription().startsWith(SCILAB_PROTO)) {
                URL uRL;
                if (this.helpSets == null) {
                    this.initHelpSets(this.x.getModel().getHelpSet());
                }
                if ((uRL = this.resolvScilabLink(hyperlinkEvent)) != null) {
                    super.hyperlinkUpdate(new HyperlinkEvent(hyperlinkEvent.getSource(), hyperlinkEvent.getEventType(), uRL, ""));
                }
            } else if (hyperlinkEvent.getDescription().startsWith(FILE_PROTO)) {
                String string = hyperlinkEvent.getDescription();
                string = string.replaceFirst("SCI", Matcher.quoteReplacement(SCI));
                WebBrowser.openUrl(string);
            } else {
                super.hyperlinkUpdate(hyperlinkEvent);
            }
        }
    }

    private void initHelpSets(HelpSet helpSet) {
        this.helpSets = new ArrayList<HelpSet>();
        this.helpSets.add(helpSet);
        Enumeration enumeration = helpSet.getHelpSets();
        while (enumeration.hasMoreElements()) {
            this.helpSets.add((HelpSet)enumeration.nextElement());
        }
    }

    public URL getURLFromID(String string) {
        URL uRL = null;
        try {
            for (HelpSet helpSet : this.helpSets) {
                Map map = helpSet.getLocalMap();
                if (!map.isValidID(string, helpSet) || (uRL = map.getURLFromID(Map.ID.create((String)string, (HelpSet)helpSet))) == null) continue;
                return uRL;
            }
            uRL = new URL(this.helpSets.get(0).getHelpSetURL().toString().replace("jhelpset.hs", "ScilabErrorPage.html"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public URL getURLFromID(String string, String string2) {
        if (string == null) {
            return this.getURLFromID(string2);
        }
        URL uRL = null;
        try {
            for (HelpSet helpSet : this.helpSets) {
                Map map;
                if (!helpSet.getHelpSetURL().toString().replaceAll("\\\\", "/").contains("/" + string + "/") || !(map = helpSet.getLocalMap()).isValidID(string2, helpSet) || (uRL = map.getURLFromID(Map.ID.create((String)string2, (HelpSet)helpSet))) == null) continue;
                return uRL;
            }
            uRL = new URL(this.helpSets.get(0).getHelpSetURL().toString().replace("jhelpset.hs", "ScilabErrorPage.html"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public URL resolvScilabLink(HyperlinkEvent hyperlinkEvent) {
        String string;
        int n = SCILAB_PROTO.length();
        String string2 = hyperlinkEvent.getDescription();
        string2 = string2.trim().replaceAll("\\\\", "/");
        string2 = string2.substring(n);
        n = string2.indexOf("/");
        String string3 = "";
        if (n != -1) {
            string = string2.substring(0, n);
            if (n != string2.length()) {
                string3 = string2.substring(n + 1);
            }
        } else {
            return this.getURLFromID(string2);
        }
        String[] stringArray = string.split("\\.");
        String string4 = null;
        if (stringArray.length >= 1) {
            string4 = stringArray[0];
        }
        if (stringArray.length < 2) {
            System.err.println("Unable decode the Scilab content type\n" + hyperlinkEvent.getDescription());
            return null;
        }
        String string5 = stringArray[1];
        switch (string5) {
            case "help": {
                if ("scilab".equals(string4)) {
                    return this.getURLFromID(string3);
                }
                return this.getURLFromID(string4, string3);
            }
            case "xcos": 
            case "scinotes": {
                if ("scilab".equals(string4)) {
                    this.exec(string5, SCI + "/modules/" + string3);
                    break;
                }
                this.exec(string5, this.getToolboxPath() + "/" + string3);
                break;
            }
            case "demos": {
                if ("scilab".equals(string4)) {
                    this.exec(SCI + "/modules/" + string3 + ".sce");
                    break;
                }
                this.exec(this.getToolboxPath() + "/demos/" + string3 + ".sce");
                break;
            }
            case "execexample": {
                this.execExample(hyperlinkEvent.getSourceElement().getParentElement().getParentElement().getParentElement().getElement(0).getElement(0));
                break;
            }
            case "editexample": {
                SwingScilabHelpBrowserViewer.editExample(hyperlinkEvent.getSourceElement().getParentElement().getParentElement().getParentElement().getElement(0).getElement(0));
                break;
            }
            case "exec": {
                if (string4.equals("scilab")) {
                    this.exec(SCI + "/modules/" + string3);
                    break;
                }
                this.exec(this.getToolboxPath() + "/" + string3);
            }
        }
        return null;
    }

    public String getToolboxPath() {
        try {
            URL uRL = ((JarURLConnection)this.x.getCurrentURL().openConnection()).getJarFileURL();
            return new File(uRL.toURI()).getParentFile().getParent();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getCurrentURL() {
        return this.x.getCurrentURL().toString();
    }

    public void execExample(Element element) {
        String string = SwingScilabHelpBrowserViewer.getCode(element);
        try {
            ScilabConsole.getConsole().getAsSimpleConsole().sendCommandsToScilab(string, true, false);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ScilabModalDialog.show((SimpleTab)((Object)SwingUtilities.getAncestorOfClass(SimpleTab.class, (Component)this.x)), Messages.gettext((String)"Feature not available in this mode..."));
        }
    }

    public static void editExample(Element element) {
        SwingScilabHelpBrowserViewer.edit(SwingScilabHelpBrowserViewer.getCode(element));
    }

    private static void edit(String string) {
        try {
            Class<?> clazz = Class.forName("org.scilab.modules.scinotes.SciNotes");
            Class[] classArray = new Class[]{String.class};
            Method method = clazz.getMethod("scinotesWithText", classArray);
            method.invoke(clazz, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find SciNotes class");
            classNotFoundException.printStackTrace();
        }
        catch (SecurityException securityException) {
            System.err.println("Security error: Could not access to SciNotes class");
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Could not access to scinotesWithText method from object SciNotes");
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Wrong argument used with scinotesWithText method from object SciNotes");
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Illegal access with scinotesWithText method from object SciNotes");
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("Error of invocation with scinotesWithText method from object SciNotes");
            invocationTargetException.printStackTrace();
        }
    }

    private static String getCode(Element element) {
        int n = element.getElementCount();
        Document document = element.getDocument();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            int n2 = element2.getElementCount();
            for (int j = 0; j < n2; ++j) {
                Element element3 = element2.getElement(j);
                if (!element3.isLeaf()) continue;
                try {
                    stringBuilder.append(document.getText(element3.getStartOffset(), element3.getEndOffset() - element3.getStartOffset()));
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return stringBuilder.toString().trim();
    }

    public void exec(String string) {
        String string2 = "exec('" + string + "', -1)";
        try {
            ScilabInterpreterManagement.asynchronousScilabExec(null, (String)string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exec(String string, String string2) {
        String string3 = string + "('" + string2 + "')";
        try {
            ScilabInterpreterManagement.asynchronousScilabExec(null, (String)string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.retrievePrivateFieldFromBasicContentViewerUI();
        this.createPopupMenu(jComponent);
    }

    private void retrievePrivateFieldFromBasicContentViewerUI() {
        Field field = null;
        try {
            field = BasicContentViewerUI.class.getDeclaredField("html");
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            System.err.println("Security error: Could not change the accessibility on the html component of the help browser.");
            System.err.println("Please submit a bug report: https://gitlab.com/scilab/scilab/-/issues");
            securityException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            System.err.println("Could not find the field of the html component of the help browser.");
            System.err.println("Please submit a bug report: https://gitlab.com/scilab/scilab/-/issues");
            noSuchFieldException.printStackTrace();
        }
        try {
            this.accessibleHtml = (JEditorPane)field.get(this);
            this.accessibleHtml.setMinimumSize(new Dimension(0, 0));
            this.accessibleHtml.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            this.accessibleHtml.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        if (propertyChangeEvent.getPropertyName().equals("document")) {
                            SwingScilabHelpBrowserViewer.this.accessibleHtml.setVisible(false);
                        }
                        if (propertyChangeEvent.getPropertyName().equals("page")) {
                            SwingScilabHelpBrowserViewer.this.modifyFontInEDT(0);
                            if (!SwingScilabHelpBrowserViewer.this.accessibleHtml.isVisible()) {
                                SwingScilabHelpBrowserViewer.this.accessibleHtml.setVisible(true);
                            }
                        }
                    }
                }
            });
            this.accessibleHtml.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

                @Override
                public Component getFirstComponent(Container container) {
                    return SwingScilabHelpBrowserViewer.this.x;
                }
            });
            this.accessibleHtml.setFocusCycleRoot(true);
            String string = "alt ";
            if (isMac) {
                string = "meta ";
            }
            InputMap inputMap = this.accessibleHtml.getInputMap(2);
            inputMap.put(ScilabKeyStroke.getKeyStroke((String)"OSSCKEY shift EQUALS"), SHIFTEQ);
            this.accessibleHtml.getActionMap().put(SHIFTEQ, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingScilabHelpBrowserViewer.this.increaseFont();
                }
            });
            inputMap.put(ScilabKeyStroke.getKeyStroke((String)(string + "LEFT")), "Previous-page");
            this.accessibleHtml.getActionMap().put("Previous-page", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultHelpHistoryModel defaultHelpHistoryModel = SwingScilabHelpBrowser.getHelpHistory();
                    if (defaultHelpHistoryModel.getIndex() > 0) {
                        defaultHelpHistoryModel.goBack();
                    }
                }
            });
            inputMap.put(ScilabKeyStroke.getKeyStroke((String)(string + "RIGHT")), "Next-page");
            this.accessibleHtml.getActionMap().put("Next-page", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultHelpHistoryModel defaultHelpHistoryModel = SwingScilabHelpBrowser.getHelpHistory();
                    if (defaultHelpHistoryModel.getHistory().size() != defaultHelpHistoryModel.getIndex() + 1) {
                        defaultHelpHistoryModel.goForward();
                    }
                }
            });
            inputMap = this.accessibleHtml.getInputMap(0);
            inputMap.put(ScilabKeyStroke.getKeyStroke((String)(string + "LEFT")), new Object());
            inputMap.put(ScilabKeyStroke.getKeyStroke((String)(string + "RIGHT")), new Object());
            inputMap.put(ScilabKeyStroke.getKeyStroke((String)"shift SPACE"), inputMap.get(ScilabKeyStroke.getKeyStroke((String)"PAGE_UP")));
            inputMap.put(ScilabKeyStroke.getKeyStroke((String)"SPACE"), inputMap.get(ScilabKeyStroke.getKeyStroke((String)"PAGE_DOWN")));
            SwingUtilities.getAncestorOfClass(JScrollPane.class, this.accessibleHtml).addMouseWheelListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Illegal argument in the retrieval of the html component of Javahelp");
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Illegal access in the retrieval of the html component of Javahelp");
            illegalAccessException.printStackTrace();
        }
    }

    private void createPopupMenu(JComponent jComponent) {
        Object object;
        JPopupMenu jPopupMenu = new JPopupMenu();
        ActionListener actionListener = actionEvent -> {
            String string = this.accessibleHtml.getSelectedText();
            if (string == null) {
                ScilabHelpBrowser.getHelpBrowser().getInfoBar().setText(Messages.gettext((String)"No text selected"));
            } else {
                ScilabConsole.getConsole().getAsSimpleConsole().sendCommandsToScilab(string, true, true);
            }
        };
        JMenuItem jMenuItem = new JMenuItem(Messages.gettext((String)"Execute into Scilab"));
        jMenuItem.addActionListener(actionListener);
        if (!ScilabConsole.isExistingConsole()) {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        ActionListener actionListener2 = actionEvent -> {
            String string = this.accessibleHtml.getSelectedText();
            if (string == null) {
                ScilabHelpBrowser.getHelpBrowser().getInfoBar().setText(Messages.gettext((String)"No text selected"));
            } else {
                SwingScilabHelpBrowserViewer.edit(string);
            }
        };
        jMenuItem = new JMenuItem(Messages.gettext((String)"Edit in the Scilab Text Editor"));
        try {
            object = Class.forName("org.scilab.modules.scinotes.SciNotes");
        }
        catch (ClassNotFoundException classNotFoundException) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.addActionListener(actionListener2);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        object = actionEvent -> {
            DefaultHelpHistoryModel defaultHelpHistoryModel = SwingScilabHelpBrowser.getHelpHistory();
            if (defaultHelpHistoryModel.getIndex() > 0) {
                SwingScilabHelpBrowser.getHelpHistory().goBack();
            }
        };
        jMenuItem = new JMenuItem(Messages.gettext((String)"Back"));
        jMenuItem.addActionListener((ActionListener)object);
        jPopupMenu.add(jMenuItem);
        ActionListener actionListener3 = actionEvent -> {
            DefaultHelpHistoryModel defaultHelpHistoryModel = SwingScilabHelpBrowser.getHelpHistory();
            if (defaultHelpHistoryModel.getHistory().size() != defaultHelpHistoryModel.getIndex() + 1) {
                SwingScilabHelpBrowser.getHelpHistory().goForward();
            }
        };
        jMenuItem = new JMenuItem(Messages.gettext((String)"Forward"));
        jMenuItem.addActionListener(actionListener3);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        jMenuItem.setText(Messages.gettext((String)"Copy"));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        ActionListener actionListener4 = actionEvent -> this.accessibleHtml.selectAll();
        jMenuItem = new JMenuItem(Messages.gettext((String)"Select All"));
        jMenuItem.addActionListener(actionListener4);
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Help on the selected text");
        ActionListener actionListener5 = actionEvent -> {
            String string = this.accessibleHtml.getSelectedText();
            if (string == null) {
                ScilabHelpBrowser.getHelpBrowser().getInfoBar().setText(Messages.gettext((String)"No text selected"));
            } else {
                ScilabHelpBrowser.getHelpBrowser().searchKeywork(string);
            }
        };
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            Object object = this.accessibleHtml.getSelectedText();
            if (object == null) {
                jMenuItem2.setText(Messages.gettext((String)"Help about a selected text"));
            } else {
                int n = 10;
                if (((String)object).length() > n) {
                    object = ((String)object).substring(0, n) + "...";
                }
                jMenuItem2.setText(Messages.gettext((String)"Help about '") + (String)object + "'");
            }
        };
        jMenuItem2.addPropertyChangeListener(propertyChangeListener);
        jMenuItem2.addActionListener(actionListener5);
        jPopupMenu.add(jMenuItem2);
        this.accessibleHtml.setComponentPopupMenu(jPopupMenu);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (isMac && mouseWheelEvent.isMetaDown() || mouseWheelEvent.isControlDown()) {
            int n = mouseWheelEvent.getWheelRotation();
            if (currentFontSize != Math.min(Math.max(0, currentFontSize + n), 6)) {
                this.modifyFontInEDT(n);
            }
            mouseWheelEvent.consume();
        }
    }

    public void modifyFont(int n) {
        try {
            currentFontSize = Math.min(Math.max(0, currentFontSize + n), 6);
            HTMLDocument hTMLDocument = (HTMLDocument)this.accessibleHtml.getDocument();
            StyleContext.NamedStyle namedStyle = (StyleContext.NamedStyle)hTMLDocument.getStyleSheet().getStyle("body");
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)namedStyle.getResolveParent();
            if (StyleConstants.getFontSize(mutableAttributeSet) != fontSizes[currentFontSize]) {
                ConfigManager.setHelpFontSize(currentFontSize);
                StyleConstants.setFontSize(mutableAttributeSet, fontSizes[currentFontSize]);
                this.accessibleHtml.setVisible(false);
                namedStyle.setResolveParent(mutableAttributeSet);
                this.accessibleHtml.setVisible(true);
            }
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(() -> this.modifyFont(n));
        }
    }

    public void modifyFontInEDT(int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.modifyFont(n);
        } else {
            SwingUtilities.invokeLater(() -> this.modifyFont(n));
        }
    }

    public void increaseFont() {
        if (currentFontSize != Math.min(Math.max(0, currentFontSize + 1), 6)) {
            this.modifyFontInEDT(1);
        }
    }

    public void decreaseFont() {
        if (currentFontSize != Math.min(Math.max(0, currentFontSize - 1), 6)) {
            this.modifyFontInEDT(-1);
        }
    }
}

