/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.polyline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.scilab.modules.graphic_objects.ObjectRemovedException;
import org.scilab.modules.graphic_objects.contouredObject.ClippableContouredObject;
import org.scilab.modules.graphic_objects.datatip.Datatip;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;

public class Polyline
extends ClippableContouredObject {
    private boolean closed = false;
    private double arrowSizeFactor = 1.0;
    private int polylineStyle = 1;
    private int[] interpColorVector = new int[4];
    private boolean interpColorVectorSet = false;
    private boolean interpColorMode = false;
    private double[] xShift = null;
    private double[] yShift = null;
    private double[] zShift = null;
    private double barWidth = 0.0;
    private List<Integer> datatips = new ArrayList<Integer>();
    private String displayFnc = "";
    private Integer tipMark = 11;
    private boolean colorSet = false;
    DatatipDisplayMode datatipDisplayMode = DatatipDisplayMode.ALWAYS;

    @Override
    public void accept(Visitor visitor) throws ObjectRemovedException {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 239: {
                return PolylineProperty.CLOSED;
            }
            case 240: {
                return PolylineProperty.ARROWSIZEFACTOR;
            }
            case 241: {
                return PolylineProperty.POLYLINESTYLE;
            }
            case 242: {
                return PolylineProperty.INTERPCOLORVECTOR;
            }
            case 243: {
                return PolylineProperty.INTERPCOLORVECTORSET;
            }
            case 244: {
                return PolylineProperty.INTERPCOLORMODE;
            }
            case 245: {
                return PolylineProperty.XSHIFT;
            }
            case 246: {
                return PolylineProperty.YSHIFT;
            }
            case 247: {
                return PolylineProperty.ZSHIFT;
            }
            case 248: {
                return PolylineProperty.BARWIDTH;
            }
            case 30: {
                return PolylineProperty.DATA;
            }
            case 357: {
                return PolylineProperty.DATATIPS;
            }
            case 358: {
                return PolylineProperty.DATATIPSCOUNT;
            }
            case 344: {
                return PolylineProperty.TIP_DISPLAY_FNC;
            }
            case 347: {
                return PolylineProperty.TIP_MARK;
            }
            case 404: {
                return PolylineProperty.COLORSET;
            }
            case 360: {
                return PolylineProperty.DATATIPDISPLAYMODE;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object instanceof PolylineProperty) {
            switch ((PolylineProperty)((Object)object)) {
                case CLOSED: {
                    return this.getClosed();
                }
                case ARROWSIZEFACTOR: {
                    return this.getArrowSizeFactor();
                }
                case POLYLINESTYLE: {
                    return this.getPolylineStyle();
                }
                case INTERPCOLORVECTOR: {
                    return this.getInterpColorVector();
                }
                case INTERPCOLORVECTORSET: {
                    return this.getInterpColorVectorSet();
                }
                case INTERPCOLORMODE: {
                    return this.getInterpColorMode();
                }
                case XSHIFT: {
                    return this.getXShift();
                }
                case YSHIFT: {
                    return this.getYShift();
                }
                case ZSHIFT: {
                    return this.getZShift();
                }
                case BARWIDTH: {
                    return this.getBarWidth();
                }
                case DATA: {
                    return this.getIdentifier();
                }
                case DATATIPS: {
                    return this.getDatatips();
                }
                case DATATIPSCOUNT: {
                    return this.datatips.size();
                }
                case TIP_DISPLAY_FNC: {
                    return this.getDisplayFunction();
                }
                case TIP_MARK: {
                    return this.getTipMark();
                }
                case COLORSET: {
                    return this.getColorSet();
                }
                case DATATIPDISPLAYMODE: {
                    return this.getDatatipDisplayMode();
                }
            }
        }
        return super.getProperty(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        Polyline polyline = this;
        synchronized (polyline) {
            if (object instanceof PolylineProperty) {
                switch ((PolylineProperty)((Object)object)) {
                    case CLOSED: {
                        this.setClosed((Boolean)object2);
                        break;
                    }
                    case ARROWSIZEFACTOR: {
                        return this.setArrowSizeFactor((Double)object2);
                    }
                    case POLYLINESTYLE: {
                        return this.setPolylineStyle((Integer)object2);
                    }
                    case INTERPCOLORVECTOR: {
                        this.setInterpColorVector((Integer[])object2);
                        break;
                    }
                    case INTERPCOLORVECTORSET: {
                        this.setInterpColorVectorSet((Boolean)object2);
                        break;
                    }
                    case INTERPCOLORMODE: {
                        return this.setInterpColorMode((Boolean)object2);
                    }
                    case XSHIFT: {
                        this.setXShift((double[])object2);
                        break;
                    }
                    case YSHIFT: {
                        this.setYShift((double[])object2);
                        break;
                    }
                    case ZSHIFT: {
                        this.setZShift((double[])object2);
                        break;
                    }
                    case BARWIDTH: {
                        this.setBarWidth((Double)object2);
                        break;
                    }
                    case DATA: {
                        this.updateDatatips();
                        break;
                    }
                    case DATATIPS: {
                        this.setDatatips((Integer[])object2);
                        break;
                    }
                    case DATATIPSCOUNT: {
                        break;
                    }
                    case TIP_DISPLAY_FNC: {
                        this.setDisplayFunction((String)object2);
                        break;
                    }
                    case TIP_MARK: {
                        this.setTipMark((Integer)object2);
                        break;
                    }
                    case COLORSET: {
                        this.setColorSet((Boolean)object2);
                        break;
                    }
                    case DATATIPDISPLAYMODE: {
                        return this.setDatatipDisplayMode((Integer)object2);
                    }
                }
            }
            return super.setProperty(object, object2);
        }
    }

    public Double getArrowSizeFactor() {
        return this.arrowSizeFactor;
    }

    public GraphicObject.UpdateStatus setArrowSizeFactor(Double d) {
        if (this.arrowSizeFactor == d) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.arrowSizeFactor = d;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getBarWidth() {
        return this.barWidth;
    }

    public GraphicObject.UpdateStatus setBarWidth(Double d) {
        this.barWidth = d;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getClosed() {
        return this.closed;
    }

    public GraphicObject.UpdateStatus setClosed(Boolean bl) {
        this.closed = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getInterpColorMode() {
        return this.interpColorMode;
    }

    public GraphicObject.UpdateStatus setInterpColorMode(Boolean bl) {
        if (this.interpColorMode == bl) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.interpColorMode = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer[] getInterpColorVector() {
        Integer[] integerArray = new Integer[this.interpColorVector.length];
        for (int i = 0; i < this.interpColorVector.length; ++i) {
            integerArray[i] = this.interpColorVector[i];
        }
        return integerArray;
    }

    public GraphicObject.UpdateStatus setInterpColorVector(Integer[] integerArray) {
        if (!this.interpColorVectorSet) {
            this.interpColorVectorSet = true;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            this.interpColorVector[i] = integerArray[i];
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getInterpColorVectorSet() {
        return this.interpColorVectorSet;
    }

    public GraphicObject.UpdateStatus setInterpColorVectorSet(Boolean bl) {
        this.interpColorVectorSet = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getPolylineStyle() {
        return this.polylineStyle;
    }

    public GraphicObject.UpdateStatus setPolylineStyle(Integer n) {
        if (this.polylineStyle == n) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.polylineStyle = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public double[] getXShift() {
        return this.xShift;
    }

    public GraphicObject.UpdateStatus setXShift(double[] dArray) {
        this.xShift = dArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public double[] getYShift() {
        return this.yShift;
    }

    public GraphicObject.UpdateStatus setYShift(double[] dArray) {
        this.yShift = dArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public double[] getZShift() {
        return this.zShift;
    }

    public GraphicObject.UpdateStatus setZShift(double[] dArray) {
        this.zShift = dArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer[] getDatatips() {
        return this.datatips.toArray(new Integer[this.datatips.size()]);
    }

    public GraphicObject.UpdateStatus updateDatatips() {
        GraphicController graphicController = GraphicController.getController();
        for (Integer n : this.getDatatips()) {
            Datatip datatip = (Datatip)graphicController.getObjectFromId(n);
            datatip.updateText();
            graphicController.setProperty(n, 30, 0);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setDatatips(Integer[] integerArray) {
        this.datatips = new LinkedList<Integer>(Arrays.asList(integerArray));
        return GraphicObject.UpdateStatus.Success;
    }

    public String getDisplayFunction() {
        return this.displayFnc;
    }

    public GraphicObject.UpdateStatus setDisplayFunction(String string) {
        GraphicController graphicController = GraphicController.getController();
        this.displayFnc = string;
        for (int i = 0; i < this.datatips.size(); ++i) {
            Datatip datatip = (Datatip)graphicController.getObjectFromId(this.datatips.get(i));
            datatip.updateText();
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getTipMark() {
        return this.tipMark;
    }

    public GraphicObject.UpdateStatus setTipMark(Integer n) {
        if (!this.tipMark.equals(n)) {
            this.tipMark = n;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Boolean getColorSet() {
        return this.colorSet;
    }

    public GraphicObject.UpdateStatus setColorSet(Boolean bl) {
        this.colorSet = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getDatatipDisplayMode() {
        return this.datatipDisplayMode.ordinal();
    }

    public DatatipDisplayMode getDatatipDisplayModeAsEnum() {
        return this.datatipDisplayMode;
    }

    public GraphicObject.UpdateStatus setDatatipDisplayMode(Integer n) {
        this.datatipDisplayMode = DatatipDisplayMode.intToEnum(n);
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setDatatipDisplayModeAsEnum(DatatipDisplayMode datatipDisplayMode) {
        this.datatipDisplayMode = datatipDisplayMode;
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getType() {
        return 15;
    }

    public static enum DatatipDisplayMode {
        ALWAYS,
        MOUSECLICK,
        MOUSEOVER;


        public static DatatipDisplayMode intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return ALWAYS;
                }
                case 1: {
                    return MOUSECLICK;
                }
                case 2: {
                    return MOUSEOVER;
                }
            }
            return ALWAYS;
        }
    }

    private static enum PolylineProperty {
        CLOSED,
        ARROWSIZEFACTOR,
        POLYLINESTYLE,
        INTERPCOLORVECTOR,
        INTERPCOLORVECTORSET,
        INTERPCOLORMODE,
        XSHIFT,
        YSHIFT,
        ZSHIFT,
        BARWIDTH,
        DATATIPS,
        DATATIPSCOUNT,
        TIP_DISPLAY_FNC,
        TIP_MARK,
        COLORSET,
        DATATIPDISPLAYMODE,
        DATA;

    }
}

