/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.texture;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.scilab.forge.scirenderer.data.DataProvider;
import org.scilab.forge.scirenderer.texture.Texture;

public interface TextureDataProvider
extends DataProvider<Texture> {
    public boolean isRowMajorOrder();

    public ImageType getImageType();

    public Dimension getTextureSize();

    public ByteBuffer getData();

    public ByteBuffer getSubData(int var1, int var2, int var3, int var4);

    public BufferedImage getImage();

    public BufferedImage getSubImage(int var1, int var2, int var3, int var4);

    public static enum ImageType {
        RGB,
        RGB_RGBA,
        BGR,
        GRAY,
        GRAY_16,
        RGBA,
        RGBA_REV,
        ABGR,
        RGB_332,
        RED,
        GREEN,
        BLUE,
        INTENSITY,
        RGBA_4444,
        RGBA_5551,
        RGB_FLOAT,
        RGBA_FLOAT,
        GRAY_FLOAT,
        RED_16,
        GREEN_16,
        BLUE_16,
        RED_FLOAT,
        GREEN_FLOAT,
        BLUE_FLOAT,
        RGBA_BYTE;


        public static ImageType fromInt(int n) {
            switch (n) {
                case 0: {
                    return RGB;
                }
                case 1: {
                    return RGB_RGBA;
                }
                case 2: {
                    return BGR;
                }
                case 3: {
                    return GRAY;
                }
                case 4: {
                    return GRAY_16;
                }
                case 5: {
                    return RGBA;
                }
                case 6: {
                    return RGBA_REV;
                }
                case 7: {
                    return ABGR;
                }
                case 8: {
                    return RGB_332;
                }
                case 9: {
                    return RED;
                }
                case 10: {
                    return GREEN;
                }
                case 11: {
                    return BLUE;
                }
                case 12: {
                    return INTENSITY;
                }
                case 13: {
                    return RGBA_4444;
                }
                case 14: {
                    return RGBA_5551;
                }
                case 15: {
                    return RGB_FLOAT;
                }
                case 16: {
                    return RGBA_FLOAT;
                }
                case 17: {
                    return GRAY_FLOAT;
                }
                case 18: {
                    return RED_16;
                }
                case 19: {
                    return GREEN_16;
                }
                case 20: {
                    return BLUE_16;
                }
                case 21: {
                    return RED_FLOAT;
                }
                case 22: {
                    return GREEN_FLOAT;
                }
                case 23: {
                    return BLUE_FLOAT;
                }
                case 24: {
                    return RGBA_BYTE;
                }
            }
            return GRAY;
        }
    }
}

