/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.buffers;

import java.nio.FloatBuffer;
import org.scilab.forge.scirenderer.buffers.DataBuffer;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;

public class G2DElementsBuffer
implements DataBuffer,
ElementsBuffer {
    public static final int ELEMENT_SIZE = 4;
    private static final float[] DEFAULT_VERTEX = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private FloatBuffer data = null;
    private final Object mutex = new Object();

    G2DElementsBuffer() {
    }

    @Override
    public void setData(float[] fArray, int n) {
        if (n < 1 || n > 4) {
            throw new BadElementSizeException(n, 1, 4);
        }
        int n2 = fArray.length / n;
        FloatBuffer floatBuffer = FloatBuffer.allocate(4 * n2);
        floatBuffer.rewind();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (j < n) {
                    floatBuffer.put(fArray[n3++]);
                    continue;
                }
                floatBuffer.put(DEFAULT_VERTEX[j]);
            }
        }
        floatBuffer.rewind();
        this.setData(floatBuffer);
    }

    @Override
    public void setData(Float[] floatArray, int n) {
        if (n < 1 || n > 4) {
            throw new BadElementSizeException(n, 1, 4);
        }
        int n2 = floatArray.length / n;
        FloatBuffer floatBuffer = FloatBuffer.allocate(4 * n2);
        floatBuffer.rewind();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (j < n) {
                    floatBuffer.put(floatArray[n3++].floatValue());
                    continue;
                }
                floatBuffer.put(DEFAULT_VERTEX[j]);
            }
        }
        floatBuffer.rewind();
        this.setData(floatBuffer);
    }

    @Override
    public void setData(FloatBuffer floatBuffer, int n) {
        if (n < 1 || n > 4) {
            throw new BadElementSizeException(n, 1, 4);
        }
        if (n == 4) {
            if (floatBuffer != null) {
                floatBuffer.rewind();
            }
            this.setData(floatBuffer);
            return;
        }
        int n2 = floatBuffer.limit() / n;
        FloatBuffer floatBuffer2 = FloatBuffer.allocate(4 * n2);
        floatBuffer2.rewind();
        floatBuffer.rewind();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (j < n) {
                    floatBuffer2.put(floatBuffer.get());
                    continue;
                }
                floatBuffer2.put(DEFAULT_VERTEX[j]);
            }
        }
        floatBuffer2.rewind();
        this.setData(floatBuffer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.data == null) {
                return 0;
            }
            return this.data.limit() / 4;
        }
    }

    @Override
    public int getElementsSize() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FloatBuffer getData() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.data != null) {
                return this.data;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setData(FloatBuffer floatBuffer) {
        Object object = this.mutex;
        synchronized (object) {
            this.data = floatBuffer;
        }
    }

    @Override
    public void clear() {
        if (this.data != null) {
            this.data.clear();
        }
        this.data = null;
    }

    private static class BadElementSizeException
    extends RuntimeException {
        public BadElementSizeException(int n, int n2, int n3) {
            super("Bad vertex elements  size : " + n + ". Should be in [" + n2 + ", " + (n3 - 1) + "]");
        }
    }
}

