/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.io.IOException;
import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import org.scilab.modules.scinotes.ScilabDocument;

public class ScilabDocumentReader
extends Reader {
    private static final String BADLOCATION = "Bad Location in document";
    private int end;
    private int pos;
    private boolean fromEnd;
    private ScilabDocument doc;
    private Segment segment;

    public ScilabDocumentReader(ScilabDocument scilabDocument, int n, int n2) {
        this(scilabDocument, false, n, n2);
    }

    public ScilabDocumentReader(ScilabDocument scilabDocument, boolean bl, int n, int n2) {
        this.doc = scilabDocument;
        this.segment = new Segment();
        if (bl) {
            this.pos = Math.min(n, scilabDocument.getLength());
            this.end = n2;
        } else {
            this.pos = n;
            this.end = Math.min(n2, scilabDocument.getLength());
        }
        this.fromEnd = bl;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.doc == null) {
            throw new IOException("Reader closed");
        }
        int n3 = n2;
        if (!this.fromEnd) {
            if (this.pos < this.end) {
                if (n3 > this.end - this.pos) {
                    n3 = this.end - this.pos;
                }
                try {
                    this.doc.getText(this.pos, n3, this.segment);
                    System.arraycopy(this.segment.array, this.segment.offset, cArray, n, n3);
                    this.pos += n3;
                    return n3;
                }
                catch (BadLocationException badLocationException) {
                    throw new IOException(BADLOCATION);
                }
            }
        } else if (this.pos > this.end) {
            if (n3 > this.pos - this.end + 1) {
                n3 = this.pos - this.end + 1;
            }
            try {
                this.doc.getText(this.pos - n3 + 1, n3, this.segment);
                int n4 = this.segment.offset + this.segment.count - 1;
                for (int i = 0; i < n3; ++i) {
                    cArray[n + i] = this.segment.array[n4 - i];
                }
                this.pos -= n3;
                return n3;
            }
            catch (BadLocationException badLocationException) {
                throw new IOException(BADLOCATION);
            }
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.doc = null;
    }
}

