/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.utils;

import java.awt.Color;

public enum Font {
    COURIER("Monospaced"),
    SYMBOL("Dialog"),
    SERIF("Serif"),
    SERIF_ITALIC("Serif", 2),
    SERIF_BOLD("Serif", 1),
    SERIF_BOLD_ITALIC("Serif", 3),
    SANS_SERIF("SansSerif"),
    SANS_SERIF_ITALIC("SansSerif", 2),
    SANS_SERIF_BOLD("SansSerif", 1),
    SANS_SERIF_BOLD_ITALIC("SansSerif", 3);

    private static final Color[] COLORMAP;
    private final String name;
    private final int modifiers;

    private Font(String string2) {
        this(string2, 0);
    }

    private Font(String string2, int n2) {
        this.name = string2;
        this.modifiers = n2;
    }

    public static Font getFont(int n) {
        return Font.values()[n % Font.values().length];
    }

    public static int getSize(int n) {
        int n2 = n <= 0 ? 0 : (n < 1 ? 13 * n : (n > 4 ? 7 * (n - 4) + 17 : (int)(13.0 + 1.2 * (double)(n - 1))));
        return n2;
    }

    public static Color getColor(int n) {
        return COLORMAP[n % COLORMAP.length];
    }

    public static int getSize(String string) {
        return Font.getSize(Integer.parseInt(string));
    }

    public static Color getColor(String string) {
        return Font.getColor(Integer.parseInt(string));
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    static {
        COLORMAP = new Color[]{Color.BLACK, Color.BLUE, Color.GREEN, Color.CYAN, Color.RED, Color.MAGENTA, Color.YELLOW, Color.WHITE, new Color(0, 0, 144), new Color(0, 0, 176), new Color(0, 0, 208), new Color(135, 206, 255), new Color(0, 144, 0), new Color(0, 176, 0), new Color(0, 208, 0), new Color(0, 144, 0), new Color(0, 144, 144), new Color(0, 176, 176), new Color(0, 208, 208), new Color(144, 0, 0), new Color(176, 0, 0), new Color(208, 0, 0), new Color(144, 0, 144), new Color(176, 0, 176), new Color(208, 0, 208), new Color(128, 48, 0), new Color(160, 64, 0), new Color(192, 96, 0), new Color(255, 128, 128), new Color(255, 160, 160), new Color(255, 192, 192), new Color(255, 224, 224), new Color(255, 215, 0)};
    }
}

