/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.util;

import org.scilab.forge.scirenderer.lightning.LightManager;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.shapes.appearance.Material;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.lighting.Light;

public class LightingUtils {
    public static Material getMaterial(org.scilab.modules.graphic_objects.lighting.Material material) {
        Material material2 = new Material();
        Double[] doubleArray = material.getAmbientColor();
        material2.setAmbientColor(new Color(doubleArray[0].floatValue(), doubleArray[1].floatValue(), doubleArray[2].floatValue()));
        doubleArray = material.getDiffuseColor();
        material2.setDiffuseColor(new Color(doubleArray[0].floatValue(), doubleArray[1].floatValue(), doubleArray[2].floatValue()));
        doubleArray = material.getSpecularColor();
        material2.setSpecularColor(new Color(doubleArray[0].floatValue(), doubleArray[1].floatValue(), doubleArray[2].floatValue()));
        material2.setColorMaterialEnable(material.getColorMaterialMode().booleanValue());
        material2.setShininess(material.getShininess().floatValue());
        return material2;
    }

    public static void setLightingEnable(LightManager lightManager, Boolean bl) {
        if (lightManager == null) {
            return;
        }
        lightManager.setLightningEnable(bl.booleanValue());
        org.scilab.forge.scirenderer.lightning.Light light = lightManager.getLight(0);
        light.setEnable(bl.booleanValue());
    }

    public static void setupLights(LightManager lightManager, Axes axes) {
        if (lightManager == null) {
            return;
        }
        boolean bl = false;
        int n = 0;
        for (Integer n2 : axes.getChildren()) {
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n2);
            if (graphicObject instanceof Light && ((Light)graphicObject).getVisible().booleanValue()) {
                LightingUtils.setLight(lightManager, (Light)graphicObject, n++, axes);
                bl = true;
            }
            if (n >= lightManager.getLightNumber()) break;
        }
        for (int i = n; i < lightManager.getLightNumber(); ++i) {
        }
        lightManager.setLightningEnable(bl);
    }

    public static void setLight(LightManager lightManager, Light light, int n, Axes axes) {
        org.scilab.forge.scirenderer.lightning.Light light2 = lightManager.getLight(n);
        double[][] dArray = axes.getScaleTranslateFactors();
        Double[] doubleArray = light.getLightTypeAsInteger() == 0 ? light.getDirection() : light.getPosition();
        doubleArray[0] = doubleArray[0] * dArray[0][0] + dArray[1][0];
        doubleArray[1] = doubleArray[1] * dArray[0][1] + dArray[1][1];
        doubleArray[2] = doubleArray[2] * dArray[0][2] + dArray[1][2];
        Double[] doubleArray2 = light.getAmbientColor();
        light2.setAmbientColor(new Color(doubleArray2[0].floatValue(), doubleArray2[1].floatValue(), doubleArray2[2].floatValue()));
        doubleArray2 = light.getDiffuseColor();
        light2.setDiffuseColor(new Color(doubleArray2[0].floatValue(), doubleArray2[1].floatValue(), doubleArray2[2].floatValue()));
        doubleArray2 = light.getSpecularColor();
        light2.setSpecularColor(new Color(doubleArray2[0].floatValue(), doubleArray2[1].floatValue(), doubleArray2[2].floatValue()));
        if (light.getLightTypeAsInteger() == 0) {
            light2.setDirection(new Vector3d(doubleArray));
        } else {
            light2.setPosition(new Vector3d(doubleArray));
        }
        light2.setEnable(true);
    }
}

