/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.arrowDrawing;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.DataBuffer;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.ObjectRemovedException;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.renderer.JoGLView.DataManager;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.JoGLView.util.OutOfMemoryException;

public class ArrowDrawer {
    private final DrawerVisitor visitor;
    private static final double APEX_ANGLE = 40.0;
    private static final double COS_HALF_ANGLE = Math.cos(Math.toRadians(20.0));
    private static final double SIN_HALF_ANGLE = Math.sin(Math.toRadians(20.0));
    private static final double REDUCTION_RATIO = 0.02;
    private static final double SEGS_REDUCTION_RATIO = 0.075;
    private static final double REDUCTION_RATIO_DEPENDING = 0.15;
    ElementsBuffer drawerArrowVertices;

    public ArrowDrawer(DrawerVisitor drawerVisitor) {
        this.visitor = drawerVisitor;
        this.drawerArrowVertices = drawerVisitor.getCanvas().getBuffersManager().createElementsBuffer();
    }

    private double computeArrowPixelSize(Axes axes, ElementsBuffer elementsBuffer, IndicesBuffer indicesBuffer, int n, double d, double d2, boolean bl) {
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = this.visitor.getDrawingTools().getCanvas().getWidth();
        int n3 = this.visitor.getDrawingTools().getCanvas().getHeight();
        Transformation transformation = this.visitor.getDrawingTools().getTransformationManager().getCanvasProjection();
        Double[] doubleArray = axes.getAxesBounds();
        Double[] doubleArray2 = axes.getMargins();
        double[] dArray = new double[]{doubleArray[2] * (1.0 - doubleArray2[0] - doubleArray2[1]), doubleArray[3] * (1.0 - doubleArray2[2] - doubleArray2[3])};
        dArray[0] = dArray[0] * (double)n2;
        dArray[1] = dArray[1] * (double)n3;
        Double[] doubleArray3 = axes.getDisplayedBounds();
        double d5 = doubleArray3[1] - doubleArray3[0];
        double d6 = doubleArray3[3] - doubleArray3[2];
        if (d < 0.0) {
            d3 = this.computeAverageNorm(transformation, elementsBuffer.getData(), elementsBuffer.getElementsSize(), indicesBuffer.getData(), n);
        }
        d4 = this.computeArrowPixelSize(d3, dArray, d5, d6, bl, d2, d);
        return d4;
    }

    public void drawArrows(Integer n, Integer n2, double d, double d2, boolean bl, boolean bl2, int n3, boolean bl3) throws SciRendererException, ObjectRemovedException, OutOfMemoryException {
        DataManager dataManager = this.visitor.getDataManager();
        ColorMap colorMap = this.visitor.getColorMap();
        ElementsBuffer elementsBuffer = dataManager.getVertexBuffer(n2);
        IndicesBuffer indicesBuffer = dataManager.getWireIndexBuffer(n2);
        IndicesBuffer indicesBuffer2 = dataManager.getIndexBuffer(n2);
        this.drawArrows(n, elementsBuffer, dataManager.getColorBuffer(n2), indicesBuffer, indicesBuffer2, d, d2, bl, bl2, n3, bl3);
    }

    public void drawArrows(Integer n, ElementsBuffer elementsBuffer, IndicesBuffer indicesBuffer, double d, double d2, int n2, boolean bl) throws SciRendererException {
        this.drawArrows(n, elementsBuffer, null, indicesBuffer, null, d, d2, false, false, n2, bl);
    }

    private void drawArrows(Integer n, ElementsBuffer elementsBuffer, ElementsBuffer elementsBuffer2, IndicesBuffer indicesBuffer, IndicesBuffer indicesBuffer2, double d, double d2, boolean bl, boolean bl2, int n2, boolean bl3) throws SciRendererException {
        int n3 = elementsBuffer.getElementsSize();
        int n4 = bl3 ? indicesBuffer.getData().capacity() - 1 : indicesBuffer.getData().capacity() / 2;
        if (n4 == 0) {
            return;
        }
        Transformation transformation = this.visitor.getDrawingTools().getTransformationManager().getCanvasProjection();
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(n);
        d = this.computeArrowPixelSize(axes, elementsBuffer, indicesBuffer, n4, d, d2, bl);
        if (indicesBuffer2 != null) {
            this.fillArrowVertexData(transformation, elementsBuffer, indicesBuffer, n4, indicesBuffer2, d, bl3);
            elementsBuffer.setData(elementsBuffer.getData(), n3);
        } else {
            this.fillArrowVertexData(transformation, elementsBuffer, indicesBuffer, n4, this.drawerArrowVertices, d, bl3);
        }
        DefaultGeometry defaultGeometry = new DefaultGeometry();
        defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.NONE);
        defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
        defaultGeometry.setFaceCullingMode(Geometry.FaceCullingMode.BOTH);
        if (indicesBuffer2 != null) {
            defaultGeometry.setVertices(elementsBuffer);
            defaultGeometry.setIndices(indicesBuffer2);
        } else {
            defaultGeometry.setVertices(this.drawerArrowVertices);
        }
        Appearance appearance = new Appearance();
        if (bl2) {
            defaultGeometry.setColors(elementsBuffer2);
        } else {
            appearance.setFillColor(ColorFactory.createColor(this.visitor.getColorMap(), n2));
        }
        this.visitor.getDrawingTools().getTransformationManager().useWindowCoordinate();
        this.visitor.getDrawingTools().draw((Geometry)defaultGeometry, appearance);
        this.visitor.getDrawingTools().getTransformationManager().useSceneCoordinate();
    }

    private void fillArrowVertexData(Transformation transformation, ElementsBuffer elementsBuffer, IndicesBuffer indicesBuffer, int n, IndicesBuffer indicesBuffer2, double d, boolean bl) {
        int[] nArray = new int[2];
        int[] nArray2 = new int[3];
        int n2 = elementsBuffer.getElementsSize();
        IntBuffer intBuffer = indicesBuffer.getData();
        IntBuffer intBuffer2 = indicesBuffer2.getData();
        FloatBuffer floatBuffer = elementsBuffer.getData();
        for (int i = 0; i < n; ++i) {
            if (bl) {
                nArray[0] = n2 * intBuffer.get(i);
                nArray[1] = n2 * intBuffer.get(i + 1);
            } else {
                nArray[0] = n2 * intBuffer.get(2 * i);
                nArray[1] = n2 * intBuffer.get(2 * i + 1);
            }
            nArray2[0] = n2 * intBuffer2.get(3 * i);
            nArray2[1] = n2 * intBuffer2.get(3 * i + 1);
            nArray2[2] = n2 * intBuffer2.get(3 * i + 2);
            this.computeAndWriteSingleArrowVertexData(transformation, floatBuffer, floatBuffer, nArray, nArray2, n2, d);
        }
    }

    private void fillArrowVertexData(Transformation transformation, ElementsBuffer elementsBuffer, IndicesBuffer indicesBuffer, int n, ElementsBuffer elementsBuffer2, double d, boolean bl) {
        FloatBuffer floatBuffer;
        int n2;
        int[] nArray = new int[2];
        int[] nArray2 = new int[3];
        int n3 = elementsBuffer.getElementsSize();
        IntBuffer intBuffer = indicesBuffer.getData();
        FloatBuffer floatBuffer2 = elementsBuffer.getData();
        int n4 = 0;
        if (this.isResizeRequired(elementsBuffer2, n)) {
            n2 = 4;
            floatBuffer = FloatBuffer.allocate(n2 * 3 * n);
        } else {
            n2 = elementsBuffer2.getElementsSize();
            floatBuffer = elementsBuffer2.getData();
        }
        for (int i = 0; i < n; ++i) {
            if (bl) {
                nArray[0] = n3 * intBuffer.get(i);
                nArray[1] = n3 * intBuffer.get(i + 1);
            } else {
                nArray[0] = n3 * intBuffer.get(2 * i);
                nArray[1] = n3 * intBuffer.get(2 * i + 1);
            }
            nArray2[0] = n4;
            nArray2[1] = n4 + n2;
            nArray2[2] = n4 + 2 * n2;
            this.computeAndWriteSingleArrowVertexData(transformation, floatBuffer2, floatBuffer, nArray, nArray2, n2, d);
            n4 += 3 * n2;
        }
        elementsBuffer2.setData(floatBuffer, n2);
    }

    private boolean isResizeRequired(ElementsBuffer elementsBuffer, int n) {
        boolean bl = false;
        if (elementsBuffer.getData() == null) {
            bl = true;
        } else {
            int n2 = elementsBuffer.getData().capacity() / elementsBuffer.getElementsSize();
            if (3 * n != n2) {
                bl = true;
            }
        }
        return bl;
    }

    private void computeAndWriteSingleArrowVertexData(Transformation transformation, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int[] nArray, int[] nArray2, int n, double d) {
        Vector3d vector3d = new Vector3d((double)floatBuffer.get(nArray[0]), (double)floatBuffer.get(nArray[0] + 1), (double)floatBuffer.get(nArray[0] + 2));
        Vector3d vector3d2 = new Vector3d((double)floatBuffer.get(nArray[1]), (double)floatBuffer.get(nArray[1] + 1), (double)floatBuffer.get(nArray[1] + 2));
        vector3d = transformation.project(vector3d);
        vector3d2 = transformation.project(vector3d2);
        Vector3d vector3d3 = vector3d2.minus(vector3d).getNormalized();
        Vector3d[] vector3dArray = this.computeArrowVertices(vector3d2, vector3d3, d);
        floatBuffer2.put(nArray2[0], (float)vector3dArray[0].getX());
        floatBuffer2.put(nArray2[0] + 1, (float)vector3dArray[0].getY());
        floatBuffer2.put(nArray2[0] + 2, (float)vector3dArray[0].getZ());
        floatBuffer2.put(nArray2[1], (float)vector3dArray[1].getX());
        floatBuffer2.put(nArray2[1] + 1, (float)vector3dArray[1].getY());
        floatBuffer2.put(nArray2[1] + 2, (float)vector3dArray[1].getZ());
        floatBuffer2.put(nArray2[2], (float)vector3dArray[2].getX());
        floatBuffer2.put(nArray2[2] + 1, (float)vector3dArray[2].getY());
        floatBuffer2.put(nArray2[2] + 2, (float)vector3dArray[2].getZ());
        if (n == 4) {
            floatBuffer2.put(nArray2[0] + 3, 1.0f);
            floatBuffer2.put(nArray2[1] + 3, 1.0f);
            floatBuffer2.put(nArray2[2] + 3, 1.0f);
        }
    }

    private double computeAverageNorm(Transformation transformation, FloatBuffer floatBuffer, int n, IntBuffer intBuffer, int n2) {
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            int n3 = intBuffer.get(2 * i);
            int n4 = intBuffer.get(2 * i + 1);
            Vector3d vector3d = new Vector3d((double)floatBuffer.get(n3 * n), (double)floatBuffer.get(n3 * n + 1), (double)floatBuffer.get(n3 * n + 2));
            Vector3d vector3d2 = new Vector3d((double)floatBuffer.get(n4 * n), (double)floatBuffer.get(n4 * n + 1), (double)floatBuffer.get(n4 * n + 2));
            vector3d = transformation.project(vector3d);
            vector3d2 = transformation.project(vector3d2);
            double d2 = vector3d2.minus(vector3d).getNorm();
            d += d2;
        }
        if (n2 > 0) {
            d /= (double)n2;
        }
        return d;
    }

    private double computeArrowPixelSize(double d, double[] dArray, double d2, double d3, boolean bl, double d4, double d5) {
        if (d5 < 0.0) {
            d5 *= d4;
            d5 = -d5 * d * 0.15;
        } else if (bl) {
            double d6 = Math.max(d2, d3);
            if (d6 == 0.0) {
                d6 = 1.0;
            }
            d5 *= d4;
            d5 = d5 * Math.min(dArray[0], dArray[1]) * 0.075 / d6;
        } else {
            d5 *= d4;
            d5 = d5 * Math.min(dArray[0], dArray[1]) * 0.02;
        }
        return d5;
    }

    private Vector3d[] computeArrowVertices(Vector3d vector3d, Vector3d vector3d2, double d) {
        Vector3d[] vector3dArray = new Vector3d[3];
        Vector3d vector3d3 = new Vector3d(-vector3d2.getY(), vector3d2.getX(), vector3d2.getZ());
        double d2 = d * COS_HALF_ANGLE;
        double d3 = d * SIN_HALF_ANGLE;
        Vector3d vector3d4 = vector3d.minus(vector3d2.times(d2));
        vector3dArray[0] = vector3d;
        vector3dArray[1] = vector3d4.minus(vector3d3.times(d3));
        vector3dArray[2] = vector3d4.plus(vector3d3.times(d3));
        return vector3dArray;
    }

    public void disposeAll() {
        this.visitor.getCanvas().getBuffersManager().dispose((DataBuffer)this.drawerArrowVertices);
    }
}

