/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView;

import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.AbstractTextureDataProvider;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDataProvider;
import org.scilab.modules.graphic_objects.ObjectRemovedException;
import org.scilab.modules.graphic_objects.fec.Fec;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.renderer.JoGLView.DataManager;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.JoGLView.util.OutOfMemoryException;

class FecDrawer {
    private static final Set<Integer> TEXTURE_PROPERTIES = new HashSet<Integer>(Arrays.asList(225, 30, 227, 226));
    private final DrawerVisitor drawerVisitor;
    private final Map<Integer, Texture> textureMap;

    FecDrawer(DrawerVisitor drawerVisitor) {
        this.drawerVisitor = drawerVisitor;
        this.textureMap = new HashMap<Integer, Texture>();
    }

    public void draw(Fec fec) throws ObjectRemovedException, OutOfMemoryException {
        if (fec.getVisible().booleanValue()) {
            DrawingTools drawingTools = this.drawerVisitor.getDrawingTools();
            DataManager dataManager = this.drawerVisitor.getDataManager();
            ColorMap colorMap = this.drawerVisitor.getColorMap();
            try {
                DefaultGeometry defaultGeometry = new DefaultGeometry();
                Appearance appearance = new Appearance();
                defaultGeometry.setVertices(dataManager.getVertexBuffer(fec.getIdentifier()));
                defaultGeometry.setTextureCoordinates(dataManager.getTextureCoordinatesBuffer(fec.getIdentifier()));
                defaultGeometry.setIndices(dataManager.getIndexBuffer(fec.getIdentifier()));
                defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
                defaultGeometry.setFaceCullingMode(Geometry.FaceCullingMode.BOTH);
                defaultGeometry.setPolygonOffsetMode(true);
                if (fec.getLineMode().booleanValue()) {
                    defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
                    defaultGeometry.setWireIndices(dataManager.getWireIndexBuffer(fec.getIdentifier()));
                    appearance.setLineColor(ColorFactory.createColor(colorMap, fec.getLineColor()));
                }
                appearance.setTexture(this.getTexture(fec));
                drawingTools.draw((Geometry)defaultGeometry, appearance);
            }
            catch (SciRendererException sciRendererException) {
                System.err.println("A '" + fec.getType() + "' is not drawable because: '" + sciRendererException.getMessage() + "'");
            }
        }
    }

    private Texture getTexture(Fec fec) {
        Texture texture = this.textureMap.get(fec.getIdentifier());
        if (texture == null) {
            texture = this.drawerVisitor.getCanvas().getTextureManager().createTexture();
            texture.setSWrappingMode(Texture.Wrap.CLAMP);
            texture.setTWrappingMode(Texture.Wrap.CLAMP);
            texture.setMagnificationFilter(Texture.Filter.NEAREST);
            texture.setMinifyingFilter(Texture.Filter.NEAREST);
            this.textureMap.put(fec.getIdentifier(), texture);
        }
        if (texture.getDataProvider() == null) {
            texture.setDataProvider((TextureDataProvider)new FecColorTexture(fec));
        }
        return texture;
    }

    public void update(Integer n, int n2) {
        Texture texture;
        if (TEXTURE_PROPERTIES.contains(n2) && (texture = this.textureMap.get(n)) != null) {
            texture.setDataProvider(null);
        }
    }

    void updateAll() throws ObjectRemovedException, OutOfMemoryException {
        for (Map.Entry<Integer, Texture> entry : this.textureMap.entrySet()) {
            this.drawerVisitor.getDataManager().updateTextureCoordinatesBuffer(entry.getKey());
            entry.getValue().setDataProvider(null);
        }
    }

    public void dispose(Integer n) {
        this.textureMap.remove(n);
    }

    private class FecColorTexture
    extends AbstractTextureDataProvider {
        private final Fec fec;

        public FecColorTexture(Fec fec) {
            this.fec = fec;
            this.imageType = TextureDataProvider.ImageType.RGBA_BYTE;
        }

        public Dimension getTextureSize() {
            return new Dimension(this.getTextureLength(), 1);
        }

        public ByteBuffer getData() {
            int n;
            int n2;
            ColorMap colorMap = FecDrawer.this.drawerVisitor.getColorMap();
            Integer[] integerArray = this.fec.getOutsideColor();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4 * this.getTextureLength());
            if (this.useColorRange()) {
                Integer[] integerArray2 = this.fec.getColorRange();
                n2 = Math.max(1, integerArray2[0]);
                n = Math.min(colorMap.getSize(), integerArray2[1]);
            } else {
                n2 = 1;
                n = colorMap.getSize();
            }
            if (integerArray[0] == 0) {
                byteBuffer.put(this.toByte(ColorFactory.createRGBAColor(colorMap, n2)));
            } else if (integerArray[0] > 0) {
                byteBuffer.put(this.toByte(ColorFactory.createRGBAColor(colorMap, integerArray[0])));
            } else {
                byteBuffer.put(this.toByte(ColorFactory.createRGBAColor(colorMap, -2)));
            }
            for (int i = n2; i <= n; ++i) {
                byteBuffer.put(this.toByte(ColorFactory.createRGBAColor(colorMap, i)));
            }
            if (integerArray[1] == 0) {
                byteBuffer.put(this.toByte(ColorFactory.createRGBAColor(colorMap, n)));
            } else if (integerArray[1] > 0) {
                byteBuffer.put(this.toByte(ColorFactory.createRGBAColor(colorMap, integerArray[1])));
            } else {
                byteBuffer.put(this.toByte(ColorFactory.createRGBAColor(colorMap, -2)));
            }
            byteBuffer.rewind();
            return byteBuffer;
        }

        public ByteBuffer getSubData(int n, int n2, int n3, int n4) {
            ByteBuffer byteBuffer = this.getData();
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(4 * n3 * n4);
            byteBuffer.position(n + n2 * this.getTextureLength());
            byte[] byArray = new byte[4];
            for (int i = n; i < n + n3; ++i) {
                for (int j = n2; j < n2 + n4; ++j) {
                    byteBuffer.get(byArray);
                    byteBuffer2.put(byArray);
                }
            }
            byteBuffer2.rewind();
            byteBuffer.rewind();
            return byteBuffer2;
        }

        public boolean isValid() {
            return true;
        }

        private boolean useColorRange() {
            Integer[] integerArray = this.fec.getColorRange();
            return integerArray != null && integerArray.length == 2 && (integerArray[0] != 0 || integerArray[1] != 0);
        }

        private int getTextureLength() {
            ColorMap colorMap = FecDrawer.this.drawerVisitor.getColorMap();
            if (this.useColorRange()) {
                Integer[] integerArray = this.fec.getColorRange();
                int n = Math.max(1, integerArray[0]);
                int n2 = Math.min(colorMap.getSize(), integerArray[1]);
                var2_5 = 1 + n2 - n;
            } else {
                var2_5 = colorMap.getSize();
            }
            return var2_5 += 2;
        }
    }
}

