/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.scilab.modules.preferences.Component.Panel;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XCommonManager;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;

public class TextArea
extends Panel
implements XComponent,
XChooser,
DocumentListener {
    private static final long serialVersionUID = -7007541669965737408L;
    private JTextArea textarea = new JTextArea();
    private JScrollPane scrollPane;
    private ActionListener actionListener;

    @Override
    public final String[] actuators() {
        String[] stringArray = new String[]{"enable", "text", "columns", "rows", "editable", "scroll"};
        return stringArray;
    }

    public TextArea(Node node) {
        super(node);
        this.textarea.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.scrollPane = new JScrollPane(this.textarea);
        this.add(this.scrollPane);
        this.textarea.setFocusable(true);
        this.textarea.setColumns(10);
        this.refresh(node);
    }

    @Override
    public final void refresh(Node node) {
        String string = XCommonManager.getAttribute(node, "text");
        String string2 = XCommonManager.getAttribute(node, "columns");
        String string3 = XCommonManager.getAttribute(node, "rows");
        String string4 = XCommonManager.getAttribute(node, "editable");
        String string5 = XCommonManager.getAttribute(node, "scroll");
        if (!string.equals(this.text())) {
            this.text(string);
        }
        if (!string2.equals(this.columns())) {
            this.columns(string2);
        }
        if (!string3.equals(this.rows())) {
            this.rows(string3);
        }
        if (!string4.equals(this.editable())) {
            this.editable(string4);
        }
        if (!string5.equals(this.scroll())) {
            this.scroll(string5);
        }
        boolean bl = XConfigManager.getBoolean(node, "enable", true);
        this.textarea.setEnabled(bl);
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        if (jScrollBar != null) {
            jScrollBar.setEnabled(bl);
        }
        if ((jScrollBar = this.scrollPane.getHorizontalScrollBar()) != null) {
            jScrollBar.setEnabled(bl);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    private void update() {
        if (this.actionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 0, "TextArea change", System.currentTimeMillis(), 0);
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public final String text() {
        return this.textarea.getText();
    }

    public final void columns(String string) {
        if (!string.equals("\"not an value'")) {
            int n = Integer.parseInt(string);
            this.textarea.setColumns(n);
        }
    }

    public final String columns() {
        return Integer.toString(this.textarea.getColumns());
    }

    public final void rows(String string) {
        if (!string.equals("\"not an value'")) {
            int n = Integer.parseInt(string);
            this.textarea.setRows(n);
        }
    }

    public final String rows() {
        return Integer.toString(this.textarea.getRows());
    }

    public final void editable(String string) {
        this.textarea.setEditable(string.equalsIgnoreCase("true"));
    }

    public final String editable() {
        return Boolean.toString(this.textarea.isEditable());
    }

    public final void scroll(String string) {
        this.scrollPane.setVerticalScrollBarPolicy(string.equalsIgnoreCase("true") ? 20 : 21);
        this.scrollPane.setHorizontalScrollBarPolicy(string.equalsIgnoreCase("true") ? 30 : 31);
    }

    public final String scroll() {
        return Boolean.toString(this.scrollPane.getVerticalScrollBarPolicy() == 20);
    }

    public final void text(String string) {
        this.textarea.setText(string);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.textarea.getDocument().addDocumentListener(documentListener);
    }

    @Override
    public final Object choose() {
        return this.text();
    }

    @Override
    public final String toString() {
        Object object = "TextArea";
        if (!this.text().equals("\"not an value'")) {
            object = (String)object + " text='" + this.text() + "'";
        }
        return object;
    }
}

