/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.help.DefaultHelpModel;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpNavigator;
import javax.help.JHelpSearchNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.SearchView;
import javax.help.TextHelpModel;
import javax.help.TreeItem;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicSearchCellRenderer;
import javax.help.search.MergingSearchEngine;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicSearchNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
SearchListener,
PropertyChangeListener,
TreeSelectionListener,
ComponentListener {
    protected JHelpSearchNavigator searchnav;
    protected JScrollPane sp;
    protected JTree tree;
    protected DefaultMutableTreeNode topNode;
    protected JTextField searchparams;
    protected boolean displayOptions;
    protected SearchEngine helpsearch;
    protected SearchQuery searchquery;
    protected DefaultMutableTreeNode lastTOCnode;
    private HelpSet newHelpSet;
    ActionListener searchAction = new SearchActionListener();
    private Cursor paramCursor;
    private Cursor treeCursor;
    private Cursor waitCursor = null;
    private static boolean debug = false;

    public static ComponentUI createUI(JComponent x) {
        return new BasicSearchNavigatorUI((JHelpSearchNavigator)x);
    }

    public BasicSearchNavigatorUI(JHelpSearchNavigator b) {
        ImageIcon icon = this.getImageIcon(b.getNavigatorView());
        if (icon != null) {
            this.setIcon(icon);
        } else {
            this.setIcon(UIManager.getIcon("SearchNav.icon"));
        }
    }

    public void installUI(JComponent c) {
        this.searchnav = (JHelpSearchNavigator)c;
        HelpModel helpmodel = this.searchnav.getModel();
        this.searchnav.setLayout(new BorderLayout());
        this.searchnav.addPropertyChangeListener(this);
        this.searchnav.addComponentListener(this);
        if (helpmodel != null) {
            helpmodel.addHelpModelListener(this);
        }
        JLabel search = new JLabel(HelpUtilities.getString(HelpUtilities.getLocale(c), "search.findLabel"));
        this.searchparams = new JTextField("", 20);
        search.setLabelFor(this.searchparams);
        this.searchparams.addActionListener(this.searchAction);
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 0));
        box.add(search);
        box.add(this.searchparams);
        this.searchnav.add("North", box);
        this.topNode = new DefaultMutableTreeNode();
        this.lastTOCnode = null;
        this.tree = new JTree(this.topNode);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.searchnav.add("Center", this.sp);
        this.reloadData();
    }

    public void uninstallUI(JComponent c) {
        HelpModel helpmodel = this.searchnav.getModel();
        this.searchnav.removeComponentListener(this);
        this.searchnav.removePropertyChangeListener(this);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.removeTreeSelectionListener(this);
        this.searchnav.setLayout(null);
        this.searchnav.removeAll();
        if (helpmodel != null) {
            helpmodel.removeHelpModelListener(this);
        }
        this.searchnav = null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(200, 100);
    }

    public Dimension getMinimumSize(JComponent c) {
        if (this.sp != null) {
            return ((ScrollPaneLayout)this.sp.getLayout()).minimumLayoutSize(this.sp);
        }
        return new Dimension(100, 100);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void reloadData() {
        this.helpsearch = null;
        this.setCellRenderer(this.searchnav.getNavigatorView(), this.tree);
        HelpModel model = this.searchnav.getModel();
        if (model != null) {
            this.addSubHelpSets(model.getHelpSet());
        }
    }

    private void reloadData(HelpModel model) {
        BasicSearchNavigatorUI.debug("reloadData using new model");
        this.helpsearch = null;
        SearchView view = null;
        this.newHelpSet = model.getHelpSet();
        SearchView oldView = (SearchView)this.searchnav.getNavigatorView();
        String oldName = oldView.getName();
        NavigatorView[] navViews = this.newHelpSet.getNavigatorViews();
        for (int i = 0; i < navViews.length; ++i) {
            NavigatorView tempView;
            if (!navViews[i].getName().equals(oldName) || !((tempView = navViews[i]) instanceof SearchView)) continue;
            view = (SearchView)tempView;
            break;
        }
        if (view == null) {
            return;
        }
        this.topNode.removeAllChildren();
        this.searchnav.setSearchEngine(new MergingSearchEngine(view));
        this.setCellRenderer(view, this.tree);
        this.addSubHelpSets(this.newHelpSet);
    }

    protected void addSubHelpSets(HelpSet hs) {
        Enumeration e = hs.getHelpSets();
        while (e.hasMoreElements()) {
            HelpSet ehs = (HelpSet)e.nextElement();
            NavigatorView[] views = ehs.getNavigatorViews();
            for (int i = 0; i < views.length; ++i) {
                if (!this.searchnav.canMerge(views[i])) continue;
                try {
                    this.searchnav.merge(views[i]);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    Hashtable params = views[i].getParameters();
                    Object data = null;
                    if (params != null) {
                        data = params.get("data");
                    }
                    throw new IllegalArgumentException("View is invalid:\n   View Name: " + views[i].getName() + "   View Class: " + views[i].getClass().getName() + "   View Params: " + params + "   View Data: " + data + "   HelpSet URL: " + views[i].getHelpSet().getHelpSetURL());
                }
            }
            this.addSubHelpSets(ehs);
        }
    }

    public void merge(NavigatorView view) {
        BasicSearchNavigatorUI.debug("merging " + view);
        String text = this.searchparams.getText();
        if (text != null && text.length() != 0) {
            this.searchAction.actionPerformed(new ActionEvent(this.searchparams, 1001, ""));
        }
    }

    public void remove(NavigatorView view) {
        BasicSearchNavigatorUI.debug("removing " + view);
        if (this.searchparams.getText() != null) {
            this.searchAction.actionPerformed(new ActionEvent(this.searchparams, 1001, ""));
        }
    }

    protected void setCellRenderer(NavigatorView view, JTree tree) {
        if (view == null) {
            return;
        }
        Map map = view.getHelpSet().getCombinedMap();
        tree.setCellRenderer(new BasicSearchCellRenderer(map));
    }

    public void idChanged(HelpModelEvent e) {
        Map.ID nId;
        DefaultMutableTreeNode tn;
        SearchTOCItem item;
        Object o;
        Map.ID id = e.getID();
        URL url = e.getURL();
        HelpModel helpModel = this.searchnav.getModel();
        BasicSearchNavigatorUI.debug("idChanged(" + e + ")");
        if (e.getSource() != helpModel) {
            BasicSearchNavigatorUI.debug("Internal inconsistency!");
            BasicSearchNavigatorUI.debug("  " + e.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        TreePath s = this.tree.getSelectionPath();
        if (s != null && (o = s.getLastPathComponent()) instanceof DefaultMutableTreeNode && (item = (SearchTOCItem)(tn = (DefaultMutableTreeNode)o).getUserObject()) != null && (nId = item.getID()) != null && nId.equals(id)) {
            return;
        }
        DefaultMutableTreeNode node = this.findIDorURL(this.topNode, id, url);
        if (node == null) {
            BasicSearchNavigatorUI.debug("node didn't exist");
            this.tree.clearSelection();
            return;
        }
        TreePath path = new TreePath(node.getPath());
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    protected JHelpNavigator getHelpNavigator() {
        return this.searchnav;
    }

    public void valueChanged(TreeSelectionEvent e) {
        SearchTOCItem item;
        JHelpNavigator navigator = this.getHelpNavigator();
        HelpModel helpmodel = navigator.getModel();
        BasicSearchNavigatorUI.debug("ValueChanged: " + e);
        BasicSearchNavigatorUI.debug("  model: " + helpmodel);
        TreeItem[] items = null;
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            items = new TreeItem[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i] == null) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                items[i] = (TreeItem)node.getUserObject();
            }
        }
        navigator.setSelectedItems(items);
        if (items != null && items.length == 1 && (item = (SearchTOCItem)items[0]) != null) {
            if (item.getID() != null) {
                try {
                    helpmodel.setCurrentID(item.getID(), item.getName(), navigator);
                }
                catch (InvalidHelpSetContextException ex) {
                    System.err.println("BadID: " + item.getID());
                    return;
                }
            } else if (item.getURL() != null) {
                helpmodel.setCurrentURL(item.getURL(), item.getName(), navigator);
            } else {
                return;
            }
            if (helpmodel instanceof TextHelpModel) {
                TextHelpModel.Highlight[] h = new DefaultHelpModel.DefaultHighlight[item.hitCount()];
                int i = 0;
                Enumeration enum1 = item.getSearchHits();
                while (enum1.hasMoreElements()) {
                    SearchHit info = (SearchHit)enum1.nextElement();
                    h[i] = new DefaultHelpModel.DefaultHighlight(info.getBegin(), info.getEnd());
                    ++i;
                }
                ((TextHelpModel)helpmodel).setHighlights(h);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        BasicSearchNavigatorUI.debug(this + " " + "propertyChange: " + event.getSource() + " " + event.getPropertyName());
        if (event.getSource() == this.searchnav) {
            String changeName = event.getPropertyName();
            if (changeName.equals("helpModel")) {
                this.reloadData((HelpModel)event.getNewValue());
            } else if (changeName.equals("font")) {
                BasicSearchNavigatorUI.debug("Font change");
                Font newFont = (Font)event.getNewValue();
                this.searchparams.setFont(newFont);
                RepaintManager.currentManager(this.searchparams).markCompletelyDirty(this.searchparams);
                this.tree.setFont(newFont);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            }
        }
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        this.searchparams.selectAll();
        this.searchparams.requestFocus();
    }

    public void componentHidden(ComponentEvent e) {
    }

    private DefaultMutableTreeNode findIDorURL(DefaultMutableTreeNode node, Map.ID id, URL url) {
        SearchTOCItem item = (SearchTOCItem)node.getUserObject();
        if (item != null) {
            Map.ID testID = item.getID();
            if (testID != null && id != null && testID.equals(id)) {
                return node;
            }
            URL testURL = item.getURL();
            if (testURL != null && url != null && url.sameFile(testURL)) {
                return node;
            }
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode test = this.findIDorURL(tmp, id, url);
            if (test == null) continue;
            return test;
        }
        return null;
    }

    private void reorder(Vector nodes) {
        BasicSearchNavigatorUI.debug("reorder nodes");
        this.topNode.removeAllChildren();
        Object[] array = new DefaultMutableTreeNode[nodes.size()];
        nodes.copyInto(array);
        this.quickSort((DefaultMutableTreeNode[])array, 0, array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            this.topNode.add((MutableTreeNode)array[i]);
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.invalidate();
        this.tree.repaint();
    }

    void quickSort(DefaultMutableTreeNode[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = (lo0 + hi0) / 2;
            while (lo <= hi) {
                while (lo < hi0 && this.compare(a[lo], a[mid]) > 0) {
                    ++lo;
                }
                while (hi > lo0 && this.compare(a[hi], a[mid]) < 0) {
                    --hi;
                }
                if (lo > hi) continue;
                this.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    private void swap(DefaultMutableTreeNode[] a, int i, int j) {
        DefaultMutableTreeNode T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    private int compare(DefaultMutableTreeNode node1, DefaultMutableTreeNode node2) {
        SearchTOCItem item1 = (SearchTOCItem)node1.getUserObject();
        double confidence1 = item1.getConfidence();
        int hits1 = item1.hitCount();
        SearchTOCItem item2 = (SearchTOCItem)node2.getUserObject();
        double confidence2 = item2.getConfidence();
        int hits2 = item2.hitCount();
        if (confidence1 > confidence2) {
            return -1;
        }
        if (confidence1 < confidence2) {
            return 1;
        }
        if (hits1 < hits2) {
            return -1;
        }
        if (hits1 > hits2) {
            return 1;
        }
        return 0;
    }

    public synchronized void itemsFound(SearchEvent e) {
        SwingUtilities.invokeLater(new SearchItemsFound(e));
    }

    public synchronized void searchStarted(SearchEvent e) {
        BasicSearchNavigatorUI.debug("search Started");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeSelectionModel tsm = BasicSearchNavigatorUI.this.tree.getSelectionModel();
                tsm.clearSelection();
                BasicSearchNavigatorUI.this.topNode.removeAllChildren();
                ((DefaultTreeModel)BasicSearchNavigatorUI.this.tree.getModel()).reload();
                BasicSearchNavigatorUI.this.tree.invalidate();
                BasicSearchNavigatorUI.this.tree.repaint();
            }
        });
    }

    public synchronized void searchFinished(SearchEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeSelectionModel tsm = BasicSearchNavigatorUI.this.tree.getSelectionModel();
                if (BasicSearchNavigatorUI.this.lastTOCnode == null && BasicSearchNavigatorUI.this.topNode.getChildCount() > 0) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)BasicSearchNavigatorUI.this.topNode.getFirstChild();
                    if (node != null) {
                        tsm.clearSelection();
                        tsm.setSelectionPath(new TreePath(node.getPath()));
                    }
                } else {
                    BasicSearchNavigatorUI.this.searchnav.getToolkit().beep();
                }
                BasicSearchNavigatorUI.this.searchparams.setCursor(BasicSearchNavigatorUI.this.paramCursor);
                BasicSearchNavigatorUI.this.tree.setCursor(BasicSearchNavigatorUI.this.treeCursor);
            }
        });
    }

    private static void debug(String str) {
        if (debug) {
            System.out.println("BasicSearchNavigatorUI: " + str);
        }
    }

    class SearchItemsFound
    implements Runnable {
        SearchEvent e;

        SearchItemsFound(SearchEvent e) {
            this.e = e;
        }

        public void run() {
            Vector<DefaultMutableTreeNode> nodes = new Vector<DefaultMutableTreeNode>();
            Enumeration<TreeNode> children = BasicSearchNavigatorUI.this.topNode.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
                nodes.addElement(node);
            }
            BasicSearchNavigatorUI.debug("items found");
            HelpModel helpmodel = BasicSearchNavigatorUI.this.searchnav.getModel();
            HelpSet hs = helpmodel.getHelpSet();
            BasicSearchNavigatorUI.debug("hs:" + hs.toString());
            Map map = hs.getCombinedMap();
            Enumeration itemEnum = this.e.getSearchItems();
            while (itemEnum.hasMoreElements()) {
                SearchTOCItem tocitem;
                URL url;
                SearchItem item = (SearchItem)itemEnum.nextElement();
                BasicSearchNavigatorUI.debug("  item: " + item);
                try {
                    url = new URL(item.getBase(), item.getFilename());
                }
                catch (MalformedURLException me) {
                    System.err.println("Failed to create URL from " + item.getBase() + "|" + item.getFilename());
                    continue;
                }
                boolean foundNode = false;
                DefaultMutableTreeNode node = null;
                Enumeration nodesEnum = nodes.elements();
                while (nodesEnum.hasMoreElements()) {
                    node = (DefaultMutableTreeNode)nodesEnum.nextElement();
                    tocitem = (SearchTOCItem)node.getUserObject();
                    URL testURL = tocitem.getURL();
                    if (testURL == null || url == null || !url.sameFile(testURL)) continue;
                    tocitem = (SearchTOCItem)node.getUserObject();
                    tocitem.addSearchHit(new SearchHit(item.getConfidence(), item.getBegin(), item.getEnd()));
                    foundNode = true;
                    break;
                }
                if (foundNode) continue;
                tocitem = new SearchTOCItem(item);
                node = new DefaultMutableTreeNode(tocitem);
                nodes.addElement(node);
            }
            BasicSearchNavigatorUI.this.reorder(nodes);
            ((DefaultTreeModel)BasicSearchNavigatorUI.this.tree.getModel()).reload();
        }
    }

    class SearchActionListener
    implements ActionListener {
        SearchActionListener() {
        }

        public synchronized void actionPerformed(ActionEvent e) {
            HelpModel helpmodel = BasicSearchNavigatorUI.this.searchnav.getModel();
            try {
                if (BasicSearchNavigatorUI.this.paramCursor == null) {
                    BasicSearchNavigatorUI.this.paramCursor = BasicSearchNavigatorUI.this.searchparams.getCursor();
                }
                if (BasicSearchNavigatorUI.this.treeCursor == null) {
                    BasicSearchNavigatorUI.this.treeCursor = BasicSearchNavigatorUI.this.tree.getCursor();
                }
                if (BasicSearchNavigatorUI.this.waitCursor == null) {
                    BasicSearchNavigatorUI.this.waitCursor = Cursor.getPredefinedCursor(3);
                }
                BasicSearchNavigatorUI.this.searchparams.setCursor(BasicSearchNavigatorUI.this.waitCursor);
                BasicSearchNavigatorUI.this.tree.setCursor(BasicSearchNavigatorUI.this.waitCursor);
                if (BasicSearchNavigatorUI.this.helpsearch == null) {
                    BasicSearchNavigatorUI.debug("helpsearch is null");
                    BasicSearchNavigatorUI.this.helpsearch = BasicSearchNavigatorUI.this.searchnav.getSearchEngine();
                    BasicSearchNavigatorUI.this.searchquery = BasicSearchNavigatorUI.this.helpsearch.createQuery();
                    BasicSearchNavigatorUI.this.searchquery.addSearchListener(BasicSearchNavigatorUI.this);
                }
                BasicSearchNavigatorUI.debug("click on search w/: " + BasicSearchNavigatorUI.this.searchparams.getText());
                if (BasicSearchNavigatorUI.this.searchquery.isActive()) {
                    BasicSearchNavigatorUI.this.searchquery.stop();
                }
                BasicSearchNavigatorUI.this.searchquery.start(BasicSearchNavigatorUI.this.searchparams.getText(), BasicSearchNavigatorUI.this.searchnav.getLocale());
            }
            catch (Exception e2) {
                BasicSearchNavigatorUI.this.searchparams.setCursor(BasicSearchNavigatorUI.this.paramCursor);
                BasicSearchNavigatorUI.this.tree.setCursor(BasicSearchNavigatorUI.this.treeCursor);
                e2.printStackTrace();
                BasicSearchNavigatorUI.this.searchnav.getToolkit().beep();
                BasicSearchNavigatorUI.this.searchnav.getToolkit().beep();
            }
        }
    }
}

