/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.QueryHit;
import java.util.Vector;

class HitStoreNode {
    private int _free = 0;
    private int _size;
    private QueryHit[] _array;
    private int _hitCount = 0;
    private double _divider = 0.0;
    private double _min = 1.0E7;
    private double _max = 0.0;
    private HitStoreNode[] _children = new HitStoreNode[2];
    private int _index = 0;

    public HitStoreNode(int size) {
        this._size = size;
        this._array = new QueryHit[this._size];
    }

    public QueryHit getNextHit() {
        return this._index < this._free ? this._array[this._index++] : null;
    }

    private void fastAdd(QueryHit hit) {
        ++this._hitCount;
        this._divider += hit.getScore();
        if (hit.getScore() > this._max) {
            this._max = hit.getScore();
        }
        if (hit.getScore() < this._min) {
            this._min = hit.getScore();
        }
        this._array[this._free++] = hit;
    }

    public boolean add(QueryHit hit) {
        if (this._array != null) {
            if (this._free < this._size) {
                this.fastAdd(hit);
                return false;
            }
            if (this._min != this._max) {
                this.split();
                ++this._hitCount;
                this._children[hit.getScore() > this._divider ? 1 : 0].fastAdd(hit);
                return true;
            }
            QueryHit[] newArray = new QueryHit[this._size *= 2];
            System.arraycopy(this._array, 0, newArray, 0, this._free);
            this._array = newArray;
            this.fastAdd(hit);
            return true;
        }
        ++this._hitCount;
        return this._children[hit.getScore() > this._divider ? 1 : 0].add(hit);
    }

    private void split() {
        this._children[0] = new HitStoreNode(this._size);
        this._children[1] = new HitStoreNode(this._size);
        this._divider /= (double)this._hitCount;
        for (int i = 0; i < this._free; ++i) {
            this._children[this._array[i].getScore() > this._divider ? 1 : 0].fastAdd(this._array[i]);
        }
        this._array = null;
    }

    public int getCount() {
        return this._hitCount;
    }

    public double getDivider() {
        return this._divider;
    }

    public HitStoreNode getLChild() {
        return this._children[0];
    }

    public HitStoreNode getRChild() {
        return this._children[1];
    }

    public void setLChild(HitStoreNode node) {
        this._children[0] = node;
    }

    public void setRChild(HitStoreNode node) {
        this._children[1] = node;
    }

    public void decrementCount(int delta) {
        this._hitCount -= delta;
    }

    public boolean isLeaf() {
        return this._array != null;
    }

    public void sort() {
        this.quicksort(0, this._free - 1);
    }

    public void gatherLeaves(Vector vector) {
        if (this.isLeaf()) {
            vector.addElement(this);
        } else {
            this.getLChild().gatherLeaves(vector);
            this.getRChild().gatherLeaves(vector);
        }
    }

    private int partition(int p, int r) {
        QueryHit x = this._array[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (x.betterThan(this._array[--j])) {
                continue;
            }
            while (this._array[++i].betterThan(x)) {
            }
            if (i >= j) break;
            QueryHit t = this._array[i];
            this._array[i] = this._array[j];
            this._array[j] = t;
        }
        return j;
    }

    private void quicksort(int p, int r) {
        if (p < r) {
            int q = this.partition(p, r);
            this.quicksort(p, q);
            this.quicksort(q + 1, r);
        }
    }
}

