/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Compressor;
import com.sun.java.help.search.ConceptLocation;
import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.StreamDecompressor;
import java.io.BufferedInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;

class DocumentCompressor {
    public static final int NConceptsInGroup = 16;
    public static final int BitsInLabel = 4;
    public static final int DefaultSize = 32;
    private int _nGroups;
    private int _nExtents;
    private int _freeComp;
    private int _sizeComp = 32;
    private int _kk;
    private Compressor _currentCompressor = null;
    private Compressor[] _compressors = new Compressor[32];
    private Compressor _kCompr = new Compressor();
    private Compressor _lCompr = new Compressor();
    private Compressor _mCompr = new Compressor();
    private Compressor _posCompressor = new Compressor();
    private IntegerArray _kTable = new IntegerArray();
    private IntegerArray _lTable = new IntegerArray();
    private IntegerArray _maxConcepts = new IntegerArray();
    private IntegerArray _concepts = new IntegerArray();
    private IntegerArray _documents = new IntegerArray();
    private IntegerArray _offsets = new IntegerArray();
    private IntegerArray _titles = new IntegerArray();
    private IntegerArray _positions = new IntegerArray();
    private IntegerArray _labels = new IntegerArray();
    private RandomAccessFile _posFile;
    private static boolean debug = false;

    public DocumentCompressor(URL url) throws Exception {
        URL posURL = new URL(url, "POSITIONS");
        if (this.isFileURL(posURL)) {
            try {
                URL offURL = new URL(url, "OFFSETS");
                URLConnection connect = offURL.openConnection();
                BufferedInputStream in = new BufferedInputStream(connect.getInputStream());
                int k1 = in.read();
                StreamDecompressor sddocs = new StreamDecompressor(in);
                sddocs.ascDecode(k1, this._documents);
                int k2 = in.read();
                StreamDecompressor sdoffsets = new StreamDecompressor(in);
                sdoffsets.ascDecode(k2, this._offsets);
                int k3 = in.read();
                StreamDecompressor sdtitles = new StreamDecompressor(in);
                sdtitles.decode(k3, this._titles);
                in.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        } else {
            throw new IOException();
        }
        this._posFile = new RandomAccessFile(new File(posURL.toURI()), "rw");
    }

    private boolean isFileURL(URL url) {
        return url.getProtocol().equalsIgnoreCase("file");
    }

    public void close(String indexFile) throws IOException {
        this._posFile.close();
        this.writeOutOffsets(indexFile);
    }

    public void compress(int docID, int titleID, ConceptLocation[] locations, int count, ConceptLocation[] extents, int extCount) throws IOException {
        long start = System.currentTimeMillis();
        this.encode(locations, count, 16);
        if (extCount > 0) {
            this.encodeExtents(extents, extCount);
        }
        this.finalizeEncoding();
        DocumentCompressor.debug(System.currentTimeMillis() - start + " msec proc");
        int nBytes = this.byteCount();
        start = System.currentTimeMillis();
        long currentEnd = this._posFile.length();
        this._documents.add(docID);
        this._offsets.add((int)currentEnd);
        this._titles.add(titleID);
        this._posFile.seek(currentEnd);
        this.writeOut(this._posFile);
        DocumentCompressor.debug(System.currentTimeMillis() - start + " msec file");
        DocumentCompressor.debug("nGroups = " + this._nGroups);
    }

    private void writeOutOffsets(String indexFile) throws IOException {
        Compressor documents = new Compressor();
        int k1 = documents.compressAscending(this._documents);
        Compressor offsets = new Compressor();
        int k2 = offsets.compressAscending(this._offsets);
        Compressor titles = new Compressor();
        int k3 = titles.minimize(this._titles, 8);
        int nBytes = documents.byteCount();
        RandomAccessFile out = new RandomAccessFile(indexFile, "rw");
        out.seek(0L);
        out.write(k1);
        documents.write(out);
        out.write(k2);
        offsets.write(out);
        out.write(k3);
        titles.write(out);
        out.close();
    }

    private void encode(ConceptLocation[] locations, int count, int nConcepts) {
        int initK = 4;
        ConceptLocation.sortByConcept(locations, 0, count);
        this.clear();
        int conceptCounter = 0;
        int fromIndex = 0;
        int prevMax = 0;
        int last = locations[0].getConcept();
        this.nextCompressor();
        this._concepts.add(last);
        int i = 0;
        while (true) {
            if (i < count && locations[i].getConcept() == last) {
                locations[i].setConcept(conceptCounter);
                ++i;
                continue;
            }
            if (i == count) {
                if (this._concepts.cardinality() > 0) {
                    ++this._nGroups;
                    this._kTable.add(this._currentCompressor.minimize(this._concepts, 4));
                }
                break;
            }
            if (++conceptCounter == nConcepts) {
                ++this._nGroups;
                this._concepts.popLast();
                this._maxConcepts.add(last - prevMax);
                prevMax = last;
                this._kTable.add(this._currentCompressor.minimize(this._concepts, 4));
                this.encodePositions(locations, fromIndex, i, 4);
                fromIndex = i;
                this.nextCompressor();
                this._concepts.clear();
                conceptCounter = 0;
            }
            this._concepts.add(locations[i].getConcept() - last);
            last = locations[i].getConcept();
        }
        this.encodePositions(locations, fromIndex, i, 4);
    }

    private void encodePositions(ConceptLocation[] locations, int from, int to, int cK) {
        int initK = 3;
        ConceptLocation.sortByPosition(locations, from, to);
        this._positions.clear();
        this._labels.clear();
        int lastPos = locations[from].getBegin();
        this._positions.add(lastPos);
        this._labels.add(locations[from].getConcept());
        int i = from;
        for (int j = from + 1; j < to; ++j) {
            if (locations[i].equals(locations[j])) continue;
            i = j;
            this._positions.add(locations[i].getBegin() - lastPos);
            lastPos = locations[i].getBegin();
            this._labels.add(locations[i].getConcept());
        }
        int k = this._posCompressor.minimize(this._positions, 3);
        this._kTable.add(k);
        this._posCompressor.clear();
        this._posCompressor.encode(this._positions, this._labels, k, cK);
        this._currentCompressor.concatenate(this._posCompressor);
    }

    private void encodeExtents(ConceptLocation[] extents, int extCount) {
        int initK = 4;
        int c = 0;
        IntegerArray concepts = new IntegerArray(extCount);
        IntegerArray lengths = new IntegerArray();
        IntegerArray kTable = new IntegerArray();
        IntegerArray lTable = new IntegerArray();
        this.nextCompressor();
        Compressor extentsHeader = this._currentCompressor;
        for (int i = 0; i < extCount; ++i) {
            if (extents[i].getConcept() != c) {
                if (c != 0) {
                    ++this._nExtents;
                    this.nextCompressor();
                    kTable.add(this._currentCompressor.minimize(lengths, 4));
                    lTable.add(this._currentCompressor.byteCount());
                }
                concepts.add(extents[i].getConcept() - c);
                c = extents[i].getConcept();
                lengths.clear();
                lengths.add(extents[i].getLength());
                continue;
            }
            lengths.add(extents[i].getLength());
        }
        this.nextCompressor();
        kTable.add(this._currentCompressor.minimize(lengths, 4));
        lTable.add(this._currentCompressor.byteCount());
        Compressor compressor1 = new Compressor();
        kTable.add(compressor1.minimize(lTable, 4));
        Compressor compressor2 = new Compressor();
        kTable.add(compressor2.minimize(concepts, 4));
        this._kTable.add(extentsHeader.minimize(kTable, 4));
        extentsHeader.concatenate(compressor1);
        extentsHeader.concatenate(compressor2);
    }

    private void finalizeEncoding() {
        if (this._nGroups > 1) {
            int limit = this._nExtents > 0 ? this._freeComp : this._freeComp - 1;
            for (int j = 0; j < limit; ++j) {
                this._lTable.add(this._compressors[j].byteCount());
            }
            this._kTable.add(this._mCompr.minimize(this._maxConcepts, 3));
            this._kTable.add(this._lCompr.minimize(this._lTable, 3));
            this._kk = this._kCompr.minimize(this._kTable, 3);
            this._kCompr.concatenate(this._lCompr);
            this._kCompr.concatenate(this._mCompr);
        } else if (this._nGroups == 1 && this._nExtents > 0) {
            this._kTable.add(this._compressors[0].byteCount());
            this._kk = this._kCompr.minimize(this._kTable, 3);
        }
        DocumentCompressor.debug("compr: " + this.byteCount() + " bytes");
    }

    private void writeOut(DataOutput out) throws IOException {
        if (this._nExtents == 0) {
            if (this._nGroups > 1) {
                out.write(0x80 | this._kk);
                this._kCompr.write(out);
                for (int j = 0; j < this._freeComp; ++j) {
                    this._compressors[j].write(out);
                }
            } else {
                out.write(this._kTable.at(0));
                out.write(this._kTable.at(1));
                this._compressors[0].write(out);
            }
        } else {
            out.write((this._nGroups > 1 ? 192 : 64) | this._kk);
            this._kCompr.write(out);
            for (int j = 0; j < this._freeComp; ++j) {
                this._compressors[j].write(out);
            }
        }
    }

    private Compressor nextCompressor() {
        if (this._freeComp == this._sizeComp) {
            Compressor[] newArray = new Compressor[this._sizeComp *= 2];
            System.arraycopy(this._compressors, 0, newArray, 0, this._freeComp);
            this._compressors = newArray;
        }
        if (this._compressors[this._freeComp] == null) {
            this._compressors[this._freeComp] = new Compressor();
        }
        this._currentCompressor = this._compressors[this._freeComp++];
        return this._currentCompressor;
    }

    private int byteCount() {
        if (this._nGroups == 1 && this._nExtents == 0) {
            return 2 + this._compressors[0].byteCount();
        }
        int result = 1;
        result += this._kCompr.byteCount();
        for (int j = 0; j < this._freeComp; ++j) {
            result += this._compressors[j].byteCount();
        }
        return result;
    }

    private void clear() {
        this._nGroups = 0;
        this._nExtents = 0;
        this._kTable.clear();
        this._lTable.clear();
        this._concepts.clear();
        this._maxConcepts.clear();
        this._kCompr.clear();
        this._lCompr.clear();
        this._mCompr.clear();
        for (int i = 0; i < this._sizeComp; ++i) {
            if (this._compressors[i] == null) continue;
            this._compressors[i].clear();
        }
        this._freeComp = 0;
        this._currentCompressor = null;
    }

    private static void debug(String msg) {
        if (debug) {
            System.err.println("DocumentCompressor: " + msg);
        }
    }
}

