/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.SwingUtilities;
import org.scilab.modules.commons.ScilabCommons;
import org.scilab.modules.commons.ScilabConstants;

public final class ScilabCommonsUtils {
    private static final int BUFFERSIZE = 8192;
    private static Thread scilabThread;
    private static MessageDigest MD5;

    public static int[] getScilabVersions() {
        return new int[]{ScilabCommons.getScilabVersionMajor(), ScilabCommons.getScilabVersionMinor(), ScilabCommons.getScilabVersionMaintenance(), ScilabCommons.getScilabVersionTimestamp()};
    }

    public static String getScilabVersion() {
        return ScilabCommons.getScilabVersionMajor() + "." + ScilabCommons.getScilabVersionMinor() + "." + ScilabCommons.getScilabVersionMaintenance();
    }

    public static String getScilabVersionAsString() {
        return ScilabCommons.getScilabVersionAsString().replaceFirst("scilab-", "");
    }

    public static String getMD5(String string) {
        if (MD5 == null) {
            return null;
        }
        try {
            byte[] byArray = MD5.digest(string.getBytes("UTF-8"));
            return String.format("%032x", new BigInteger(1, byArray));
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File file, File file2) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[8192];
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            bl = true;
        }
        catch (IOException iOException) {
            System.err.println("Error in copying file " + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
            System.err.println(iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }
        return bl;
    }

    public static String getCorrectedPath(String string) {
        String string2 = "";
        string = string.trim();
        String string3 = string.replace("\\", "/");
        if (string != null && !string.isEmpty()) {
            if (string.startsWith("~/") || string.equals("~")) {
                string2 = ScilabConstants.USERHOME.replace("\\", "/");
                return string.replaceFirst("~", string2);
            }
            if (string.startsWith("SCI/") || string.equals("SCI")) {
                try {
                    string2 = ScilabConstants.SCI.getCanonicalPath().replace("\\", "/");
                }
                catch (IOException iOException) {
                    string2 = ScilabConstants.SCI.getAbsolutePath().replace("\\", "/");
                }
                return string3.replaceFirst("SCI", string2).replace("/", File.separator);
            }
            if (string.startsWith("SCIHOME/") || string.equals("SCIHOME")) {
                string2 = ScilabConstants.SCIHOME.toString().replace("\\", "/");
                return string.replaceFirst("SCIHOME", string2).replace("/", File.separator);
            }
            if (string.startsWith("TMPDIR/") || string.equals("TMPDIR")) {
                string2 = ScilabCommons.getTMPDIR().replace("\\", "/");
                return string.replaceFirst("TMPDIR", string2).replace("/", File.separator);
            }
        }
        return string;
    }

    public static void loadOnUse(String string) {
        final String string2 = string;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                try {
                    Class<?> clazz = Class.forName("org.scilab.modules.jvm.LoadClassPath");
                    Method method = clazz.getDeclaredMethod("loadOnUse", String.class);
                    method.invoke(null, string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Could not find the Scilab class to load dependency: " + String.valueOf(classNotFoundException));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.err.println("Could not find the Scilab method to load dependency: " + String.valueOf(noSuchMethodException));
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("Could not access to the Scilab method to load dependency: " + String.valueOf(illegalAccessException));
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println("Could not invoke the Scilab method to load dependency: " + String.valueOf(invocationTargetException));
                }
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Class<?> clazz = Class.forName("org.scilab.modules.jvm.LoadClassPath");
                            Method method = clazz.getDeclaredMethod("loadOnUse", String.class);
                            method.invoke(null, string2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            System.err.println("Could not find the Scilab class to load dependency: " + String.valueOf(classNotFoundException));
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            System.err.println("Could not find the Scilab method to load dependency: " + String.valueOf(noSuchMethodException));
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.err.println("Could not access to the Scilab method to load dependency: " + String.valueOf(illegalAccessException));
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.err.println("Could not invoke the Scilab method to load dependency: " + String.valueOf(invocationTargetException));
                        }
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static void registerScilabThread() {
        scilabThread = Thread.currentThread();
    }

    public static boolean isScilabThread() {
        return scilabThread != null && scilabThread == Thread.currentThread();
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println(noSuchAlgorithmException);
            MD5 = null;
        }
    }
}

