/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.event;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxGraph;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.Timer;

public final class ArrowKeyListener
implements KeyListener {
    private static final int DEFAULT_PIXEL_MOVE = 1;
    private static final int MODIFIER_FACTOR = 5;
    private static final int DEFAULT_DELAY = 800;
    private final int pixelMove = 1;
    private int delay = 800;
    private double xIncrement;
    private double yIncrement;
    private mxGraph graph;
    private final Timer repetitionTimer;
    private final ActionListener doMove = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ArrowKeyListener.this.graph != null) {
                mxIGraphModel mxIGraphModel2 = ArrowKeyListener.this.graph.getModel();
                mxIGraphModel2.beginUpdate();
                try {
                    for (Object object : ArrowKeyListener.this.graph.getSelectionCells()) {
                        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object);
                        ArrowKeyListener.snap(ArrowKeyListener.this.graph, mxGeometry2);
                        ArrowKeyListener.this.graph.translateCell(object, ArrowKeyListener.this.xIncrement, ArrowKeyListener.this.yIncrement);
                    }
                }
                finally {
                    mxIGraphModel2.endUpdate();
                }
            }
        }
    };

    private static final mxGeometry snap(mxGraph mxGraph2, mxGeometry mxGeometry2) {
        double d = mxGraph2.snap(mxGeometry2.getX());
        double d2 = mxGraph2.snap(mxGeometry2.getY());
        double d3 = mxGraph2.snap(mxGeometry2.getWidth() - d + mxGeometry2.getX());
        double d4 = mxGraph2.snap(mxGeometry2.getHeight() - d2 + mxGeometry2.getY());
        List list = mxGeometry2.getPoints();
        if (list != null) {
            for (mxPoint mxPoint2 : list) {
                mxPoint2.setX(mxGraph2.snap(mxPoint2.getX()));
                mxPoint2.setY(mxGraph2.snap(mxPoint2.getY()));
            }
        }
        mxGeometry mxGeometry3 = new mxGeometry(d, d2, d3, d4);
        mxGeometry3.setPoints(list);
        return mxGeometry3;
    }

    public ArrowKeyListener() {
        this.repetitionTimer = new Timer(this.delay, this.doMove);
        this.repetitionTimer.setInitialDelay(0);
    }

    public void setDelay(int n) {
        this.delay = n;
        this.repetitionTimer.setDelay(n);
    }

    public int getDelay() {
        return this.delay;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        boolean bl = true;
        mxGraphComponent mxGraphComponent2 = (mxGraphComponent)keyEvent.getSource();
        this.graph = mxGraphComponent2.getGraph();
        int n = this.graph.isGridEnabled() ? this.graph.getGridSize() : 1;
        if (keyEvent.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
            n *= 5;
        }
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.yIncrement = -n;
                break;
            }
            case 40: {
                this.yIncrement = n;
                break;
            }
            case 39: {
                this.xIncrement = n;
                break;
            }
            case 37: {
                this.xIncrement = -n;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (!bl) {
            return;
        }
        if (!this.graph.isGridEnabled()) {
            this.xIncrement *= mxGraphComponent2.getZoomFactor();
            this.yIncrement *= mxGraphComponent2.getZoomFactor();
        }
        this.repetitionTimer.start();
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        this.repetitionTimer.stop();
        this.yIncrement = 0.0;
        this.xIncrement = 0.0;
        this.graph = null;
        keyEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

