/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph;

import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxUndoManager;
import com.mxgraph.util.mxUndoableEdit;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import com.mxgraph.view.mxStylesheet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.scilab.modules.graph.ScilabComponent;
import org.scilab.modules.graph.utils.ScilabGraphMessages;
import org.scilab.modules.graph.view.ScilabGraphView;

public class ScilabGraph
extends mxGraph {
    private ScilabComponent component;
    private final mxUndoManager undoManager = new mxUndoManager();
    private String title = null;
    private File savedFile;
    private boolean modified = false;
    private boolean readOnly;
    private transient mxRubberband rubberBand;
    private transient String graphTab;
    private transient String viewPortTab;
    private final mxEventSource.mxIEventListener changeTracker = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, mxEventObject mxEventObject2) {
            ScilabGraph.this.setModified(true);
        }
    };
    private final mxEventSource.mxIEventListener undoHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, mxEventObject mxEventObject2) {
            ScilabGraph.this.undoManager.undoableEditHappened((mxUndoableEdit)mxEventObject2.getProperty("edit"));
        }
    };
    private final mxEventSource.mxIEventListener selectionHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, mxEventObject mxEventObject2) {
            List list = ((mxUndoableEdit)mxEventObject2.getProperty("edit")).getChanges();
            ScilabGraph.this.getSelectionModel().setCells(ScilabGraph.this.getSelectionCellsForChanges(list));
        }
    };
    private final PropertyChangeListener cellLockBackgroundUpdater = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("cellsLocked")) {
                ScilabGraph.this.getAsComponent().getGraphControl().repaint();
            }
        }
    };

    public void removeUndoHandler() {
        this.getModel().removeListener(this.undoHandler, "undo");
    }

    public void registerUndoHandler() {
        this.getModel().addListener("undo", this.undoHandler);
    }

    public ScilabGraph() {
        this(null, null);
    }

    public ScilabGraph(mxIGraphModel mxIGraphModel2, mxStylesheet mxStylesheet2) {
        super(mxIGraphModel2, mxStylesheet2);
        mxGraphActions.getSelectNextAction().setEnabled(false);
        mxGraphActions.getSelectPreviousAction().setEnabled(false);
        mxGraphActions.getSelectChildAction().setEnabled(false);
        mxGraphActions.getSelectParentAction().setEnabled(false);
        this.registerUndoHandler();
        this.undoManager.addListener("undo", this.selectionHandler);
        this.undoManager.addListener("redo", this.selectionHandler);
        this.setComponent(new ScilabComponent(this));
        this.changeSupport.addPropertyChangeListener(this.cellLockBackgroundUpdater);
        this.getModel().addListener("change", this.changeTracker);
    }

    public File getSavedFile() {
        return this.savedFile;
    }

    public void setSavedFile(File file) {
        this.savedFile = file;
        if (file != null && file.getParentFile() != null) {
            this.getAsComponent().getCanvas().setImageBasePath(file.getParentFile().toURI().toASCIIString());
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        if (this.title == null) {
            Date date = Calendar.getInstance().getTime();
            String string = DateFormat.getTimeInstance().format(date);
            this.title = String.format(ScilabGraphMessages.UNTITLED, string);
        }
        return this.title;
    }

    public String getGraphTab() {
        return this.graphTab;
    }

    public void setGraphTab(String string) {
        this.graphTab = string;
    }

    public String getViewPortTab() {
        return this.viewPortTab;
    }

    public void setViewPortTab(String string) {
        this.viewPortTab = string;
    }

    public mxGraphComponent getAsComponent() {
        return this.component;
    }

    public void setComponent(ScilabComponent scilabComponent) {
        this.component = scilabComponent;
        this.rubberBand = scilabComponent != null ? new mxRubberband((mxGraphComponent)scilabComponent) : null;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        this.setCellsLocked(bl);
    }

    public boolean isReadonly() {
        return this.readOnly;
    }

    public mxRubberband getRubberBand() {
        return this.rubberBand;
    }

    public final mxUndoManager getUndoManager() {
        return this.undoManager;
    }

    protected mxGraphView createGraphView() {
        return new ScilabGraphView(this);
    }

    public static Object[] getSelectionCellsForChanges(List<mxUndoableEdit.mxUndoableChange> list, mxGraphModel mxGraphModel2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (mxUndoableEdit.mxUndoableChange mxUndoableChange2 : list) {
            mxGraphModel.mxVisibleChange mxVisibleChange2;
            if (mxUndoableChange2 instanceof mxGraphModel.mxChildChange) {
                arrayList.add(((mxGraphModel.mxChildChange)mxUndoableChange2).getChild());
                continue;
            }
            if (mxUndoableChange2 instanceof mxGraphModel.mxTerminalChange) {
                arrayList.add(((mxGraphModel.mxTerminalChange)mxUndoableChange2).getCell());
                continue;
            }
            if (mxUndoableChange2 instanceof mxGraphModel.mxValueChange) {
                arrayList.add(((mxGraphModel.mxValueChange)mxUndoableChange2).getCell());
                continue;
            }
            if (mxUndoableChange2 instanceof mxGraphModel.mxStyleChange) {
                arrayList.add(((mxGraphModel.mxStyleChange)mxUndoableChange2).getCell());
                continue;
            }
            if (mxUndoableChange2 instanceof mxGraphModel.mxGeometryChange) {
                arrayList.add(((mxGraphModel.mxGeometryChange)mxUndoableChange2).getCell());
                continue;
            }
            if (mxUndoableChange2 instanceof mxGraphModel.mxCollapseChange) {
                arrayList.add(((mxGraphModel.mxCollapseChange)mxUndoableChange2).getCell());
                continue;
            }
            if (!(mxUndoableChange2 instanceof mxGraphModel.mxVisibleChange) || !(mxVisibleChange2 = (mxGraphModel.mxVisibleChange)mxUndoableChange2).isVisible()) continue;
            arrayList.add(((mxGraphModel.mxVisibleChange)mxUndoableChange2).getCell());
        }
        return mxGraphModel.getTopmostCells((mxIGraphModel)mxGraphModel2, (Object[])arrayList.toArray());
    }
}

