/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.util.HashSet;
import javax.swing.event.EventListenerList;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabVariables;
import org.scilab.modules.types.ScilabVariablesEvent;
import org.scilab.modules.types.ScilabVariablesHandler;
import org.scilab.modules.types.ScilabVariablesListener;

public final class ScilabVariablesRefresh
implements ScilabVariablesHandler {
    private static final EventListenerList eventListeners = new EventListenerList();
    private static ScilabVariablesRefresh instance;
    private static int id;

    private ScilabVariablesRefresh() {
    }

    @Override
    public void handle(ScilabType scilabType) {
        Object[] objectArray = eventListeners.getListenerList();
        ScilabVariablesEvent scilabVariablesEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ScilabVariablesListener.class || !((ScilabVariablesListener)objectArray[i + 1]).getListenedVariables().contains(scilabType.getVarName())) continue;
            if (scilabVariablesEvent == null) {
                scilabVariablesEvent = new ScilabVariablesEvent(scilabType);
            }
            ((ScilabVariablesListener)objectArray[i + 1]).scilabVariableUpdated(scilabVariablesEvent);
        }
    }

    public static final int getScilabVariablesRefreshId() {
        if (instance == null) {
            instance = new ScilabVariablesRefresh();
            id = ScilabVariables.addScilabVariablesHandler(instance);
        }
        return id;
    }

    public static final String[] getAllListenedVariables() {
        Object[] objectArray = eventListeners.getListenerList();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ScilabVariablesListener.class) continue;
            hashSet.addAll(((ScilabVariablesListener)objectArray[i + 1]).getListenedVariables());
        }
        String[] stringArray = new String[hashSet.size() + 1];
        stringArray = hashSet.toArray(stringArray);
        stringArray[hashSet.size()] = null;
        return stringArray;
    }

    public static final void addScilabVariablesListener(ScilabVariablesListener scilabVariablesListener) {
        eventListeners.add(ScilabVariablesListener.class, scilabVariablesListener);
    }

    public static final void removeScilabVariablesListener(ScilabVariablesListener scilabVariablesListener) {
        eventListeners.remove(ScilabVariablesListener.class, scilabVariablesListener);
    }
}

