/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Set;
import java.util.function.Predicate;

public final class AnnotationUtil {
    private static final String THE_AST_IS_NULL = "the ast is null";
    private static final String OVERRIDE = "Override";
    private static final String FQ_OVERRIDE = "java.lang.Override";
    private static final Set<String> OVERRIDE_ANNOTATIONS = Set.of("Override", "java.lang.Override");

    private AnnotationUtil() {
        throw new UnsupportedOperationException("do not instantiate.");
    }

    public static boolean containsAnnotation(DetailAST ast, String annotation) {
        return AnnotationUtil.getAnnotation(ast, annotation) != null;
    }

    public static boolean containsAnnotation(DetailAST ast) {
        DetailAST holder = AnnotationUtil.getAnnotationHolder(ast);
        return holder != null && holder.findFirstToken(159) != null;
    }

    public static boolean containsAnnotation(DetailAST ast, Set<String> annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException("annotations cannot be null");
        }
        boolean result = false;
        if (!annotations.isEmpty()) {
            DetailAST firstMatchingAnnotation = AnnotationUtil.findFirstAnnotation(ast, annotationNode -> {
                String annotationFullIdent = AnnotationUtil.getAnnotationFullIdent(annotationNode);
                return annotations.contains(annotationFullIdent);
            });
            result = firstMatchingAnnotation != null;
        }
        return result;
    }

    private static String getAnnotationFullIdent(DetailAST annotationNode) {
        String annotationString;
        DetailAST identNode = annotationNode.findFirstToken(58);
        if (identNode == null) {
            DetailAST dotNode = annotationNode.findFirstToken(59);
            annotationString = FullIdent.createFullIdent(dotNode).getText();
        } else {
            annotationString = identNode.getText();
        }
        return annotationString;
    }

    public static boolean hasOverrideAnnotation(DetailAST ast) {
        return AnnotationUtil.containsAnnotation(ast, OVERRIDE_ANNOTATIONS);
    }

    public static DetailAST getAnnotationHolder(DetailAST ast) {
        if (ast == null) {
            throw new IllegalArgumentException(THE_AST_IS_NULL);
        }
        DetailAST annotationHolder = ast.getType() == 155 || ast.getType() == 16 ? ast.findFirstToken(158) : ast.findFirstToken(5);
        return annotationHolder;
    }

    public static DetailAST getAnnotation(DetailAST ast, String annotation) {
        if (ast == null) {
            throw new IllegalArgumentException(THE_AST_IS_NULL);
        }
        if (annotation == null) {
            throw new IllegalArgumentException("the annotation is null");
        }
        if (CommonUtil.isBlank(annotation)) {
            throw new IllegalArgumentException("the annotation is empty or spaces");
        }
        return AnnotationUtil.findFirstAnnotation(ast, annotationNode -> {
            DetailAST firstChild = annotationNode.findFirstToken(170);
            String name = FullIdent.createFullIdent(firstChild.getNextSibling()).getText();
            return annotation.equals(name);
        });
    }

    private static DetailAST findFirstAnnotation(DetailAST ast, Predicate<DetailAST> predicate) {
        DetailAST holder = AnnotationUtil.getAnnotationHolder(ast);
        DetailAST result = null;
        for (DetailAST child = holder.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 159 || !predicate.test(child)) continue;
            result = child;
            break;
        }
        return result;
    }
}

