/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.manager.MacroNotFoundException;
import org.apache.maven.doxia.module.xdoc.XdocParser;
import org.apache.maven.doxia.parser.AbstractParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

@Component(role=Parser.class, hint="xdocs-template")
public class XdocsTemplateParser
extends XdocParser {
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private final Map<String, Object> macroParameters = new HashMap<String, Object>();
    private String sourceContent;
    private String macroName;

    public void parse(Reader source, Sink sink, String reference) throws ParseException {
        try (StringWriter contentWriter = new StringWriter();){
            IOUtil.copy((Reader)source, (Writer)contentWriter);
            this.sourceContent = contentWriter.toString();
            super.parse((Reader)new StringReader(this.sourceContent), sink, reference);
        }
        catch (IOException ioException) {
            throw new ParseException("Error reading the input source", (Exception)ioException);
        }
        finally {
            this.sourceContent = null;
        }
    }

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws MacroExecutionException {
        String tagName = parser.getName();
        if (tagName.equals(DOCUMENT_TAG.toString())) {
            sink.body();
            sink.rawText(parser.getText());
        } else if (tagName.equals(MACRO_TAG.toString()) && !this.isSecondParsing()) {
            this.processMacroStart(parser);
            this.setIgnorableWhitespace(true);
        } else if (tagName.equals(PARAM.toString()) && !this.isSecondParsing()) {
            this.processParamStart(parser, sink);
        } else {
            sink.rawText(parser.getText());
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws MacroExecutionException {
        String tagName = parser.getName();
        if (tagName.equals(DOCUMENT_TAG.toString())) {
            sink.rawText(parser.getText());
            sink.body_();
        } else if (this.macroName != null && tagName.equals(MACRO_TAG.toString()) && !this.macroName.isEmpty() && !this.isSecondParsing()) {
            this.processMacroEnd(sink);
            this.setIgnorableWhitespace(false);
        } else if (!tagName.equals(PARAM.toString())) {
            sink.rawText(parser.getText());
        }
    }

    private void processMacroStart(XmlPullParser parser) throws MacroExecutionException {
        this.macroName = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
        if (this.macroName == null || this.macroName.isEmpty()) {
            String message = String.format(Locale.ROOT, "The '%s' attribute for the '%s' tag is required.", HTML.Attribute.NAME, MACRO_TAG);
            throw new MacroExecutionException(message);
        }
    }

    private void processParamStart(XmlPullParser parser, Sink sink) throws MacroExecutionException {
        if (this.macroName != null && !this.macroName.isEmpty()) {
            String paramName = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
            String paramValue = parser.getAttributeValue(null, HTML.Attribute.VALUE.toString());
            if (paramName == null || paramValue == null || paramName.isEmpty() || paramValue.isEmpty()) {
                String message = String.format(Locale.ROOT, "'%s' and '%s' attributes for the '%s' tag are required inside the '%s' tag.", HTML.Attribute.NAME, HTML.Attribute.VALUE, PARAM, MACRO_TAG);
                throw new MacroExecutionException(message);
            }
            this.macroParameters.put(paramName, paramValue);
        } else {
            sink.rawText(parser.getText());
        }
    }

    private void processMacroEnd(Sink sink) throws MacroExecutionException {
        MacroRequest request = new MacroRequest(this.sourceContent, (AbstractParser)new XdocsTemplateParser(), this.macroParameters, new File(TEMP_DIR));
        try {
            this.executeMacro(this.macroName, request, sink);
        }
        catch (MacroNotFoundException exception) {
            String message = String.format(Locale.ROOT, "Macro '%s' not found.", this.macroName);
            throw new MacroExecutionException(message, (Throwable)exception);
        }
        this.reinitializeMacroFields();
    }

    private void reinitializeMacroFields() {
        this.macroName = "";
        this.macroParameters.clear();
    }
}

