/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayDeque;
import java.util.Deque;

@FileStatefulCheck
public final class OneStatementPerLineCheck
extends AbstractCheck {
    public static final String MSG_KEY = "multiple.statements.line";
    private final Deque<Integer> countOfSemiInLambda = new ArrayDeque<Integer>();
    private int lastStatementEnd;
    private int forStatementEnd;
    private boolean inForHeader;
    private boolean isInLambda;
    private int lambdaStatementEnd;
    private int lastVariableResourceStatementEnd;
    private boolean treatTryResourcesAsStatement;

    public void setTreatTryResourcesAsStatement(boolean treatTryResourcesAsStatement) {
        this.treatTryResourcesAsStatement = treatTryResourcesAsStatement;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{45, 35, 37, 181};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.lastStatementEnd = 0;
        this.lastVariableResourceStatementEnd = 0;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 45: {
                this.checkIfSemicolonIsInDifferentLineThanPrevious(ast);
                break;
            }
            case 37: {
                this.forStatementEnd = ast.getLineNo();
                break;
            }
            case 181: {
                this.isInLambda = true;
                this.countOfSemiInLambda.push(0);
                break;
            }
            default: {
                this.inForHeader = true;
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 45: {
                this.lastStatementEnd = ast.getLineNo();
                this.forStatementEnd = 0;
                this.lambdaStatementEnd = 0;
                break;
            }
            case 37: {
                this.inForHeader = false;
                break;
            }
            case 181: {
                this.countOfSemiInLambda.pop();
                if (this.countOfSemiInLambda.isEmpty()) {
                    this.isInLambda = false;
                }
                this.lambdaStatementEnd = ast.getLineNo();
                break;
            }
        }
    }

    private void checkIfSemicolonIsInDifferentLineThanPrevious(DetailAST ast) {
        boolean isUnnecessarySemicolon;
        DetailAST currentStatement = ast;
        DetailAST previousSibling = ast.getPreviousSibling();
        boolean bl = isUnnecessarySemicolon = previousSibling == null || previousSibling.getType() == 177 || ast.getParent().getType() == 1;
        if (!isUnnecessarySemicolon) {
            currentStatement = ast.getPreviousSibling();
        }
        if (this.isInLambda) {
            this.checkLambda(ast, currentStatement);
        } else if (OneStatementPerLineCheck.isResource(ast.getParent())) {
            this.checkResourceVariable(ast);
        } else if (!this.inForHeader && OneStatementPerLineCheck.isOnTheSameLine(currentStatement, this.lastStatementEnd, this.forStatementEnd, this.lambdaStatementEnd)) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private void checkLambda(DetailAST ast, DetailAST currentStatement) {
        int countOfSemiInCurrentLambda = this.countOfSemiInLambda.pop();
        this.countOfSemiInLambda.push(++countOfSemiInCurrentLambda);
        if (!this.inForHeader && countOfSemiInCurrentLambda > 1 && OneStatementPerLineCheck.isOnTheSameLine(currentStatement, this.lastStatementEnd, this.forStatementEnd, this.lambdaStatementEnd)) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private static boolean isResource(DetailAST ast) {
        return ast.getType() == 177 || ast.getType() == 176;
    }

    private void checkResourceVariable(DetailAST currentStatement) {
        if (this.treatTryResourcesAsStatement) {
            DetailAST nextNode = currentStatement.getNextSibling();
            if (currentStatement.getPreviousSibling().findFirstToken(80) != null) {
                this.lastVariableResourceStatementEnd = currentStatement.getLineNo();
            }
            if (nextNode.findFirstToken(80) != null && nextNode.getLineNo() == this.lastVariableResourceStatementEnd) {
                this.log(currentStatement, MSG_KEY, new Object[0]);
            }
        }
    }

    private static boolean isOnTheSameLine(DetailAST ast, int lastStatementEnd, int forStatementEnd, int lambdaStatementEnd) {
        return lastStatementEnd == ast.getLineNo() && forStatementEnd != ast.getLineNo() && lambdaStatementEnd != ast.getLineNo();
    }
}

