/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.palette.view;

import java.awt.Component;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.toolbar.SwingScilabToolBar;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.ScilabMenuBar;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.toolbar.ScilabToolBar;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.palette.PaletteManager;
import org.scilab.modules.xcos.palette.PaletteSearchManager;
import org.scilab.modules.xcos.palette.actions.ClosePalettesAction;
import org.scilab.modules.xcos.palette.actions.LoadAsPalAction;
import org.scilab.modules.xcos.palette.actions.NavigationAction;
import org.scilab.modules.xcos.palette.actions.SearchAction;
import org.scilab.modules.xcos.palette.actions.ZoomAction;
import org.scilab.modules.xcos.palette.view.PaletteManagerPanel;
import org.scilab.modules.xcos.utils.XcosMessages;

public class PaletteManagerView
extends SwingScilabDockablePanel
implements SimpleTab {
    public static final String DEFAULT_WIN_UUID = "xcos-palette-default-window";
    public static final String DEFAULT_TAB_UUID = "org.scilab.modules.xcos.palette.model";
    private final PaletteManager controller;
    private PaletteManagerPanel panel;
    private PaletteSearchManager searchMgr = new PaletteSearchManager();

    private PaletteManagerView(PaletteManager paletteManager) {
        super(XcosMessages.PALETTE_BROWSER + " - " + Xcos.TRADENAME, DEFAULT_TAB_UUID);
        this.controller = paletteManager;
        this.setWindowIcon(Xcos.ICON.getImage());
        this.initComponents();
    }

    public static PaletteManagerView get() {
        return (PaletteManagerView)ScilabTabFactory.getInstance().getFromCache(DEFAULT_TAB_UUID);
    }

    public static void restore() {
        PaletteManagerView.restore(true);
    }

    public static void restore(boolean bl) {
        PaletteManagerView paletteManagerView = new PaletteManagerView(PaletteManager.getInstance());
        if (bl) {
            SwingScilabWindow swingScilabWindow = WindowsConfigurationManager.restoreWindow((String)DEFAULT_TAB_UUID);
            swingScilabWindow.addTab((SwingScilabPanel)paletteManagerView);
            swingScilabWindow.setVisible(true);
        }
        PaletteManager.getInstance().firePropertyChange("visible", false, true);
        ClosingOperationsManager.addDependencyWithRoot((SwingScilabDockablePanel)paletteManagerView);
        ClosingOperationsManager.registerClosingOperation((SwingScilabDockablePanel)paletteManagerView, (ClosingOperationsManager.ClosingOperation)new ClosingOperation());
        ScilabTabFactory.getInstance().addToCache((SwingScilabDockablePanel)paletteManagerView);
    }

    protected PaletteManager getController() {
        return this.controller;
    }

    public PaletteManagerPanel getPanel() {
        return this.panel;
    }

    public void setPanel(PaletteManagerPanel paletteManagerPanel) {
        this.panel = paletteManagerPanel;
    }

    private void initComponents() {
        this.panel = new PaletteManagerPanel(this.getController());
        this.setContentPane(this.panel);
        MenuBar menuBar = ScilabMenuBar.createMenuBar();
        Menu menu = ScilabMenu.createMenu();
        menu.setText(XcosMessages.PALETTES);
        menu.setMnemonic(80);
        menuBar.add(menu);
        menu.add(LoadAsPalAction.createMenu(null));
        menu.addSeparator();
        menu.add(ClosePalettesAction.createMenu(null));
        Menu menu2 = ScilabMenu.createMenu();
        menu2.setText(XcosMessages.VIEW);
        menu2.setMnemonic(86);
        menuBar.add(menu2);
        menu2.add(ZoomAction.createMenuZoomIn());
        menu2.addSeparator();
        menu2.add(ZoomAction.createMenuZoomOut());
        menu2.addSeparator();
        menu2.add(NavigationAction.createMenuPrev());
        menu2.addSeparator();
        menu2.add(NavigationAction.createMenuNext());
        this.setMenuBar(menuBar);
        ToolBar toolBar = ScilabToolBar.createToolBar();
        SwingScilabToolBar swingScilabToolBar = (SwingScilabToolBar)toolBar.getAsSimpleToolBar();
        swingScilabToolBar.add((Component)LoadAsPalAction.createButton(null));
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)NavigationAction.createButtonPrev());
        swingScilabToolBar.add((Component)NavigationAction.createButtonNext());
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)ZoomAction.createButtonZoomIn());
        swingScilabToolBar.add((Component)ZoomAction.createButtonZoomOut());
        ZoomAction.registerKeyAction(this.getPanel().getActionMap(), this.getPanel().getInputMap());
        ZoomAction.registerKeyAction(this.getTree().getActionMap(), this.getTree().getInputMap());
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)SearchAction.createSearchBar());
        this.setToolBar(toolBar);
        this.setInfoBar(ScilabTextBox.createTextBox());
        this.setCallback((CommonCallBack)new ClosePalettesAction(null));
        this.getTree().revalidate();
        this.getPanel().performStartUpLayout();
    }

    public JTree getTree() {
        return (JTree)((JScrollPane)this.panel.getLeftComponent()).getViewport().getView();
    }

    public static void updateTree() {
        if (PaletteManagerView.get() == null) {
            PaletteManagerView.restore();
        }
        JTree jTree = PaletteManagerView.get().getTree();
        TreePath treePath = jTree.getSelectionPath();
        boolean bl = jTree.isExpanded(treePath);
        if (treePath == null) {
            PaletteManagerView.updateWholeTree();
        } else {
            ((DefaultTreeModel)jTree.getModel()).reload((TreeNode)treePath.getLastPathComponent());
            jTree.setSelectionPath(treePath);
        }
        if (bl) {
            jTree.expandPath(treePath);
        }
    }

    public static void updateWholeTree() {
        if (PaletteManagerView.get() == null) {
            PaletteManagerView.restore();
        }
        JTree jTree = PaletteManagerView.get().getTree();
        TreePath treePath = jTree.getSelectionPath();
        ((DefaultTreeModel)jTree.getModel()).reload();
        jTree.setSelectionPath(treePath);
    }

    public void setInfo(String string) {
        this.getInfoBar().setText(string);
    }

    public PaletteSearchManager getSearchManager() {
        return this.searchMgr;
    }

    private static class ClosingOperation
    implements ClosingOperationsManager.ClosingOperation {
        public int canClose() {
            return 1;
        }

        public void destroy() {
            PaletteManager.getInstance().firePropertyChange("visible", true, false);
        }

        public String askForClosing(List<SwingScilabDockablePanel> list) {
            return null;
        }

        public void updateDependencies(List<SwingScilabDockablePanel> list, ListIterator<SwingScilabDockablePanel> listIterator) {
        }
    }
}

