/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.link;

import org.scilab.modules.xcos.link.BasicLink;
import org.scilab.modules.xcos.link.CommandControlLink;
import org.scilab.modules.xcos.link.ExplicitLink;
import org.scilab.modules.xcos.link.ImplicitLink;
import org.scilab.modules.xcos.port.BasicPort;
import org.scilab.modules.xcos.port.command.CommandPort;
import org.scilab.modules.xcos.port.control.ControlPort;
import org.scilab.modules.xcos.port.input.InputPort;
import org.scilab.modules.xcos.port.output.OutputPort;

public enum LinkPortMap {
    EX_INPUT(ExplicitLink.class, InputPort.class, false),
    IM_INPUT(ImplicitLink.class, InputPort.class, false),
    EX_OUTPUT(ExplicitLink.class, OutputPort.class, true),
    IM_OUTPUT(ImplicitLink.class, OutputPort.class, true),
    CONTROL(CommandControlLink.class, ControlPort.class, false),
    COMMAND(CommandControlLink.class, CommandPort.class, true);

    private final Class<? extends BasicLink> linkKlass;
    private final Class<? extends BasicPort> portKlass;
    private final boolean isStart;

    private LinkPortMap(Class<? extends BasicLink> clazz, Class<? extends BasicPort> clazz2, boolean bl) {
        this.linkKlass = clazz;
        this.portKlass = clazz2;
        this.isStart = bl;
    }

    public final Class<? extends BasicLink> getLinkKlass() {
        return this.linkKlass;
    }

    public final Class<? extends BasicPort> getPortKlass() {
        return this.portKlass;
    }

    public final boolean isStart() {
        return this.isStart;
    }

    public static LinkPortMap getLinkPortMap(int n, boolean bl) {
        LinkPortMap linkPortMap = null;
        if (n == 1 && !bl) {
            linkPortMap = EX_INPUT;
        } else if (n == 1 && bl) {
            linkPortMap = EX_OUTPUT;
        } else if (n == 2 && !bl) {
            linkPortMap = IM_INPUT;
        } else if (n == 2 && bl) {
            linkPortMap = IM_OUTPUT;
        } else if (n == -1 && !bl) {
            linkPortMap = CONTROL;
        } else if (n == -1 && bl) {
            linkPortMap = COMMAND;
        }
        return linkPortMap;
    }

    public static double isStart(BasicPort basicPort) {
        if (basicPort instanceof InputPort || basicPort instanceof ControlPort) {
            return 1.0;
        }
        return 0.0;
    }

    public static Class<? extends BasicLink> getLinkClass(int n) {
        return LinkPortMap.getLinkPortMap(n, false).getLinkKlass();
    }

    public static Class<? extends BasicPort> getPortClass(Class<? extends BasicLink> clazz, boolean bl) {
        for (LinkPortMap linkPortMap : LinkPortMap.values()) {
            if (linkPortMap.getLinkKlass() != clazz || linkPortMap.isStart() != bl) continue;
            return linkPortMap.getPortKlass();
        }
        return null;
    }
}

