/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.spec;

import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.scilab.modules.commons.ScilabCommons;
import org.scilab.modules.commons.xml.ScilabDocumentBuilderFactory;
import org.scilab.modules.commons.xml.ScilabTransformerFactory;
import org.scilab.modules.commons.xml.ScilabXMLUtilities;
import org.scilab.modules.commons.xml.ScilabXPathFactory;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.io.spec.ContentEntry;
import org.scilab.modules.xcos.io.spec.DictionaryEntry;
import org.scilab.modules.xcos.io.spec.Entry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XcosPackage {
    private static final String MIMETYPE = "mimetype";
    private static final String META_INF_MANIFEST_XML = "META-INF/manifest.xml";
    private static final String VERSION = "0.2";
    private static final String MIME = "application/x-scilab-xcos";
    private static final byte[] MIME_BYTES = "application/x-scilab-xcos".getBytes();
    private static final String INVALID_MIMETYPE = "Invalid mimetype";
    private static XPathExpression XPATH_VERSION;
    private final File file;
    private Document manifest;
    private final long time;
    private final Entry[] availableEntries = new Entry[]{new ContentEntry(), new DictionaryEntry()};
    private XcosDiagram content;
    private final ScilabList dictionary;

    public XcosPackage(File file) throws ParserConfigurationException {
        this.file = file;
        this.dictionary = new ScilabList();
        this.manifest = ScilabDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = this.manifest.createElementNS("urn:scilab:xcos:xmlns:manifest:0.1", "manifest:manifest");
        this.manifest.appendChild(element);
        this.time = ScilabCommons.getScilabVersionTimestamp();
    }

    private boolean hasInvalidManifest() {
        return this.manifest == null || this.manifest.getFirstChild() == null || !this.manifest.getFirstChild().hasChildNodes();
    }

    public void load() throws IOException, SAXException, ParserConfigurationException, TransformerException {
        if (this.hasInvalidManifest()) {
            this.checkHeader();
        }
        int n = this.availableEntries.length - 1;
        while (0 <= n) {
            Entry entry = this.availableEntries[n];
            try (FileInputStream fileInputStream = new FileInputStream(this.file);
                 ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);){
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    String string = zipEntry.getName();
                    if (!string.equals(entry.getFullPath())) continue;
                    entry.setup(this);
                    try {
                        entry.load(zipEntry, new EntryInputStream(zipInputStream), "UTF-8");
                    }
                    catch (CharConversionException charConversionException) {
                        try (ZipFile zipFile = new ZipFile(this.file);){
                            ZipEntry zipEntry2 = zipFile.getEntry(zipEntry.getName());
                            InputStream inputStream = zipFile.getInputStream(zipEntry2);
                            entry.load(zipEntry, inputStream, "ISO-8859-1");
                        }
                    }
                    if (0 > --n) continue;
                    entry = this.availableEntries[n];
                }
            }
        }
    }

    public void checkHeader() throws IOException, TransformerException {
        FileInputStream fileInputStream = new FileInputStream(this.file);
        try (ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Object object;
                String string = zipEntry.getName();
                if (MIMETYPE.equals(string)) {
                    if (zipEntry.getSize() != (long)MIME_BYTES.length) {
                        throw new IOException(INVALID_MIMETYPE);
                    }
                    object = new byte[MIME_BYTES.length];
                    zipInputStream.read((byte[])object);
                    if (Arrays.equals(MIME_BYTES, (byte[])object)) continue;
                    throw new IOException(INVALID_MIMETYPE);
                }
                if (!META_INF_MANIFEST_XML.equals(string)) continue;
                object = ScilabTransformerFactory.newInstance();
                Transformer transformer = ((TransformerFactory)object).newTransformer();
                StreamSource streamSource = new StreamSource(new EntryInputStream(zipInputStream));
                DOMResult dOMResult = new DOMResult();
                transformer.transform(streamSource, dOMResult);
                this.manifest = (Document)dOMResult.getNode();
            }
        }
        if (this.hasInvalidManifest()) {
            throw new IOException("META-INF/manifest.xml entry not found");
        }
    }

    public void store() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)fileOutputStream, Charset.forName("UTF-8"));){
            this.storeHeader(zipOutputStream);
            zipOutputStream.flush();
            for (Entry entry : this.availableEntries) {
                entry.setup(this);
                ZipEntry zipEntry = new ZipEntry(entry.getFullPath());
                zipEntry.setTime(this.getTime());
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.flush();
                entry.store(zipOutputStream);
                zipOutputStream.flush();
            }
            this.storeTrailer(zipOutputStream);
            zipOutputStream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void storeHeader(ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(MIMETYPE);
        zipEntry.setSize(MIME_BYTES.length);
        CRC32 cRC32 = new CRC32();
        cRC32.update(MIME_BYTES);
        zipEntry.setCrc(cRC32.getValue());
        zipEntry.setMethod(0);
        zipEntry.setTime(this.getTime());
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(MIME_BYTES);
        Element element = this.manifest.createElement("manifest:file-entry");
        element.setAttribute("manifest:media-type", MIME);
        element.setAttribute("manifest:version", VERSION);
        element.setAttribute("manifest:full-path", "/");
        this.manifest.getFirstChild().appendChild(element);
    }

    private void storeTrailer(ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(META_INF_MANIFEST_XML);
        zipEntry.setTime(this.getTime());
        zipOutputStream.putNextEntry(zipEntry);
        try {
            TransformerFactory transformerFactory = ScilabTransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
            ScilabXMLUtilities.removeEmptyLines((Node)this.manifest.getDocumentElement());
            DOMSource dOMSource = new DOMSource(this.manifest);
            StreamResult streamResult = new StreamResult(zipOutputStream);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException);
        }
    }

    public Document getManifest() {
        return this.manifest;
    }

    public void setContent(XcosDiagram xcosDiagram) {
        this.content = xcosDiagram;
        xcosDiagram.setSavedFile(this.file);
    }

    public XcosDiagram getContent() {
        return this.content;
    }

    public ScilabList getDictionary() {
        return this.dictionary;
    }

    public long getTime() {
        return this.time;
    }

    public String getPackageVersion() {
        if (XPATH_VERSION == null) {
            XPathFactory xPathFactory = ScilabXPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            try {
                XPATH_VERSION = xPath.compile("//manifest/file-entry[media-type='application/x-scilab-xcos']/@version");
            }
            catch (XPathExpressionException xPathExpressionException) {
                xPathExpressionException.printStackTrace();
            }
        }
        if (XPATH_VERSION != null) {
            try {
                return XPATH_VERSION.evaluate(this.manifest, XPathConstants.STRING).toString();
            }
            catch (XPathExpressionException xPathExpressionException) {
                xPathExpressionException.printStackTrace();
            }
        }
        return VERSION;
    }

    private static class EntryInputStream
    extends InputStream {
        private final ZipInputStream zin;

        public EntryInputStream(ZipInputStream zipInputStream) {
            this.zin = zipInputStream;
        }

        @Override
        public int available() throws IOException {
            return this.zin.available();
        }

        @Override
        public int read() throws IOException {
            return this.zin.read();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.zin.read(byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return this.zin.skip(l);
        }

        @Override
        public void close() throws IOException {
            this.zin.closeEntry();
        }
    }
}

