/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.explorer;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import org.scilab.modules.xcos.Controller;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfString;

public class BrowserTreeNodeData {
    private static final NumberFormat CURRENT_FORMAT = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private final long uid;
    private final Kind kind;
    private int refCount;

    public BrowserTreeNodeData() {
        this.uid = 0L;
        this.kind = Kind.DIAGRAM;
    }

    public BrowserTreeNodeData(long l, Kind kind) {
        this.uid = l;
        this.kind = kind;
        this.refCount = 0;
    }

    public long getId() {
        return this.uid;
    }

    public Kind getKind() {
        return this.kind;
    }

    public int decRefCount() {
        return --this.refCount;
    }

    public int incRefCount() {
        return ++this.refCount;
    }

    public void fillOrUpdateContent(HTMLDocument hTMLDocument) throws BadLocationException, IOException {
        Element element = hTMLDocument.getDefaultRootElement();
        Element element2 = element.getElement(element.getElementCount() - 1);
        if (this.uid == 0L) {
            hTMLDocument.setOuterHTML(element2, "<body />");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Controller controller = new Controller();
        switch (this.kind) {
            case ANNOTATION: {
                this.htmlAnnotation(stringBuilder, controller);
                break;
            }
            case BLOCK: {
                this.htmlBlock(stringBuilder, controller);
                break;
            }
            case DIAGRAM: {
                this.htmlDiagram(stringBuilder, controller);
                break;
            }
            case LINK: {
                this.htmlLink(stringBuilder, controller);
                break;
            }
        }
        hTMLDocument.setInnerHTML(element2, stringBuilder.toString());
    }

    private void htmlAnnotation(StringBuilder stringBuilder, Controller controller) {
        BrowserTreeNodeData.tag(stringBuilder, "h1", "Annotation");
        String[] stringArray = new String[1];
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.DESCRIPTION, stringArray);
        BrowserTreeNodeData.tag(stringBuilder, "code", stringArray[0]);
    }

    private void htmlBlock(StringBuilder stringBuilder, Controller controller) {
        String[] stringArray = new String[1];
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.STYLE, stringArray);
        VectorOfString vectorOfString = new VectorOfString();
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.EXPRS, vectorOfString);
        VectorOfDouble vectorOfDouble = new VectorOfDouble(4L);
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.GEOMETRY, vectorOfDouble);
        String[] stringArray2 = new String[]{""};
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.INTERFACE_FUNCTION, stringArray2);
        String[] stringArray3 = new String[]{""};
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.NAME, stringArray3);
        String[] stringArray4 = new String[]{""};
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.UID, stringArray4);
        BrowserTreeNodeData.tag(stringBuilder, "h1", "Block " + stringArray2[0] + " : " + stringArray3[0]);
        String[] stringArray5 = new String[1];
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.DESCRIPTION, stringArray5);
        BrowserTreeNodeData.tag(stringBuilder, "code", stringArray5[0]);
        long[] lArray = new long[]{0L};
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.LABEL, lArray);
        controller.getObjectProperty(lArray[0], Kind.ANNOTATION, ObjectProperties.DESCRIPTION, stringArray5);
        if (lArray[0] != 0L && stringArray5[0] != "") {
            BrowserTreeNodeData.tag(stringBuilder, "strong", "Label");
            BrowserTreeNodeData.tag(stringBuilder, "p", stringArray5[0]);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        BrowserTreeNodeData.tag(stringBuilder2, "caption", "Graphics");
        BrowserTreeNodeData.tag(stringBuilder2, "tr", BrowserTreeNodeData.tag("td", "orig").append((CharSequence)BrowserTreeNodeData.tag("td", BrowserTreeNodeData.escapeVector(',', vectorOfDouble.get(0), vectorOfDouble.get(1)))));
        BrowserTreeNodeData.tag(stringBuilder2, "tr", BrowserTreeNodeData.tag("td", "sz").append((CharSequence)BrowserTreeNodeData.tag("td", BrowserTreeNodeData.escapeVector(',', vectorOfDouble.get(2), vectorOfDouble.get(3)))));
        BrowserTreeNodeData.tag(stringBuilder2, "tr", BrowserTreeNodeData.tag("td", "exprs").append((CharSequence)BrowserTreeNodeData.tag("td", BrowserTreeNodeData.escapeVector(';', vectorOfString))));
        BrowserTreeNodeData.tag(stringBuilder2, "tr", BrowserTreeNodeData.tag("td", "id").append((CharSequence)BrowserTreeNodeData.tag("td", stringArray3[0])));
        BrowserTreeNodeData.tag(stringBuilder2, "tr", BrowserTreeNodeData.tag("td", "style").append((CharSequence)BrowserTreeNodeData.tag("td", stringArray[0])));
        BrowserTreeNodeData.tag(stringBuilder, "table", stringBuilder2);
        stringBuilder2 = new StringBuilder();
        BrowserTreeNodeData.tag(stringBuilder2, "caption", "Model");
        BrowserTreeNodeData.tag(stringBuilder2, "tr", BrowserTreeNodeData.tag("td", "UID").append((CharSequence)BrowserTreeNodeData.tag("td", stringArray4[0])));
        BrowserTreeNodeData.tag(stringBuilder, "table", stringBuilder2);
    }

    private void htmlDiagram(StringBuilder stringBuilder, Controller controller) {
        String[] stringArray = new String[]{""};
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.NAME, stringArray);
        String[] stringArray2 = new String[]{""};
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.VERSION_NUMBER, stringArray2);
        String[] stringArray3 = new String[]{""};
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.PATH, stringArray3);
        String[] stringArray4 = new String[]{""};
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.DIAGRAM_CONTEXT, stringArray4);
        BrowserTreeNodeData.tag(stringBuilder, "h1", "Diagram: " + stringArray[0]);
        StringBuilder stringBuilder2 = new StringBuilder();
        BrowserTreeNodeData.tag(stringBuilder2, "li", "Version: " + stringArray2[0]);
        BrowserTreeNodeData.tag(stringBuilder2, "li", "File: " + stringArray3[0]);
        BrowserTreeNodeData.tag(stringBuilder, "div", BrowserTreeNodeData.tag("ul", stringBuilder2));
        BrowserTreeNodeData.tag(stringBuilder, "div", BrowserTreeNodeData.tag("p", stringArray4[0]));
    }

    private void htmlLink(StringBuilder stringBuilder, Controller controller) {
        BrowserTreeNodeData.tag(stringBuilder, "h1", "Link");
        String[] stringArray = new String[1];
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.DESCRIPTION, stringArray);
        BrowserTreeNodeData.tag(stringBuilder, "code", stringArray[0]);
        long[] lArray = new long[]{0L};
        controller.getObjectProperty(this.uid, this.kind, ObjectProperties.LABEL, lArray);
        controller.getObjectProperty(lArray[0], Kind.ANNOTATION, ObjectProperties.DESCRIPTION, stringArray);
        if (lArray[0] != 0L && stringArray[0] != "") {
            BrowserTreeNodeData.tag(stringBuilder, "strong", "Label");
            BrowserTreeNodeData.tag(stringBuilder, "p", stringArray[0]);
        }
    }

    private static StringBuilder tag(StringBuilder stringBuilder, String string, CharSequence charSequence) {
        stringBuilder.append("<").append(string).append(">");
        stringBuilder.append(charSequence);
        stringBuilder.append("</").append(string).append(">");
        return stringBuilder;
    }

    private static StringBuilder tag(String string, CharSequence charSequence) {
        return BrowserTreeNodeData.tag(new StringBuilder(), string, charSequence);
    }

    private static CharSequence escapeVector(char c, double ... dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (dArray.length > 1) {
            stringBuilder.append('[');
        }
        for (int i = 0; i < dArray.length - 1; ++i) {
            stringBuilder.append(CURRENT_FORMAT.format(dArray[i]));
            stringBuilder.append(c);
        }
        if (dArray.length > 0) {
            stringBuilder.append(CURRENT_FORMAT.format(dArray[dArray.length - 1]));
        }
        if (dArray.length > 1) {
            stringBuilder.append(']');
        }
        return stringBuilder;
    }

    private static CharSequence escapeVector(char c, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 1) {
            stringBuilder.append('[');
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append('\"').append(stringArray[i]).append('\"');
            stringBuilder.append(c);
        }
        if (stringArray.length > 0) {
            stringBuilder.append('\"').append(stringArray[stringArray.length - 1]).append('\"');
        }
        if (stringArray.length > 1) {
            stringBuilder.append(']');
        }
        return stringBuilder;
    }

    private static CharSequence escapeVector(char c, VectorOfString vectorOfString) {
        int n = vectorOfString.size();
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 1) {
            stringBuilder.append('[');
        }
        for (int i = 0; i < n - 1; ++i) {
            stringBuilder.append('\"').append(vectorOfString.get(i)).append('\"');
            stringBuilder.append(c);
        }
        if (n > 0) {
            stringBuilder.append('\"').append(vectorOfString.get(n - 1)).append('\"');
        }
        if (n > 1) {
            stringBuilder.append(']');
        }
        return stringBuilder;
    }

    public String toString() {
        if (this.uid == 0L) {
            return "Root";
        }
        Object object = "";
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{""};
        JavaController javaController = new JavaController();
        switch (this.kind) {
            case ANNOTATION: {
                boolean bl = javaController.getObjectProperty(this.uid, this.kind, ObjectProperties.NAME, stringArray2);
                if (!bl || stringArray2[0].isEmpty()) {
                    return "Annotation : " + this.uid;
                }
                object = "Annotation " + stringArray2[0];
                break;
            }
            case BLOCK: {
                boolean bl = javaController.getObjectProperty(this.uid, this.kind, ObjectProperties.INTERFACE_FUNCTION, stringArray);
                if (!bl || stringArray[0].isEmpty()) {
                    return "Block : " + this.uid;
                }
                bl = javaController.getObjectProperty(this.uid, this.kind, ObjectProperties.NAME, stringArray2);
                if (!bl || stringArray2[0].isEmpty()) {
                    object = "Block " + stringArray[0];
                    break;
                }
                object = "Block " + stringArray[0] + " \"" + stringArray2[0] + "\"";
                break;
            }
            case DIAGRAM: {
                boolean bl = javaController.getObjectProperty(this.uid, this.kind, ObjectProperties.NAME, stringArray2);
                if (!bl || stringArray2[0].isEmpty()) {
                    return "Diagram : " + this.uid;
                }
                object = "Diagram " + stringArray2[0];
                break;
            }
            case LINK: {
                boolean bl = javaController.getObjectProperty(this.uid, this.kind, ObjectProperties.NAME, stringArray2);
                if (!bl || stringArray2[0].isEmpty()) {
                    return "Link : " + this.uid;
                }
                object = "Link " + stringArray2[0];
                break;
            }
            case PORT: {
                boolean bl = javaController.getObjectProperty(this.uid, this.kind, ObjectProperties.NAME, stringArray2);
                if (!bl || stringArray2[0].isEmpty()) {
                    return "Port : " + this.uid;
                }
                object = "Port " + stringArray2[0];
            }
        }
        object = (String)object + " : " + this.uid;
        return object;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.uid ^ this.uid >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowserTreeNodeData browserTreeNodeData = (BrowserTreeNodeData)object;
        return this.uid == browserTreeNodeData.uid;
    }
}

