/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.JButton;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.graph.ScilabComponent;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.xcos.actions.SimulationNotRunningAction;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class InitModelicaAction
extends SimulationNotRunningAction {
    public static final String NAME = XcosMessages.INIT_MODELICA;
    public static final String SMALL_ICON = "";
    public static final int MNEMONIC_KEY = 0;
    public static final int ACCELERATOR_KEY = 0;

    public InitModelicaAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static JButton createButton(ScilabGraph scilabGraph) {
        return InitModelicaAction.createButton((ScilabGraph)scilabGraph, InitModelicaAction.class);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return InitModelicaAction.createMenu((ScilabGraph)scilabGraph, InitModelicaAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent2) {
        XcosDiagram xcosDiagram = (XcosDiagram)this.getGraph(actionEvent2);
        ScilabComponent scilabComponent = (ScilabComponent)xcosDiagram.getAsComponent();
        if (scilabComponent.isEditing()) {
            return;
        }
        xcosDiagram.info(XcosMessages.INITIALIZING_MODELICA_COMPILER);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("scs_m = scicos_new(\"0x").append(Long.toHexString(xcosDiagram.getRootDiagram().getUID())).append("\"); ");
        stringBuilder.append("xcosConfigureModelica(scs_m); ");
        try {
            ScilabInterpreterManagement.asynchronousScilabExec(actionEvent -> xcosDiagram.info(SMALL_ICON), (String)stringBuilder.toString());
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            Logger.getLogger(InitModelicaAction.class.getName()).severe(actionEvent2.toString());
        }
    }
}

