/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos;

import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.scilab.modules.xcos.Controller;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.UpdateStatus;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.View;
import org.scilab.modules.xcos.explorer.BrowserTreeNodeData;

public class BrowserView
extends View {
    private final DefaultTreeModel model;

    public BrowserView() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new BrowserTreeNodeData(), true);
        this.model = new DefaultTreeModel(defaultMutableTreeNode);
        this.fillModel();
        this.model.reload();
    }

    private void fillModel() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        Controller controller = new Controller();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.model.getRoot();
        VectorOfScicosID vectorOfScicosID = controller.getAll(Kind.DIAGRAM);
        int n = vectorOfScicosID.size();
        for (int i = 0; i < n; ++i) {
            long l = vectorOfScicosID.get(i);
            controller.referenceObject(l);
            object = new DefaultMutableTreeNode(new BrowserTreeNodeData(l, Kind.DIAGRAM));
            defaultMutableTreeNode2.add((MutableTreeNode)object);
        }
        LinkedList<DefaultMutableTreeNode> linkedList = new LinkedList<DefaultMutableTreeNode>();
        for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
            linkedList.add(defaultMutableTreeNode);
        }
        VectorOfScicosID vectorOfScicosID2 = new VectorOfScicosID(256L);
        while (!linkedList.isEmpty()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)linkedList.pop();
            object = (BrowserTreeNodeData)defaultMutableTreeNode.getUserObject();
            controller.getObjectProperty(((BrowserTreeNodeData)object).getId(), ((BrowserTreeNodeData)object).getKind(), ObjectProperties.CHILDREN, vectorOfScicosID2);
            int n2 = vectorOfScicosID2.size();
            for (int i = 0; i < n2; ++i) {
                long l = vectorOfScicosID2.get(i);
                Kind kind = controller.getKind(l);
                controller.referenceObject(l);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BrowserTreeNodeData(l, kind));
                defaultMutableTreeNode.add(defaultMutableTreeNode3);
                if (kind != Kind.BLOCK) continue;
                linkedList.add(defaultMutableTreeNode3);
            }
        }
    }

    public DefaultTreeModel getModel() {
        return this.model;
    }

    @Override
    public void objectCreated(final long l, final Kind kind) {
        if (this.model == null) {
            return;
        }
        if (kind == Kind.PORT) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserView.this.objectCreatedOnEDT(l, kind);
            }
        });
        new Controller().referenceObject(l);
    }

    @Override
    public void objectReferenced(final long l, final Kind kind, final long l2) {
        if (this.model == null) {
            return;
        }
        if (kind == Kind.PORT) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserView.this.objectReferencedOnEDT(l, kind, l2);
            }
        });
    }

    @Override
    public void objectUnreferenced(final long l, final Kind kind, final long l2) {
        if (this.model == null) {
            return;
        }
        if (kind == Kind.PORT) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserView.this.objectUnreferencedOnEDT(l, kind, l2);
            }
        });
    }

    @Override
    public void objectDeleted(long l, Kind kind) {
    }

    @Override
    public void objectCloned(long l, long l2, Kind kind) {
    }

    @Override
    public void propertyUpdated(final long l, final Kind kind, final ObjectProperties objectProperties, final UpdateStatus updateStatus) {
        if (this.model == null) {
            return;
        }
        if (updateStatus != UpdateStatus.SUCCESS) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserView.this.propertyUpdatedOnEDT(l, kind, objectProperties, updateStatus);
            }
        });
    }

    public void objectCreatedOnEDT(long l, Kind kind) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.model.getRoot();
        int n = this.model.getChildCount(defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new BrowserTreeNodeData(l, kind), true);
        this.model.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
    }

    public void objectReferencedOnEDT(long l, Kind kind, long l2) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.lookupForUID(l);
        BrowserTreeNodeData browserTreeNodeData = (BrowserTreeNodeData)defaultMutableTreeNode.getUserObject();
        browserTreeNodeData.incRefCount();
    }

    public void objectUnreferencedOnEDT(long l, Kind kind, long l2) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.lookupForUID(l);
        if (defaultMutableTreeNode == null) {
            return;
        }
        BrowserTreeNodeData browserTreeNodeData = (BrowserTreeNodeData)defaultMutableTreeNode.getUserObject();
        if (browserTreeNodeData.decRefCount() < 1) {
            this.model.removeNodeFromParent(defaultMutableTreeNode);
            new Controller().deleteObject(l);
        }
    }

    public void propertyUpdatedOnEDT(long l, Kind kind, ObjectProperties objectProperties, UpdateStatus updateStatus) {
        if (objectProperties == ObjectProperties.PARENT_DIAGRAM || objectProperties == ObjectProperties.PARENT_BLOCK) {
            switch (kind) {
                case ANNOTATION: 
                case BLOCK: 
                case LINK: {
                    Controller controller = new Controller();
                    long[] lArray = new long[]{0L};
                    if (!controller.getObjectProperty(l, kind, objectProperties, lArray)) {
                        return;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = this.lookupForUID(lArray[0]);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = this.lookupForUID(l);
                    if (defaultMutableTreeNode2 == null || defaultMutableTreeNode2.getParent() == defaultMutableTreeNode) {
                        return;
                    }
                    this.model.removeNodeFromParent(defaultMutableTreeNode2);
                    int n = defaultMutableTreeNode.getChildCount();
                    this.model.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
                    break;
                }
            }
        }
    }

    public DefaultMutableTreeNode lookupForUID(long l) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.model.getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            BrowserTreeNodeData browserTreeNodeData = (BrowserTreeNodeData)defaultMutableTreeNode2.getUserObject();
            if (browserTreeNodeData.getId() != l) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }
}

