/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.bridge.filechooser.SwingScilabFileChooser;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.filechooser.ScilabFileChooser;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.actions.DefaultAction;
import org.scilab.modules.scinotes.utils.ConfigSciNotesManager;
import org.scilab.modules.scinotes.utils.SciNotesMessages;
import org.scilab.modules.scinotes.utils.SearchFile;

public class SearchWordInFilesAction
extends DefaultAction
implements WindowFocusListener {
    private static final long serialVersionUID = 1L;
    private static final int GAP = 5;
    private static final String FILTERNEWLINES = "filterNewlines";
    private static final String ESCAPE = "ESCAPE";
    private static final String ENABLED = "enabled";
    private static final Color ERRORCOLOR = Color.RED;
    private static Color NORMALCOLOR;
    private static boolean windowAlreadyExist;
    private static JFrame mainFrame;
    private static Object searcher;
    private static SearchWordInFilesAction current;
    private JButton buttonFind;
    private JButton buttonStop;
    private JButton buttonClose;
    private JButton cancelButton;
    private JButton chooseBaseDirButton;
    private JComboBox comboBaseDir;
    private JComboBox comboFilePattern;
    private JComboBox comboWordPattern;
    private JCheckBox checkRecursive;
    private JCheckBox checkWordCase;
    private JCheckBox checkFileCase;
    private JCheckBox checkRegular;
    private JCheckBox checkLineByLine;
    private JCheckBox checkWhole;
    private boolean comboBaseDirCanceled;
    private boolean comboFilePatternCanceled;
    private boolean comboWordPatternCanceled;
    private String lastWordPattern;
    private String lastFilePattern;
    private String lastBaseDir;
    protected boolean searchFiles;

    public SearchWordInFilesAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    @Override
    public void doAction() {
        current = this;
        this.openSearchWindow();
    }

    public static MenuItem createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        return SearchWordInFilesAction.createMenu(string, null, new SearchWordInFilesAction(string, sciNotes), keyStroke);
    }

    public static void closeWindow() {
        if (windowAlreadyExist) {
            SearchWordInFilesAction.stopSearch();
            SwingScilabWindow swingScilabWindow = current.getEditor().getSwingParentWindow();
            if (swingScilabWindow != null) {
                swingScilabWindow.removeWindowFocusListener((WindowFocusListener)current);
            }
            mainFrame.removeWindowFocusListener(current);
            mainFrame.dispose();
            windowAlreadyExist = false;
        }
    }

    public void startSearch() {
        if (SearchFile.isDone(searcher)) {
            this.buttonStop.setEnabled(true);
            this.buttonFind.setEnabled(false);
            String string = SearchWordInFilesAction.getBaseDir((String)this.comboBaseDir.getEditor().getItem());
            boolean bl = this.checkRecursive.isSelected();
            boolean bl2 = this.checkLineByLine.isSelected();
            String string2 = (String)this.comboFilePattern.getEditor().getItem();
            boolean bl3 = this.checkFileCase.isSelected();
            String string3 = null;
            if (!this.searchFiles) {
                string3 = (String)this.comboWordPattern.getEditor().getItem();
            }
            boolean bl4 = this.checkWordCase.isSelected();
            boolean bl5 = this.checkWhole.isSelected();
            boolean bl6 = this.checkRegular.isSelected();
            searcher = SearchFile.getSearchResultsWindow(this.buttonStop, this.getEditor(), string, bl, !bl2, string2, bl3, string3, bl4, bl5, bl6);
        }
    }

    public static void stopSearch() {
        if (searcher != null) {
            SearchFile.stopSearch(searcher);
            searcher = null;
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this.getEditor().getSwingParentWindow()) {
            mainFrame.setAlwaysOnTop(true);
        }
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        if (windowEvent.getOppositeWindow() != mainFrame && windowEvent.getOppositeWindow() != this.getEditor().getSwingParentWindow()) {
            mainFrame.setAlwaysOnTop(false);
        }
    }

    public void openSearchWindow() {
        if (windowAlreadyExist) {
            mainFrame.setVisible(true);
            return;
        }
        mainFrame = new JFrame();
        mainFrame.setAlwaysOnTop(true);
        mainFrame.setDefaultCloseOperation(0);
        mainFrame.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), ESCAPE);
        mainFrame.getRootPane().getActionMap().put(ESCAPE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWordInFilesAction.closeWindow();
            }
        });
        mainFrame.setTitle(SciNotesMessages.SEARCHINFILES);
        mainFrame.setIconImage(new ImageIcon(FindIconHelper.findIcon((String)"system-search", (String)"32x32")).getImage());
        this.getEditor().getSwingParentWindow().addWindowFocusListener((WindowFocusListener)this);
        mainFrame.addWindowFocusListener(this);
        windowAlreadyExist = true;
        JLabel jLabel = new JLabel(SciNotesMessages.BASEDIRECTORY);
        JLabel jLabel2 = new JLabel(SciNotesMessages.BASEDIREXP);
        this.comboBaseDir = new JComboBox();
        this.comboBaseDir.setEditable(true);
        this.chooseBaseDirButton = new JButton(SciNotesMessages.CHOOSEDIR);
        JPanel jPanel = new JPanel();
        JLabel jLabel3 = new JLabel(SciNotesMessages.FILEPATTERN + ":");
        JLabel jLabel4 = new JLabel(SciNotesMessages.FILEPATTERNEXP);
        this.comboFilePattern = new JComboBox();
        this.comboFilePattern.setEditable(true);
        ((JTextField)this.comboFilePattern.getEditor().getEditorComponent()).setColumns(32);
        JLabel jLabel5 = new JLabel(SciNotesMessages.WORDPATTERN + ":");
        this.comboWordPattern = new JComboBox();
        this.comboWordPattern.setEditable(true);
        this.comboWordPattern.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWordInFilesAction.this.updateCombos();
                SearchWordInFilesAction.this.startSearch();
            }
        });
        ((JTextField)this.comboWordPattern.getEditor().getEditorComponent()).setColumns(32);
        NORMALCOLOR = ((JTextField)this.comboWordPattern.getEditor().getEditorComponent()).getForeground();
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(SciNotesMessages.OPTIONS));
        this.checkWordCase = new JCheckBox(SciNotesMessages.WORDCASESENSITIVE);
        this.checkFileCase = new JCheckBox(SciNotesMessages.FILECASESENSITIVE);
        this.checkWhole = new JCheckBox(SciNotesMessages.WHOLE_WORD);
        this.checkRegular = new JCheckBox(SciNotesMessages.REGULAR_EXPRESSIONS);
        this.checkLineByLine = new JCheckBox(SciNotesMessages.FILELINEBYLINE);
        this.checkRecursive = new JCheckBox(SciNotesMessages.RECURSIVESEARCH);
        jPanel2.setLayout(new GridLayout(3, 2, 5, 5));
        jPanel2.add(this.checkWordCase);
        jPanel2.add(this.checkFileCase);
        jPanel2.add(this.checkWhole);
        jPanel2.add(this.checkRegular);
        jPanel2.add(this.checkLineByLine);
        jPanel2.add(this.checkRecursive);
        this.buttonFind = new JButton(SciNotesMessages.FIND_BUTTON);
        this.buttonStop = new JButton(SciNotesMessages.STOPBUTTON);
        this.buttonStop.setEnabled(false);
        this.buttonClose = new JButton(SciNotesMessages.CLOSE);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.setLayout(new GridLayout(1, 4, 5, 5));
        jPanel3.add(new JLabel());
        jPanel3.add(this.buttonFind);
        jPanel3.add(this.buttonStop);
        jPanel3.add(this.buttonClose);
        this.restoreConfiguration();
        if (this.searchFiles) {
            this.comboWordPattern.setEnabled(false);
            this.checkWordCase.setEnabled(false);
            this.checkWhole.setEnabled(false);
            this.checkRegular.setEnabled(false);
            this.checkLineByLine.setEnabled(false);
            jLabel5.setEnabled(false);
        }
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)this.comboBaseDir, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 256;
        jPanel.add((Component)this.chooseBaseDirButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        jPanel.add((Component)this.comboFilePattern, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)this.comboWordPattern, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel4.setLayout(new BoxLayout(jPanel4, 3));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        mainFrame.setContentPane(jPanel4);
        mainFrame.addWindowListener(new WindowListener(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SearchWordInFilesAction.closeWindow();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        this.checkWordCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigSciNotesManager.saveCaseSensitive(SearchWordInFilesAction.this.checkWordCase.isSelected());
            }
        });
        this.checkFileCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigSciNotesManager.saveFileCase(SearchWordInFilesAction.this.checkFileCase.isSelected());
            }
        });
        this.checkWhole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigSciNotesManager.saveWholeWord(SearchWordInFilesAction.this.checkWhole.isSelected());
            }
        });
        this.checkRecursive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigSciNotesManager.saveRecursive(SearchWordInFilesAction.this.checkRecursive.isSelected());
            }
        });
        this.checkRegular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigSciNotesManager.saveRegularExpression(SearchWordInFilesAction.this.checkRegular.isSelected());
            }
        });
        this.checkLineByLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigSciNotesManager.saveLineByLine(SearchWordInFilesAction.this.checkLineByLine.isSelected());
            }
        });
        this.chooseBaseDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingScilabFileChooser swingScilabFileChooser = (SwingScilabFileChooser)ScilabFileChooser.createFileChooser().getAsSimpleFileChooser();
                swingScilabFileChooser.setDialogTitle(SciNotesMessages.CHOOSEBASEDIR);
                swingScilabFileChooser.setFileSelectionMode(1);
                swingScilabFileChooser.setAcceptAllFileFilterUsed(false);
                if (swingScilabFileChooser.showOpenDialog((Component)((Object)SearchWordInFilesAction.this.getEditor())) == 0) {
                    File file = swingScilabFileChooser.getSelectedFile();
                    if (file == null || file.isFile()) {
                        file = swingScilabFileChooser.getCurrentDirectory();
                    }
                    SearchWordInFilesAction.this.comboBaseDir.getEditor().setItem(file.toString());
                    SearchWordInFilesAction.this.updateFindButtonStatus(true);
                }
            }
        });
        this.buttonFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWordInFilesAction.this.updateCombos();
                SearchWordInFilesAction.this.startSearch();
            }
        });
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWordInFilesAction.stopSearch();
            }
        });
        this.buttonStop.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (mainFrame.isVisible() && propertyChangeEvent.getPropertyName().equals("SearchFile.SearchDone")) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    SearchWordInFilesAction.this.buttonFind.setEnabled(bl);
                    SearchWordInFilesAction.this.buttonStop.setEnabled(!bl);
                } else if (propertyChangeEvent.getPropertyName().equals(SearchWordInFilesAction.ENABLED)) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    SearchWordInFilesAction.this.comboBaseDir.setEnabled(!bl);
                    SearchWordInFilesAction.this.comboFilePattern.setEnabled(!bl);
                    SearchWordInFilesAction.this.chooseBaseDirButton.setEnabled(!bl);
                }
            }
        });
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchWordInFilesAction.closeWindow();
            }
        });
        this.comboBaseDir.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SearchWordInFilesAction.this.updateFindButtonStatus(true);
            }
        });
        this.comboBaseDir.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                SearchWordInFilesAction.this.comboBaseDirCanceled = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.comboBaseDir.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    if (SearchWordInFilesAction.this.comboBaseDirCanceled) {
                        SearchWordInFilesAction.this.comboBaseDirCanceled = false;
                    } else {
                        SearchWordInFilesAction.closeWindow();
                    }
                }
                SearchWordInFilesAction.this.updateFindButtonStatus(true);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        this.comboFilePattern.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SearchWordInFilesAction.this.updateFindButtonStatus(false);
            }
        });
        this.comboFilePattern.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                SearchWordInFilesAction.this.comboFilePatternCanceled = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.comboFilePattern.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    if (SearchWordInFilesAction.this.comboFilePatternCanceled) {
                        SearchWordInFilesAction.this.comboFilePatternCanceled = false;
                    } else {
                        SearchWordInFilesAction.closeWindow();
                    }
                }
                SearchWordInFilesAction.this.updateFindButtonStatus(false);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        this.comboWordPattern.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                SearchWordInFilesAction.this.comboWordPatternCanceled = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.comboWordPattern.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    if (SearchWordInFilesAction.this.comboWordPatternCanceled) {
                        SearchWordInFilesAction.this.comboWordPatternCanceled = false;
                    } else {
                        SearchWordInFilesAction.closeWindow();
                    }
                }
                if (SearchWordInFilesAction.this.checkRegular.isSelected()) {
                    try {
                        Pattern.compile((String)SearchWordInFilesAction.this.comboWordPattern.getEditor().getItem());
                        ((JTextField)SearchWordInFilesAction.this.comboWordPattern.getEditor().getEditorComponent()).setForeground(NORMALCOLOR);
                        SearchWordInFilesAction.this.buttonFind.setEnabled(true);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        ((JTextField)SearchWordInFilesAction.this.comboWordPattern.getEditor().getEditorComponent()).setForeground(ERRORCOLOR);
                        SearchWordInFilesAction.this.buttonFind.setEnabled(false);
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        mainFrame.pack();
        mainFrame.setResizable(false);
        mainFrame.setLocationRelativeTo((Component)((Object)this.getEditor()));
        mainFrame.setVisible(true);
    }

    protected void updateFindButtonStatus(boolean bl) {
        File file;
        boolean bl2;
        String string = (String)this.comboBaseDir.getEditor().getItem();
        String string2 = (String)this.comboFilePattern.getEditor().getItem();
        boolean bl3 = bl2 = !bl;
        if (bl && !string.isEmpty() && (file = new File(string = SearchWordInFilesAction.getBaseDir(string))).exists() && file.isDirectory()) {
            bl2 = true;
        }
        if (bl2) {
            ((JTextField)this.comboBaseDir.getEditor().getEditorComponent()).setForeground(NORMALCOLOR);
            this.buttonFind.setEnabled(!string2.isEmpty());
        } else {
            ((JTextField)this.comboBaseDir.getEditor().getEditorComponent()).setForeground(ERRORCOLOR);
            this.buttonFind.setEnabled(false);
        }
    }

    private static String getBaseDir(String string) {
        if ((string = string.trim()) != null && !string.isEmpty()) {
            if (string.startsWith("~" + File.separator) || string.equals("~")) {
                return string.replaceFirst("~", ScilabConstants.USERHOME);
            }
            if (string.startsWith("SCI" + File.separator) || string.equals("SCI")) {
                try {
                    return string.replaceFirst("SCI", ScilabConstants.SCI.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    public void updateCombos() {
        this.lastBaseDir = SearchWordInFilesAction.updateRecent(this.comboBaseDir, this.lastBaseDir, "recentBaseDir", "baseDir");
        this.lastFilePattern = SearchWordInFilesAction.updateRecent(this.comboFilePattern, this.lastFilePattern, "recentFilePattern", "filePattern");
        this.lastWordPattern = SearchWordInFilesAction.updateRecent(this.comboWordPattern, this.lastWordPattern, "recentWordPattern", "wordPattern");
    }

    private void restoreConfiguration() {
        this.checkRegular.setSelected(ConfigSciNotesManager.getRegularExpression());
        this.checkWhole.setSelected(ConfigSciNotesManager.getWholeWord());
        this.checkWordCase.setSelected(ConfigSciNotesManager.getCaseSensitive());
        this.checkFileCase.setSelected(ConfigSciNotesManager.getFileCase());
        this.checkRecursive.setSelected(ConfigSciNotesManager.getRecursive());
        this.checkLineByLine.setSelected(ConfigSciNotesManager.getLineByLine());
        SearchWordInFilesAction.fillCombo(this.comboBaseDir, "recentBaseDir", "baseDir");
        SearchWordInFilesAction.fillCombo(this.comboFilePattern, "recentFilePattern", "filePattern");
        SearchWordInFilesAction.fillCombo(this.comboWordPattern, "recentWordPattern", "wordPattern");
    }

    private static void fillCombo(JComboBox jComboBox, String string, String string2) {
        jComboBox.removeAllItems();
        List<String> list = ConfigSciNotesManager.getRecent(string, string2);
        for (String string3 : list) {
            jComboBox.addItem(string3);
        }
    }

    private static String updateRecent(JComboBox jComboBox, String string, String string2, String string3) {
        List<String> list;
        String string4 = (String)jComboBox.getEditor().getItem();
        if (string4 != null && string4.length() != 0 && !string4.equals(string) && !(list = ConfigSciNotesManager.getRecent(string2, string3)).contains(string4)) {
            jComboBox.addItem(string4);
            jComboBox.setSelectedItem(string4);
            ConfigSciNotesManager.saveRecent(string4, string2, string3);
            string = string4;
        }
        return string;
    }
}

