/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.scilab.modules.gui.bridge.filechooser.SwingScilabFileChooser;
import org.scilab.modules.gui.bridge.menu.SwingScilabMenu;
import org.scilab.modules.gui.filechooser.ScilabFileChooser;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.actions.DefaultAction;
import org.scilab.modules.scinotes.utils.ConfigSciNotesManager;

public final class RegisterFavoriteDirsAction
extends DefaultAction {
    private static MenuItem addDir;
    private static MenuItem rmDir;

    public RegisterFavoriteDirsAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    public static void close() {
        addDir = null;
        rmDir = null;
    }

    public static Object createMenu(String string, final SciNotes sciNotes, KeyStroke keyStroke) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";\uff1b");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        final Menu menu = ScilabMenu.createMenu();
        ((SwingScilabMenu)menu.getAsSimpleMenu()).addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                RegisterFavoriteDirsAction.updateFavoriteDirsMenu(menu, sciNotes);
            }
        });
        menu.setText(string2);
        addDir = AddDirectoryAction.createMenu(menu, string3, sciNotes, null);
        rmDir = RmDirectoryAction.createMenu(menu, string4, sciNotes, null);
        RegisterFavoriteDirsAction.updateFavoriteDirsMenu(menu, sciNotes);
        return menu;
    }

    public static MenuItem createMenu(SciNotes sciNotes, String string) {
        return RegisterFavoriteDirsAction.createMenu(string, null, new DefaultAction("", sciNotes){

            @Override
            public void doAction() {
            }
        }, null);
    }

    public static void updateFavoriteDirsMenu(Menu menu, SciNotes sciNotes) {
        ((SwingScilabMenu)menu.getAsSimpleMenu()).removeAll();
        menu.add(addDir);
        menu.add(rmDir);
        List<File> list = ConfigSciNotesManager.getAllFavoriteDirs();
        if (list.size() != 0) {
            menu.addSeparator();
        }
        for (int i = 0; i < list.size(); ++i) {
            menu.add(RegisterFavoriteDirsAction.createMenu(sciNotes, list.get(i).getPath()));
        }
    }

    static class AddDirectoryAction
    extends DefaultAction {
        private Menu menu;

        public AddDirectoryAction(Menu menu, String string, SciNotes sciNotes) {
            super(string, sciNotes);
            this.menu = menu;
        }

        @Override
        public void doAction() {
            SwingScilabFileChooser swingScilabFileChooser = (SwingScilabFileChooser)ScilabFileChooser.createFileChooser().getAsSimpleFileChooser();
            swingScilabFileChooser.setDialogTitle(this.getCommand());
            swingScilabFileChooser.setFileSelectionMode(1);
            swingScilabFileChooser.setAcceptAllFileFilterUsed(false);
            if (swingScilabFileChooser.showOpenDialog((Component)((Object)this.getEditor())) == 0) {
                File file = swingScilabFileChooser.getSelectedFile();
                if (file == null || file.isFile()) {
                    file = swingScilabFileChooser.getCurrentDirectory();
                }
                ConfigSciNotesManager.saveFavoriteDirectory(file.getPath());
                RegisterFavoriteDirsAction.updateFavoriteDirsMenu(this.menu, this.getEditor());
            }
        }

        public static MenuItem createMenu(Menu menu, String string, SciNotes sciNotes, KeyStroke keyStroke) {
            return AddDirectoryAction.createMenu(string, null, new AddDirectoryAction(menu, string, sciNotes), keyStroke);
        }
    }

    static class RmDirectoryAction
    extends DefaultAction {
        private Menu menu;

        public RmDirectoryAction(Menu menu, String string, SciNotes sciNotes) {
            super(string, sciNotes);
            this.menu = menu;
        }

        @Override
        public void doAction() {
            ConfigSciNotesManager.rmLastFavoriteDirectory();
            RegisterFavoriteDirsAction.updateFavoriteDirsMenu(this.menu, this.getEditor());
        }

        public static MenuItem createMenu(Menu menu, String string, SciNotes sciNotes, KeyStroke keyStroke) {
            return RmDirectoryAction.createMenu(string, null, new RmDirectoryAction(menu, string, sciNotes), keyStroke);
        }
    }
}

