/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.actions.DefaultCheckAction;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public class EndOfLineAction
extends DefaultCheckAction {
    private static final String EOL_LINUX = "\n";
    private static final String EOL_MACOS = "\r";
    private static final String EOL_WINDOWS = "\r\n";
    private static final String LINE_SEPARATOR = "line.separator";
    private static JRadioButtonMenuItem[] radioEolTypes;
    private static final long serialVersionUID = 7147038540238271944L;
    private String eolMenuLabel = SciNotesMessages.EOL_AUT0;

    public EndOfLineAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
        this.eolMenuLabel = string;
    }

    public JRadioButtonMenuItem createRadioButtonMenuItem(SciNotes sciNotes) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.eolMenuLabel);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EndOfLineAction.this.doAction();
            }
        });
        return jRadioButtonMenuItem;
    }

    public static void close() {
        radioEolTypes = null;
    }

    @Override
    public void doAction() {
        ScilabDocument scilabDocument = (ScilabDocument)this.getEditor().getTextPane().getDocument();
        String string = System.getProperty(LINE_SEPARATOR);
        if (this.eolMenuLabel.compareToIgnoreCase(SciNotesMessages.EOL_AUT0) == 0) {
            string = System.getProperty(LINE_SEPARATOR);
        } else if (this.eolMenuLabel.compareToIgnoreCase(SciNotesMessages.EOL_LINUX) == 0) {
            string = EOL_LINUX;
        } else if (this.eolMenuLabel.compareToIgnoreCase(SciNotesMessages.EOL_MACOS) == 0) {
            string = EOL_MACOS;
        } else if (this.eolMenuLabel.compareToIgnoreCase(SciNotesMessages.EOL_WINDOWS) == 0) {
            string = EOL_WINDOWS;
        }
        if (scilabDocument.getEOL().compareTo(string) != 0) {
            scilabDocument.setEOL(string);
            scilabDocument.setContentModified(true);
            scilabDocument.getUndoManager().discardAllEdits();
            this.getEditor().updateTabTitle();
        }
    }

    public static Menu createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        String string2 = EOL_LINUX;
        String string3 = EOL_MACOS;
        String string4 = EOL_WINDOWS;
        String string5 = SciNotesMessages.EOL_LINUX;
        String string6 = System.getProperty(LINE_SEPARATOR);
        if (string6.compareTo(string2) == 0) {
            string5 = SciNotesMessages.EOL_LINUX;
        }
        if (string6.compareTo(string4) == 0) {
            string5 = SciNotesMessages.EOL_WINDOWS;
        }
        if (string6.compareTo(string3) == 0) {
            string5 = SciNotesMessages.EOL_MACOS;
        }
        Menu menu = ScilabMenu.createMenu();
        menu.setText(string);
        radioEolTypes = new JRadioButtonMenuItem[3];
        ButtonGroup buttonGroup = new ButtonGroup();
        EndOfLineAction.radioEolTypes[0] = new EndOfLineAction(SciNotesMessages.EOL_LINUX, sciNotes).createRadioButtonMenuItem(sciNotes);
        buttonGroup.add(radioEolTypes[0]);
        ((JMenu)menu.getAsSimpleMenu()).add(radioEolTypes[0]);
        EndOfLineAction.radioEolTypes[1] = new EndOfLineAction(SciNotesMessages.EOL_WINDOWS, sciNotes).createRadioButtonMenuItem(sciNotes);
        buttonGroup.add(radioEolTypes[1]);
        ((JMenu)menu.getAsSimpleMenu()).add(radioEolTypes[1]);
        EndOfLineAction.radioEolTypes[2] = new EndOfLineAction(SciNotesMessages.EOL_MACOS, sciNotes).createRadioButtonMenuItem(sciNotes);
        buttonGroup.add(radioEolTypes[2]);
        ((JMenu)menu.getAsSimpleMenu()).add(radioEolTypes[2]);
        for (int i = 0; i < radioEolTypes.length; ++i) {
            if (radioEolTypes[i].getText().compareTo(string5) != 0) continue;
            radioEolTypes[i].setSelected(true);
        }
        return menu;
    }

    public static void updateEolMenu(ScilabDocument scilabDocument) {
        String string = EOL_LINUX;
        String string2 = EOL_MACOS;
        String string3 = EOL_WINDOWS;
        String string4 = SciNotesMessages.EOL_LINUX;
        String string5 = scilabDocument.getEOL();
        if (string5.compareTo(string) == 0) {
            string4 = SciNotesMessages.EOL_LINUX;
        }
        if (string5.compareTo(string2) == 0) {
            string4 = SciNotesMessages.EOL_MACOS;
        }
        if (string5.compareTo(string3) == 0) {
            string4 = SciNotesMessages.EOL_WINDOWS;
        }
        for (int i = 0; i < radioEolTypes.length; ++i) {
            if (radioEolTypes[i].getText().compareTo(string4) != 0) continue;
            radioEolTypes[i].setSelected(true);
        }
    }
}

