/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.scilab.modules.scinotes.ScilabDocument;

public class TrailingWhiteManager {
    private static final String REGEXP_WHITES_AT_END = "[ \t]+$";
    private static final String REGEXP_WHITES_AT_EOL = "[ \t]+\n";
    private ScilabDocument doc;
    private Element elem;

    public TrailingWhiteManager(ScilabDocument scilabDocument) {
        this.doc = scilabDocument;
        this.elem = scilabDocument.getDefaultRootElement();
    }

    public int removeTrailingWhite(int n) {
        int n2 = this.elem.getElementIndex(n);
        Element element = this.elem.getElement(n2);
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset() - 1;
        try {
            String string = this.doc.getText(n3, n4 - n3);
            string = string.replaceFirst(REGEXP_WHITES_AT_END, "");
            this.doc.replace(n3, n4 - n3, string, null);
            return Math.min(n, n3 + string.length());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return n;
        }
    }

    public int[] removeTrailingWhite(int n, int n2) {
        int n3 = this.elem.getElementIndex(n);
        int n4 = this.elem.getElementIndex(n2);
        int n5 = this.elem.getElement(n3).getStartOffset();
        int n6 = this.elem.getElement(n4).getEndOffset() - 1;
        int[] nArray = new int[2];
        nArray[0] = n;
        try {
            String string = this.doc.getText(n5, n6 - n5);
            string = string.replaceAll(REGEXP_WHITES_AT_EOL, "\n");
            int n7 = string.length();
            string = string.replaceFirst(REGEXP_WHITES_AT_END, "");
            nArray[1] = n5 + string.length() - (n6 - n2 - (n7 -= string.length()) - 1);
            this.doc.replace(n5, n6 - n5, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
        return nArray;
    }
}

