/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.utils;

import org.scilab.modules.graphic_objects.PolylineData;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.renderer.CallRenderer;
import org.scilab.modules.renderer.utils.AxesHandler;

public class DatatipCommon {
    public static Integer getParentPolyline(Integer n) {
        Integer n2 = (Integer)GraphicController.getController().getProperty(n, 24);
        Integer n3 = (Integer)GraphicController.getController().getProperty(n2, 29);
        if (n3.equals(15)) {
            return n2;
        }
        return null;
    }

    public static double[] getTransformedPosition(Integer n, Integer[] integerArray) {
        Integer n2 = AxesHandler.clickedAxes(n, integerArray)[0];
        double[] dArray = new double[]{integerArray[0].doubleValue(), integerArray[1].doubleValue(), 0.0};
        return CallRenderer.get2dViewFromPixelCoordinates(n2, dArray);
    }

    public static double[] getTransformedPositionInViewScale(Integer n, Integer[] integerArray) {
        Integer n2 = AxesHandler.clickedAxes(n, integerArray)[0];
        double[] dArray = new double[]{integerArray[0].doubleValue(), integerArray[1].doubleValue(), 0.0};
        return CallRenderer.get2dViewFromPixelCoordinates(n2, dArray);
    }

    public static double[][] getPolylineDataMatrix(Integer n) {
        return DatatipCommon.getPolylineDataMatrix(n, false);
    }

    public static double[][] getPolylineDataMatrix(Integer n, boolean bl) {
        double[][] dArray;
        double[] dArray2 = (double[])PolylineData.getDataX((int)n);
        double[] dArray3 = (double[])PolylineData.getDataY((int)n);
        if (bl) {
            dArray = new double[dArray2.length][2];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = dArray2[i];
                dArray[i][1] = dArray3[i];
            }
        } else {
            double[] dArray4 = (double[])PolylineData.getDataZ((int)n);
            dArray = new double[dArray2.length][3];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = dArray2[i];
                dArray[i][1] = dArray3[i];
                dArray[i][2] = dArray4[i];
            }
        }
        return dArray;
    }

    public static class Segment {
        public int pointIndex;
        public double x0;
        public double y0;
        public double z0;
        public double x1;
        public double y1;
        public double z1;

        public Segment() {
        }

        public Segment(int n, double d, double d2, double d3, double d4, double d5, double d6) {
            this.pointIndex = n;
            this.x0 = d;
            this.x1 = d2;
            this.y0 = d3;
            this.y1 = d4;
            this.z0 = d5;
            this.z1 = d6;
        }

        public final double norm2() {
            return (this.x1 - this.x0) * (this.x1 - this.x0) + (this.y1 - this.y0) * (this.y1 - this.y0) + (this.z1 - this.z0) * (this.z1 - this.z0);
        }

        public final double norm() {
            return Math.sqrt(this.norm2());
        }
    }
}

