/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.text;

import java.awt.Dimension;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureManager;
import org.scilab.forge.scirenderer.tranformations.DegenerateMatrixException;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.textObject.Text;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.text.TextSpriteDrawer;
import org.scilab.modules.renderer.JoGLView.util.ScaleUtils;

public class TextManager {
    protected final Map<Integer, Texture> spriteMap = new ConcurrentHashMap<Integer, Texture>();
    protected final TextureManager textureManager;
    protected double[] FACTOR_UPDATE_INTERVAL = new double[]{0.99, 1.01};

    public TextManager(TextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public final void draw(DrawingTools drawingTools, ColorMap colorMap, Text text) throws SciRendererException {
        Texture texture = this.getTexture(colorMap, text);
        Dimension dimension = this.getSpriteDims(colorMap, text);
        Transformation transformation = drawingTools.getTransformationManager().getCanvasProjection();
        Integer n = text.getParentAxes();
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(n);
        if (axes != null) {
            Vector3d[] vector3dArray = this.computeTextBoxVectors(transformation, text, texture.getDataProvider().getTextureSize(), axes);
            double[] dArray = this.computeRatios(transformation, text, vector3dArray, texture.getDataProvider().getTextureSize(), dimension);
            if (text.getTextBoxMode() == 2 && dArray[0] != 1.0) {
                texture = this.updateSprite(colorMap, text, dArray[0], dArray[1]);
            }
            Vector3d[] vector3dArray2 = this.computeTextPosition(transformation, text, vector3dArray, texture.getDataProvider().getTextureSize());
            drawingTools.getTransformationManager().useWindowCoordinate();
            drawingTools.draw(texture, AnchorPosition.LOWER_LEFT, vector3dArray2[0], -180.0 * text.getFontAngle() / Math.PI);
            drawingTools.getTransformationManager().useSceneCoordinate();
            Vector3d[] vector3dArray3 = text.getTextBoxMode() == 2 ? this.computeProjTextBoxCorners(vector3dArray2[1], text.getFontAngle(), vector3dArray) : this.computeProjCorners(vector3dArray2[0], text.getFontAngle(), texture.getDataProvider().getTextureSize());
            Vector3d[] vector3dArray4 = this.computeCorners(transformation, vector3dArray3, axes);
            Double[] doubleArray = this.cornersToCoordinateArray(vector3dArray4);
            text.setCorners(doubleArray);
        }
    }

    protected Vector3d[] computeTextBoxVectors(Transformation transformation, Text text, Dimension dimension, Axes axes) {
        Double[] doubleArray = text.getTextBox();
        Vector3d[] vector3dArray = new Vector3d[2];
        double[][] dArray = axes.getScaleTranslateFactors();
        Double[] doubleArray2 = text.getPosition();
        Vector3d vector3d = new Vector3d(doubleArray2);
        boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
        vector3d = ScaleUtils.applyLogScale(vector3d, blArray);
        vector3d = new Vector3d(vector3d.getX() * dArray[0][0] + dArray[1][0], vector3d.getY() * dArray[0][1] + dArray[1][1], vector3d.getZ() * dArray[0][2] + dArray[1][2]);
        Vector3d vector3d2 = transformation.project(vector3d);
        Vector3d vector3d3 = new Vector3d(dimension.getWidth(), 0.0, 0.0);
        Vector3d vector3d4 = new Vector3d(0.0, dimension.getHeight(), 0.0);
        Vector3d vector3d5 = vector3d2.plus(vector3d3);
        Vector3d vector3d6 = vector3d2.plus(vector3d4);
        Vector3d vector3d7 = transformation.unproject(vector3d5);
        Vector3d vector3d8 = transformation.unproject(vector3d6);
        vector3d7 = ScaleUtils.applyInverseLogScale(vector3d7, blArray);
        vector3d8 = ScaleUtils.applyInverseLogScale(vector3d8, blArray);
        vector3d7 = vector3d7.minus(vector3d);
        vector3d8 = vector3d8.minus(vector3d);
        if (text.getTextBoxMode() >= 1) {
            vector3d7 = vector3d7.getNormalized().times(doubleArray[0] * dArray[0][0]);
            vector3d8 = vector3d8.getNormalized().times(doubleArray[1] * dArray[0][1]);
        }
        if (axes.getXAxisReverse().booleanValue()) {
            vector3d7 = vector3d7.setX(Math.abs(vector3d7.getX()));
            vector3d8 = vector3d8.setX(Math.abs(vector3d8.getX()));
        }
        if (axes.getYAxisReverse().booleanValue()) {
            vector3d7 = vector3d7.setY(Math.abs(vector3d7.getY()));
            vector3d8 = vector3d8.setY(Math.abs(vector3d8.getY()));
        }
        if (axes.getZAxisReverse().booleanValue()) {
            vector3d7 = vector3d7.setZ(Math.abs(vector3d7.getZ()));
            vector3d8 = vector3d8.setZ(Math.abs(vector3d8.getZ()));
        }
        vector3d7 = vector3d7.plus(vector3d);
        vector3d8 = vector3d8.plus(vector3d);
        vector3d7 = ScaleUtils.applyLogScale(vector3d7, blArray);
        vector3d8 = ScaleUtils.applyLogScale(vector3d8, blArray);
        vector3d7 = vector3d7.minus(vector3d);
        vector3d8 = vector3d8.minus(vector3d);
        vector3d5 = transformation.projectDirection(vector3d7);
        vector3d6 = transformation.projectDirection(vector3d8);
        vector3d5 = vector3d5.setX(Math.abs(vector3d5.getX()));
        vector3d6 = vector3d6.setX(Math.abs(vector3d6.getX()));
        vector3d5 = vector3d5.setY(Math.abs(vector3d5.getY()));
        vector3d6 = vector3d6.setY(Math.abs(vector3d6.getY()));
        vector3dArray[0] = vector3d5;
        vector3dArray[1] = vector3d6;
        return vector3dArray;
    }

    protected double[] computeRatios(Transformation transformation, Text text, Vector3d[] vector3dArray, Dimension dimension, Dimension dimension2) {
        double[] dArray = new double[]{1.0, 1.0};
        if (text.getTextBoxMode() == 2) {
            Vector3d vector3d = vector3dArray[0];
            Vector3d vector3d2 = vector3dArray[1];
            double d = Math.min(Math.abs(vector3d.getX() / (double)dimension.width), Math.abs(vector3d2.getY() / (double)dimension.height));
            double d2 = Math.min(Math.abs(vector3d.getX() / (double)dimension2.width), Math.abs(vector3d2.getY() / (double)dimension2.height));
            dArray[0] = d;
            dArray[1] = d2;
        }
        return dArray;
    }

    protected Vector3d[] computeTextPosition(Transformation transformation, Text text, Vector3d[] vector3dArray, Dimension dimension) throws DegenerateMatrixException {
        Vector3d[] vector3dArray2 = new Vector3d[2];
        Integer n = text.getParentAxes();
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(n);
        double[][] dArray = axes.getScaleTranslateFactors();
        Double[] doubleArray = text.getPosition();
        Vector3d vector3d = new Vector3d(doubleArray);
        boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
        vector3d = ScaleUtils.applyLogScale(vector3d, blArray);
        vector3d = new Vector3d(vector3d.getX() * dArray[0][0] + dArray[1][0], vector3d.getY() * dArray[0][1] + dArray[1][1], vector3d.getZ() * dArray[0][2] + dArray[1][2]);
        vector3d = transformation.project(vector3d);
        vector3dArray2[0] = new Vector3d(vector3d);
        vector3dArray2[1] = new Vector3d(vector3d);
        if (text.getTextBoxMode() >= 1) {
            Vector3d vector3d2 = new Vector3d(vector3dArray[0]);
            Vector3d vector3d3 = new Vector3d(vector3dArray[1]);
            double[] dArray2 = vector3d2.getData();
            double[] dArray3 = vector3d3.getData();
            if (axes.getXAxisReverse().booleanValue()) {
                dArray2[0] = -dArray2[0];
                dArray3[0] = -dArray3[0];
            }
            if (axes.getYAxisReverse().booleanValue()) {
                dArray2[1] = -dArray2[1];
                dArray3[1] = -dArray3[1];
            }
            if (axes.getZAxisReverse().booleanValue()) {
                dArray2[2] = -dArray2[2];
                dArray3[2] = -dArray3[2];
            }
            Vector3d vector3d4 = new Vector3d(dArray2);
            Vector3d vector3d5 = new Vector3d(dArray3);
            Vector3d[] vector3dArray3 = this.computeProjCorners(vector3d, text.getFontAngle(), dimension);
            Vector3d vector3d6 = vector3dArray3[1].minus(vector3dArray3[0]);
            Vector3d vector3d7 = vector3dArray3[2].minus(vector3dArray3[0]);
            vector3d4 = vector3d6.getNormalized().times(0.5 * vector3d4.getX());
            vector3d5 = vector3d7.getNormalized().times(0.5 * vector3d5.getY());
            vector3d2 = vector3d6.getNormalized().times(0.5 * vector3d2.getX());
            vector3d3 = vector3d7.getNormalized().times(0.5 * vector3d3.getY());
            vector3d6 = vector3d6.times(0.5);
            vector3d7 = vector3d7.times(0.5);
            vector3d = vector3d.plus(vector3d4);
            vector3d = vector3d.plus(vector3d5);
            Vector3d vector3d8 = vector3d.minus(vector3d2);
            vector3d8 = vector3d8.minus(vector3d3);
            vector3d = vector3d.minus(vector3d6);
            vector3dArray2[0] = vector3d = vector3d.minus(vector3d7);
            vector3dArray2[1] = vector3d8;
        }
        return vector3dArray2;
    }

    protected Vector3d[] computeProjCorners(Transformation transformation, Vector3d vector3d, double d, Dimension dimension) throws DegenerateMatrixException {
        vector3d = transformation.project(vector3d);
        return this.computeProjCorners(vector3d, d, dimension);
    }

    protected Vector3d[] computeProjTextBoxCorners(Vector3d vector3d, double d, Vector3d[] vector3dArray) throws DegenerateMatrixException {
        double d2 = vector3dArray[0].getNorm();
        double d3 = vector3dArray[1].getNorm();
        return this.computeProjCorners(vector3d, d, new Dimension((int)d2, (int)d3));
    }

    protected Vector3d[] computeProjCorners(Vector3d vector3d, double d, Dimension dimension) throws DegenerateMatrixException {
        Vector3d[] vector3dArray = new Vector3d[4];
        Transformation transformation = TransformationFactory.getRotationTransformation((double)(180.0 * d / Math.PI), (double)0.0, (double)0.0, (double)1.0);
        vector3dArray[0] = vector3d;
        Vector3d vector3d2 = new Vector3d((double)dimension.width, 0.0, 0.0);
        Vector3d vector3d3 = new Vector3d(0.0, (double)dimension.height, 0.0);
        vector3d2 = transformation.projectDirection(vector3d2);
        vector3d3 = transformation.projectDirection(vector3d3);
        vector3dArray[1] = vector3dArray[0].plus(vector3d2);
        vector3dArray[2] = vector3dArray[0].plus(vector3d3);
        vector3dArray[3] = vector3dArray[2].plus(vector3d2);
        return vector3dArray;
    }

    protected Vector3d[] computeCorners(Transformation transformation, Vector3d[] vector3dArray, Axes axes) {
        Vector3d[] vector3dArray2 = new Vector3d[4];
        boolean[] blArray = new boolean[]{axes.getXAxisLogFlag(), axes.getYAxisLogFlag(), axes.getZAxisLogFlag()};
        vector3dArray2[0] = transformation.unproject(vector3dArray[0]);
        vector3dArray2[1] = transformation.unproject(vector3dArray[1]);
        vector3dArray2[2] = transformation.unproject(vector3dArray[2]);
        vector3dArray2[3] = transformation.unproject(vector3dArray[3]);
        vector3dArray2[0] = ScaleUtils.applyInverseLogScale(vector3dArray2[0], blArray);
        vector3dArray2[1] = ScaleUtils.applyInverseLogScale(vector3dArray2[1], blArray);
        vector3dArray2[2] = ScaleUtils.applyInverseLogScale(vector3dArray2[2], blArray);
        vector3dArray2[3] = ScaleUtils.applyInverseLogScale(vector3dArray2[3], blArray);
        return vector3dArray2;
    }

    protected Double[] cornersToCoordinateArray(Vector3d[] vector3dArray) {
        Double[] doubleArray = new Double[]{vector3dArray[0].getX(), vector3dArray[0].getY(), vector3dArray[0].getZ(), vector3dArray[2].getX(), vector3dArray[2].getY(), vector3dArray[2].getZ(), vector3dArray[3].getX(), vector3dArray[3].getY(), vector3dArray[3].getZ(), vector3dArray[1].getX(), vector3dArray[1].getY(), vector3dArray[1].getZ()};
        return doubleArray;
    }

    public void update(Integer n, int n2) {
        if (80 != n2 && 230 != n2) {
            this.dispose(n);
        }
    }

    protected Texture getTexture(ColorMap colorMap, Text text) {
        Texture texture = this.spriteMap.get(text.getIdentifier());
        if (texture == null) {
            texture = text.getTextBoxMode() == 2 ? this.createSprite(colorMap, text, 1.0) : this.createSprite(colorMap, text);
            this.spriteMap.put(text.getIdentifier(), texture);
        }
        return texture;
    }

    protected Texture updateSprite(ColorMap colorMap, Text text, double d, double d2) {
        Texture texture = this.spriteMap.get(text.getIdentifier());
        if (d < this.FACTOR_UPDATE_INTERVAL[0] || d > this.FACTOR_UPDATE_INTERVAL[1]) {
            this.dispose(text.getIdentifier());
            texture = this.createSprite(colorMap, text, d2);
            this.spriteMap.put(text.getIdentifier(), texture);
        }
        return texture;
    }

    protected Dimension getSpriteDims(ColorMap colorMap, Text text) {
        TextSpriteDrawer textSpriteDrawer = text.getTextBoxMode() == 2 ? new TextSpriteDrawer(colorMap, text, 1.0) : new TextSpriteDrawer(colorMap, text);
        return textSpriteDrawer.getTextureSize();
    }

    protected Texture createSprite(ColorMap colorMap, Text text) {
        TextSpriteDrawer textSpriteDrawer = new TextSpriteDrawer(colorMap, text);
        Texture texture = this.textureManager.createTexture();
        texture.setMagnificationFilter(Texture.Filter.LINEAR);
        texture.setMinifyingFilter(Texture.Filter.LINEAR);
        texture.setDrawer((TextureDrawer)textSpriteDrawer);
        return texture;
    }

    protected Texture createSprite(ColorMap colorMap, Text text, double d) {
        TextSpriteDrawer textSpriteDrawer = new TextSpriteDrawer(colorMap, text, d);
        Texture texture = this.textureManager.createTexture();
        texture.setMagnificationFilter(Texture.Filter.LINEAR);
        texture.setMinifyingFilter(Texture.Filter.LINEAR);
        texture.setDrawer((TextureDrawer)textSpriteDrawer);
        return texture;
    }

    public void dispose(Integer n) {
        Texture texture = this.spriteMap.get(n);
        if (texture != null) {
            this.textureManager.dispose(texture);
            this.spriteMap.remove(n);
        }
    }

    public void disposeAll() {
        this.textureManager.dispose(this.spriteMap.values());
        this.spriteMap.clear();
    }

    public static void updateTextCorners(Text text) {
        Vector3d[] vector3dArray = null;
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(text.getParentFrameOrFigure());
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(text.getParentAxes());
        try {
            Transformation transformation = drawerVisitor.getAxesDrawer().getCurrentProjection(axes);
            Dimension dimension = drawerVisitor.getTextManager().getSpriteDims(drawerVisitor.getColorMap(), text);
            Vector3d[] vector3dArray2 = drawerVisitor.getTextManager().computeTextBoxVectors(transformation, text, dimension, axes);
            Vector3d[] vector3dArray3 = drawerVisitor.getTextManager().computeTextPosition(transformation, text, vector3dArray2, dimension);
            vector3dArray = text.getTextBoxMode() == 2 ? drawerVisitor.getTextManager().computeProjTextBoxCorners(vector3dArray3[1], text.getFontAngle(), vector3dArray2) : drawerVisitor.getTextManager().computeProjCorners(vector3dArray3[0], text.getFontAngle(), dimension);
            Vector3d[] vector3dArray4 = drawerVisitor.getTextManager().computeCorners(transformation, vector3dArray, axes);
            Double[] doubleArray = drawerVisitor.getTextManager().cornersToCoordinateArray(vector3dArray4);
            double[][] dArray = axes.getScaleTranslateFactors();
            doubleArray[0] = (doubleArray[0] - dArray[1][0]) / dArray[0][0];
            doubleArray[1] = (doubleArray[1] - dArray[1][1]) / dArray[0][1];
            doubleArray[2] = (doubleArray[2] - dArray[1][2]) / dArray[0][2];
            doubleArray[3] = (doubleArray[3] - dArray[1][0]) / dArray[0][0];
            doubleArray[4] = (doubleArray[4] - dArray[1][1]) / dArray[0][1];
            doubleArray[5] = (doubleArray[5] - dArray[1][2]) / dArray[0][2];
            doubleArray[6] = (doubleArray[6] - dArray[1][0]) / dArray[0][0];
            doubleArray[7] = (doubleArray[7] - dArray[1][1]) / dArray[0][1];
            doubleArray[8] = (doubleArray[8] - dArray[1][2]) / dArray[0][2];
            doubleArray[9] = (doubleArray[9] - dArray[1][0]) / dArray[0][0];
            doubleArray[10] = (doubleArray[10] - dArray[1][1]) / dArray[0][1];
            doubleArray[11] = (doubleArray[11] - dArray[1][2]) / dArray[0][2];
            text.setCorners(doubleArray);
        }
        catch (DegenerateMatrixException degenerateMatrixException) {
            degenerateMatrixException.printStackTrace();
        }
    }
}

