/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout.hierarchical.stage;

import com.mxgraph.layout.hierarchical.model.mxGraphAbstractHierarchyCell;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyEdge;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyModel;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyNode;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyRank;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.hierarchical.stage.mxHierarchicalLayoutStage;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxGraph;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class mxCoordinateAssignment
implements mxHierarchicalLayoutStage {
    protected mxHierarchicalLayout layout;
    protected double intraCellSpacing = 30.0;
    protected double interRankCellSpacing = 30.0;
    protected double parallelEdgeSpacing = 4.0;
    protected double vertexConnectionBuffer = 0.0;
    protected int maxIterations = 8;
    protected int prefHozEdgeSep = 5;
    protected int prefVertEdgeOff = 2;
    protected int minEdgeJetty = 12;
    protected int channelBuffer = 4;
    protected Map<mxGraphHierarchyEdge, double[]> jettyPositions = new HashMap<mxGraphHierarchyEdge, double[]>();
    protected int orientation = 1;
    protected double initialX;
    protected double limitX;
    protected double currentXDelta;
    protected int widestRank;
    protected double[] rankTopY;
    protected double[] rankBottomY;
    protected double widestRankValue;
    protected double[] rankWidths;
    protected double[] rankY;
    protected boolean fineTuning = true;
    protected boolean disableEdgeStyle = true;
    protected HierarchicalEdgeStyle edgeStyle = HierarchicalEdgeStyle.POLYLINE;
    protected mxGraphAbstractHierarchyCell[][] nextLayerConnectedCache;
    protected int groupPadding = 10;
    protected mxGraphAbstractHierarchyCell[][] previousLayerConnectedCache;
    private static Logger logger = Logger.getLogger("com.jgraph.layout.hierarchical.JGraphCoordinateAssignment");

    public mxCoordinateAssignment(mxHierarchicalLayout mxHierarchicalLayout2, double d, double d2, int n, double d3, double d4) {
        this.layout = mxHierarchicalLayout2;
        this.intraCellSpacing = d;
        this.interRankCellSpacing = d2;
        this.orientation = n;
        this.initialX = d3;
        this.parallelEdgeSpacing = d4;
        this.setLoggerLevel(Level.OFF);
    }

    public void printStatus() {
        mxGraphHierarchyModel mxGraphHierarchyModel2 = this.layout.getModel();
        System.out.println("======Coord assignment debug=======");
        for (int i = 0; i < mxGraphHierarchyModel2.ranks.size(); ++i) {
            System.out.print("Rank " + i + " : ");
            mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(i));
            for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : mxGraphHierarchyRank2) {
                System.out.print(mxGraphAbstractHierarchyCell2.getX(i) + "  ");
            }
            System.out.println();
        }
        System.out.println("====================================");
    }

    @Override
    public void execute(Object object) {
        mxGraphHierarchyModel mxGraphHierarchyModel2 = this.layout.getModel();
        this.currentXDelta = 0.0;
        this.initialCoords(this.layout.getGraph(), mxGraphHierarchyModel2);
        if (this.fineTuning) {
            this.minNode(mxGraphHierarchyModel2);
        }
        double d = 1.0E8;
        if (this.fineTuning) {
            for (int i = 0; i < this.maxIterations; ++i) {
                mxGraphHierarchyRank mxGraphHierarchyRank2;
                int n;
                if (i != 0) {
                    this.medianPos(i, mxGraphHierarchyModel2);
                    this.minNode(mxGraphHierarchyModel2);
                }
                if (this.currentXDelta < d) {
                    for (n = 0; n < mxGraphHierarchyModel2.ranks.size(); ++n) {
                        mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n));
                        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : mxGraphHierarchyRank2) {
                            mxGraphAbstractHierarchyCell2.setX(n, mxGraphAbstractHierarchyCell2.getGeneralPurposeVariable(n));
                        }
                    }
                    d = this.currentXDelta;
                } else {
                    for (n = 0; n < mxGraphHierarchyModel2.ranks.size(); ++n) {
                        mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n));
                        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : mxGraphHierarchyRank2) {
                            mxGraphAbstractHierarchyCell2.setGeneralPurposeVariable(n, (int)mxGraphAbstractHierarchyCell2.getX(n));
                        }
                    }
                }
                this.minPath(mxGraphHierarchyModel2);
                this.currentXDelta = 0.0;
            }
        }
        this.setCellLocations(this.layout.getGraph(), mxGraphHierarchyModel2);
    }

    private void minNode(mxGraphHierarchyModel mxGraphHierarchyModel2) {
        Object object;
        Object object2;
        int n;
        int n2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        mxGraphAbstractHierarchyCell[][] mxGraphAbstractHierarchyCellArrayArray = new mxGraphAbstractHierarchyCell[mxGraphHierarchyModel2.maxRank + 1][];
        for (n2 = 0; n2 <= mxGraphHierarchyModel2.maxRank; ++n2) {
            mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n2));
            mxGraphAbstractHierarchyCellArrayArray[n2] = mxGraphHierarchyRank2.toArray(new mxGraphAbstractHierarchyCell[mxGraphHierarchyRank2.size()]);
            n = 0;
            while (n < mxGraphAbstractHierarchyCellArrayArray[n2].length) {
                object2 = mxGraphAbstractHierarchyCellArrayArray[n2][n];
                object = new WeightedCellSorter((mxGraphAbstractHierarchyCell)object2, n2);
                ((WeightedCellSorter)object).rankIndex = n++;
                ((WeightedCellSorter)object).visited = true;
                linkedList.add(object);
                hashtable.put(object2, object);
            }
        }
        n2 = linkedList.size() * 10;
        n = 1;
        for (int i = 0; !linkedList.isEmpty() && i <= n2; ++i) {
            object2 = (WeightedCellSorter)linkedList.getFirst();
            object = ((WeightedCellSorter)object2).cell;
            int n3 = ((WeightedCellSorter)object2).weightedValue;
            int n4 = ((WeightedCellSorter)object2).rankIndex;
            Object[] objectArray = ((mxGraphAbstractHierarchyCell)object).getNextLayerConnectedCells(n3).toArray();
            Object[] objectArray2 = ((mxGraphAbstractHierarchyCell)object).getPreviousLayerConnectedCells(n3).toArray();
            int n5 = objectArray.length;
            int n6 = objectArray2.length;
            int n7 = this.medianXValue(objectArray, n3 + 1);
            int n8 = this.medianXValue(objectArray2, n3 - 1);
            int n9 = n5 + n6;
            int n10 = ((mxGraphAbstractHierarchyCell)object).getGeneralPurposeVariable(n3);
            double d = n10;
            if (n9 > 0) {
                d = (n7 * n5 + n8 * n6) / n9;
            }
            boolean bl = false;
            if (d < (double)(n10 - n)) {
                if (n4 == 0) {
                    ((mxGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, (int)d);
                    bl = true;
                } else {
                    mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 = mxGraphAbstractHierarchyCellArrayArray[n3][n4 - 1];
                    int n11 = mxGraphAbstractHierarchyCell2.getGeneralPurposeVariable(n3);
                    if ((double)(n11 = n11 + (int)mxGraphAbstractHierarchyCell2.width / 2 + (int)this.intraCellSpacing + (int)((mxGraphAbstractHierarchyCell)object).width / 2) < d) {
                        ((mxGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, (int)d);
                        bl = true;
                    } else if (n11 < ((mxGraphAbstractHierarchyCell)object).getGeneralPurposeVariable(n3) - n) {
                        ((mxGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, n11);
                        bl = true;
                    }
                }
            } else if (d > (double)(n10 + n)) {
                int n12 = mxGraphAbstractHierarchyCellArrayArray[n3].length;
                if (n4 == n12 - 1) {
                    ((mxGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, (int)d);
                    bl = true;
                } else {
                    mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3 = mxGraphAbstractHierarchyCellArrayArray[n3][n4 + 1];
                    int n13 = mxGraphAbstractHierarchyCell3.getGeneralPurposeVariable(n3);
                    if ((double)(n13 = n13 - (int)mxGraphAbstractHierarchyCell3.width / 2 - (int)this.intraCellSpacing - (int)((mxGraphAbstractHierarchyCell)object).width / 2) > d) {
                        ((mxGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, (int)d);
                        bl = true;
                    } else if (n13 > ((mxGraphAbstractHierarchyCell)object).getGeneralPurposeVariable(n3) + n) {
                        ((mxGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, n13);
                        bl = true;
                    }
                }
            }
            if (bl) {
                int n14;
                for (n14 = 0; n14 < objectArray.length; ++n14) {
                    mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell4 = (mxGraphAbstractHierarchyCell)objectArray[n14];
                    WeightedCellSorter weightedCellSorter = (WeightedCellSorter)hashtable.get(mxGraphAbstractHierarchyCell4);
                    if (weightedCellSorter == null || weightedCellSorter.visited) continue;
                    weightedCellSorter.visited = true;
                    linkedList.add(weightedCellSorter);
                }
                for (n14 = 0; n14 < objectArray2.length; ++n14) {
                    mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell5 = (mxGraphAbstractHierarchyCell)objectArray2[n14];
                    WeightedCellSorter weightedCellSorter = (WeightedCellSorter)hashtable.get(mxGraphAbstractHierarchyCell5);
                    if (weightedCellSorter == null || weightedCellSorter.visited) continue;
                    weightedCellSorter.visited = true;
                    linkedList.add(weightedCellSorter);
                }
            }
            linkedList.removeFirst();
            ((WeightedCellSorter)object2).visited = false;
        }
    }

    private void medianPos(int n, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        boolean bl;
        boolean bl2 = bl = n % 2 == 0;
        if (bl) {
            for (int i = mxGraphHierarchyModel2.maxRank; i > 0; --i) {
                this.rankMedianPosition(i - 1, mxGraphHierarchyModel2, i);
            }
        } else {
            for (int i = 0; i < mxGraphHierarchyModel2.maxRank - 1; ++i) {
                this.rankMedianPosition(i + 1, mxGraphHierarchyModel2, i);
            }
        }
    }

    protected void rankMedianPosition(int n, mxGraphHierarchyModel mxGraphHierarchyModel2, int n2) {
        List<mxGraphAbstractHierarchyCell> list;
        int n3;
        mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n));
        Object[] objectArray = mxGraphHierarchyRank2.toArray();
        Object[] objectArray2 = new WeightedCellSorter[objectArray.length];
        Hashtable<mxGraphAbstractHierarchyCell, Object> hashtable = new Hashtable<mxGraphAbstractHierarchyCell, Object>(objectArray.length);
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 = (mxGraphAbstractHierarchyCell)objectArray[n3];
            objectArray2[n3] = new WeightedCellSorter();
            ((WeightedCellSorter)objectArray2[n3]).cell = mxGraphAbstractHierarchyCell2;
            ((WeightedCellSorter)objectArray2[n3]).rankIndex = n3;
            hashtable.put(mxGraphAbstractHierarchyCell2, objectArray2[n3]);
            list = null;
            list = n2 < n ? mxGraphAbstractHierarchyCell2.getPreviousLayerConnectedCells(n) : mxGraphAbstractHierarchyCell2.getNextLayerConnectedCells(n);
            ((WeightedCellSorter)objectArray2[n3]).weightedValue = this.calculatedWeightedValue(mxGraphAbstractHierarchyCell2, list);
        }
        Arrays.sort(objectArray2);
        for (n3 = 0; n3 < objectArray2.length; ++n3) {
            int n4 = 0;
            list = ((WeightedCellSorter)objectArray2[n3]).cell;
            Object[] objectArray3 = null;
            int n5 = 0;
            objectArray3 = n2 < n ? ((mxGraphAbstractHierarchyCell)((Object)list)).getPreviousLayerConnectedCells(n).toArray() : ((mxGraphAbstractHierarchyCell)((Object)list)).getNextLayerConnectedCells(n).toArray();
            if (objectArray3 != null) {
                n4 = objectArray3.length;
                n5 = n4 > 0 ? this.medianXValue(objectArray3, n2) : ((mxGraphAbstractHierarchyCell)((Object)list)).getGeneralPurposeVariable(n);
            }
            double d = 0.0;
            double d2 = -1.0E8;
            int n6 = ((WeightedCellSorter)objectArray2[n3]).rankIndex - 1;
            while (n6 >= 0) {
                WeightedCellSorter weightedCellSorter = (WeightedCellSorter)hashtable.get(objectArray[n6]);
                if (weightedCellSorter == null) continue;
                mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3 = weightedCellSorter.cell;
                if (weightedCellSorter.visited) {
                    d2 = (double)mxGraphAbstractHierarchyCell3.getGeneralPurposeVariable(n) + mxGraphAbstractHierarchyCell3.width / 2.0 + this.intraCellSpacing + d + ((mxGraphAbstractHierarchyCell)((Object)list)).width / 2.0;
                    n6 = -1;
                    continue;
                }
                d += mxGraphAbstractHierarchyCell3.width + this.intraCellSpacing;
                --n6;
            }
            double d3 = 0.0;
            double d4 = 1.0E8;
            int n7 = ((WeightedCellSorter)objectArray2[n3]).rankIndex + 1;
            while (n7 < objectArray2.length) {
                WeightedCellSorter weightedCellSorter = (WeightedCellSorter)hashtable.get(objectArray[n7]);
                if (weightedCellSorter == null) continue;
                mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell4 = weightedCellSorter.cell;
                if (weightedCellSorter.visited) {
                    d4 = (double)mxGraphAbstractHierarchyCell4.getGeneralPurposeVariable(n) - mxGraphAbstractHierarchyCell4.width / 2.0 - this.intraCellSpacing - d3 - ((mxGraphAbstractHierarchyCell)((Object)list)).width / 2.0;
                    n7 = objectArray2.length;
                    continue;
                }
                d3 += mxGraphAbstractHierarchyCell4.width + this.intraCellSpacing;
                ++n7;
            }
            if ((double)n5 >= d2 && (double)n5 <= d4) {
                ((mxGraphAbstractHierarchyCell)((Object)list)).setGeneralPurposeVariable(n, n5);
            } else if ((double)n5 < d2) {
                ((mxGraphAbstractHierarchyCell)((Object)list)).setGeneralPurposeVariable(n, (int)d2);
                this.currentXDelta += d2 - (double)n5;
            } else if ((double)n5 > d4) {
                ((mxGraphAbstractHierarchyCell)((Object)list)).setGeneralPurposeVariable(n, (int)d4);
                this.currentXDelta += (double)n5 - d4;
            }
            ((WeightedCellSorter)objectArray2[n3]).visited = true;
        }
    }

    private int calculatedWeightedValue(mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2, Collection<mxGraphAbstractHierarchyCell> collection) {
        int n = 0;
        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3 : collection) {
            if (mxGraphAbstractHierarchyCell2.isVertex() && mxGraphAbstractHierarchyCell3.isVertex()) {
                ++n;
                continue;
            }
            if (mxGraphAbstractHierarchyCell2.isEdge() && mxGraphAbstractHierarchyCell3.isEdge()) {
                n += 8;
                continue;
            }
            n += 2;
        }
        return n;
    }

    private int medianXValue(Object[] objectArray, int n) {
        int n2;
        if (objectArray.length == 0) {
            return 0;
        }
        int[] nArray = new int[objectArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            nArray[n2] = ((mxGraphAbstractHierarchyCell)objectArray[n2]).getGeneralPurposeVariable(n);
        }
        Arrays.sort(nArray);
        if (objectArray.length % 2 == 1) {
            return nArray[objectArray.length / 2];
        }
        n2 = objectArray.length / 2;
        int n3 = nArray[n2 - 1];
        int n4 = nArray[n2];
        return (n3 + n4) / 2;
    }

    private void initialCoords(mxGraph mxGraph2, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        int n;
        this.calculateWidestRank(mxGraph2, mxGraphHierarchyModel2);
        for (n = this.widestRank; n >= 0; --n) {
            if (n >= mxGraphHierarchyModel2.maxRank) continue;
            this.rankCoordinates(n, mxGraph2, mxGraphHierarchyModel2);
        }
        for (n = this.widestRank + 1; n <= mxGraphHierarchyModel2.maxRank; ++n) {
            if (n <= 0) continue;
            this.rankCoordinates(n, mxGraph2, mxGraphHierarchyModel2);
        }
    }

    protected void rankCoordinates(int n, mxGraph mxGraph2, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n));
        double d = 0.0;
        double d2 = this.initialX + (this.widestRankValue - this.rankWidths[n]) / 2.0;
        boolean bl = false;
        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : mxGraphHierarchyRank2) {
            mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3;
            if (mxGraphAbstractHierarchyCell2.isVertex()) {
                mxGraphAbstractHierarchyCell3 = (mxGraphHierarchyNode)mxGraphAbstractHierarchyCell2;
                mxRectangle mxRectangle2 = this.layout.getVertexBounds(mxGraphAbstractHierarchyCell3.cell);
                if (mxRectangle2 != null) {
                    if (this.orientation == 1 || this.orientation == 5) {
                        mxGraphAbstractHierarchyCell2.width = mxRectangle2.getWidth();
                        mxGraphAbstractHierarchyCell2.height = mxRectangle2.getHeight();
                    } else {
                        mxGraphAbstractHierarchyCell2.width = mxRectangle2.getHeight();
                        mxGraphAbstractHierarchyCell2.height = mxRectangle2.getWidth();
                    }
                } else {
                    bl = true;
                }
                d = Math.max(d, mxGraphAbstractHierarchyCell2.height);
            } else if (mxGraphAbstractHierarchyCell2.isEdge()) {
                mxGraphAbstractHierarchyCell3 = (mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell2;
                int n2 = 1;
                if (((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).edges != null) {
                    n2 = ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).edges.size();
                } else {
                    logger.info("edge.edges is null");
                }
                mxGraphAbstractHierarchyCell2.width = (double)(n2 - 1) * this.parallelEdgeSpacing;
            }
            mxGraphAbstractHierarchyCell2.setX(n, d2 += mxGraphAbstractHierarchyCell2.width / 2.0);
            mxGraphAbstractHierarchyCell2.setGeneralPurposeVariable(n, (int)d2);
            d2 += mxGraphAbstractHierarchyCell2.width / 2.0;
            d2 += this.intraCellSpacing;
        }
        if (bl) {
            logger.info("At least one cell has no bounds");
        }
    }

    protected void calculateWidestRank(mxGraph mxGraph2, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        double d = -this.interRankCellSpacing;
        double d2 = 0.0;
        this.rankWidths = new double[mxGraphHierarchyModel2.maxRank + 1];
        this.rankY = new double[mxGraphHierarchyModel2.maxRank + 1];
        for (int i = mxGraphHierarchyModel2.maxRank; i >= 0; --i) {
            double d3 = 0.0;
            mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(i));
            double d4 = this.initialX;
            boolean bl = false;
            for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : mxGraphHierarchyRank2) {
                mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3;
                if (mxGraphAbstractHierarchyCell2.isVertex()) {
                    mxGraphAbstractHierarchyCell3 = (mxGraphHierarchyNode)mxGraphAbstractHierarchyCell2;
                    Object object = this.layout.getVertexBounds(mxGraphAbstractHierarchyCell3.cell);
                    if (object != null) {
                        if (this.orientation == 1 || this.orientation == 5) {
                            mxGraphAbstractHierarchyCell2.width = ((mxRectangle)object).getWidth();
                            mxGraphAbstractHierarchyCell2.height = ((mxRectangle)object).getHeight();
                        } else {
                            mxGraphAbstractHierarchyCell2.width = ((mxRectangle)object).getHeight();
                            mxGraphAbstractHierarchyCell2.height = ((mxRectangle)object).getWidth();
                        }
                    } else {
                        bl = true;
                    }
                    d3 = Math.max(d3, mxGraphAbstractHierarchyCell2.height);
                } else if (mxGraphAbstractHierarchyCell2.isEdge()) {
                    mxGraphAbstractHierarchyCell3 = (mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell2;
                    int n = 1;
                    if (((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).edges != null) {
                        n = ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).edges.size();
                    } else {
                        logger.info("edge.edges is null");
                    }
                    mxGraphAbstractHierarchyCell2.width = (double)(n - 1) * this.parallelEdgeSpacing;
                }
                mxGraphAbstractHierarchyCell2.setX(i, d4 += mxGraphAbstractHierarchyCell2.width / 2.0);
                mxGraphAbstractHierarchyCell2.setGeneralPurposeVariable(i, (int)d4);
                d4 += mxGraphAbstractHierarchyCell2.width / 2.0;
                d4 += this.intraCellSpacing;
                if (d4 > this.widestRankValue) {
                    this.widestRankValue = d4;
                    this.widestRank = i;
                }
                this.rankWidths[i] = d4;
            }
            if (bl) {
                logger.info("At least one cell has no bounds");
            }
            this.rankY[i] = d;
            double d5 = d3 / 2.0 + d2 / 2.0 + this.interRankCellSpacing;
            d2 = d3;
            d = this.orientation == 1 || this.orientation == 7 ? (d += d5) : (d -= d5);
            for (Object object : mxGraphHierarchyRank2) {
                ((mxGraphAbstractHierarchyCell)object).setY(i, d);
            }
        }
    }

    protected void minPath(mxGraphHierarchyModel mxGraphHierarchyModel2) {
        Map<Object, mxGraphHierarchyEdge> map = mxGraphHierarchyModel2.getEdgeMapper();
        for (mxGraphHierarchyEdge mxGraphHierarchyEdge2 : map.values()) {
            double d;
            int n;
            int n2;
            int n3;
            if (mxGraphHierarchyEdge2.maxRank <= mxGraphHierarchyEdge2.minRank + 2) continue;
            int n4 = mxGraphHierarchyEdge2.maxRank - mxGraphHierarchyEdge2.minRank - 1;
            int n5 = ((mxGraphAbstractHierarchyCell)mxGraphHierarchyEdge2).getGeneralPurposeVariable(mxGraphHierarchyEdge2.minRank + 1);
            boolean bl = true;
            int n6 = 0;
            for (n3 = mxGraphHierarchyEdge2.minRank + 2; n3 < mxGraphHierarchyEdge2.maxRank; ++n3) {
                n2 = ((mxGraphAbstractHierarchyCell)mxGraphHierarchyEdge2).getGeneralPurposeVariable(n3);
                if (n5 != n2) {
                    bl = false;
                    n5 = n2;
                    continue;
                }
                ++n6;
            }
            if (bl) continue;
            n3 = 0;
            n2 = 0;
            double[] dArray = new double[n4 - 1];
            double[] dArray2 = new double[n4 - 1];
            double d2 = mxGraphHierarchyEdge2.getX(mxGraphHierarchyEdge2.minRank + 1);
            for (n = mxGraphHierarchyEdge2.minRank + 1; n < mxGraphHierarchyEdge2.maxRank - 1; ++n) {
                d = mxGraphHierarchyEdge2.getX(n + 1);
                if (d2 == d) {
                    dArray[n - mxGraphHierarchyEdge2.minRank - 1] = d2;
                    ++n3;
                    continue;
                }
                if (this.repositionValid(mxGraphHierarchyModel2, mxGraphHierarchyEdge2, n + 1, d2)) {
                    dArray[n - mxGraphHierarchyEdge2.minRank - 1] = d2;
                    ++n3;
                    continue;
                }
                dArray[n - mxGraphHierarchyEdge2.minRank - 1] = d;
                d2 = d;
            }
            d2 = mxGraphHierarchyEdge2.getX(mxGraphHierarchyEdge2.maxRank - 1);
            for (n = mxGraphHierarchyEdge2.maxRank - 1; n > mxGraphHierarchyEdge2.minRank + 1; --n) {
                d = mxGraphHierarchyEdge2.getX(n - 1);
                if (d2 == d) {
                    dArray2[n - mxGraphHierarchyEdge2.minRank - 2] = d2;
                    ++n2;
                    continue;
                }
                if (this.repositionValid(mxGraphHierarchyModel2, mxGraphHierarchyEdge2, n - 1, d2)) {
                    dArray2[n - mxGraphHierarchyEdge2.minRank - 2] = d2;
                    ++n2;
                    continue;
                }
                dArray2[n - mxGraphHierarchyEdge2.minRank - 2] = mxGraphHierarchyEdge2.getX(n - 1);
                d2 = d;
            }
            if (n2 <= n6 && n3 <= n6) continue;
            if (n2 >= n3) {
                for (n = mxGraphHierarchyEdge2.maxRank - 2; n > mxGraphHierarchyEdge2.minRank; --n) {
                    mxGraphHierarchyEdge2.setX(n, (int)dArray2[n - mxGraphHierarchyEdge2.minRank - 1]);
                }
                continue;
            }
            if (n3 <= n2) continue;
            for (n = mxGraphHierarchyEdge2.minRank + 2; n < mxGraphHierarchyEdge2.maxRank; ++n) {
                mxGraphHierarchyEdge2.setX(n, (int)dArray[n - mxGraphHierarchyEdge2.minRank - 2]);
            }
        }
    }

    protected boolean repositionValid(mxGraphHierarchyModel mxGraphHierarchyModel2, mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2, int n, double d) {
        int n2;
        mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n));
        mxGraphAbstractHierarchyCell[] mxGraphAbstractHierarchyCellArray = mxGraphHierarchyRank2.toArray(new mxGraphAbstractHierarchyCell[mxGraphHierarchyRank2.size()]);
        int n3 = -1;
        for (n2 = 0; n2 < mxGraphAbstractHierarchyCellArray.length; ++n2) {
            if (mxGraphAbstractHierarchyCell2 != mxGraphAbstractHierarchyCellArray[n2]) continue;
            n3 = n2;
            break;
        }
        if (n3 < 0) {
            return false;
        }
        n2 = mxGraphAbstractHierarchyCell2.getGeneralPurposeVariable(n);
        if (d < (double)n2) {
            if (n3 == 0) {
                return true;
            }
            mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3 = mxGraphAbstractHierarchyCellArray[n3 - 1];
            int n4 = mxGraphAbstractHierarchyCell3.getGeneralPurposeVariable(n);
            return (double)(n4 = n4 + (int)mxGraphAbstractHierarchyCell3.width / 2 + (int)this.intraCellSpacing + (int)mxGraphAbstractHierarchyCell2.width / 2) <= d;
        }
        if (d > (double)n2) {
            if (n3 == mxGraphAbstractHierarchyCellArray.length - 1) {
                return true;
            }
            mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell4 = mxGraphAbstractHierarchyCellArray[n3 + 1];
            int n5 = mxGraphAbstractHierarchyCell4.getGeneralPurposeVariable(n);
            return (double)(n5 = n5 - (int)mxGraphAbstractHierarchyCell4.width / 2 - (int)this.intraCellSpacing - (int)mxGraphAbstractHierarchyCell2.width / 2) >= d;
        }
        return true;
    }

    protected void setCellLocations(mxGraph mxGraph2, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        this.rankTopY = new double[mxGraphHierarchyModel2.ranks.size()];
        this.rankBottomY = new double[mxGraphHierarchyModel2.ranks.size()];
        for (int i = 0; i < mxGraphHierarchyModel2.ranks.size(); ++i) {
            this.rankTopY[i] = Double.MAX_VALUE;
            this.rankBottomY[i] = 0.0;
        }
        HashSet<Object> hashSet = null;
        if (this.layout.isResizeParent()) {
            hashSet = new HashSet<Object>();
        }
        Map<Object, mxGraphHierarchyEdge> map = mxGraphHierarchyModel2.getEdgeMapper();
        Map<Object, mxGraphHierarchyNode> map2 = mxGraphHierarchyModel2.getVertexMapper();
        for (mxGraphHierarchyNode mxGraphAbstractHierarchyCell2 : map2.values()) {
            this.setVertexLocation(mxGraphAbstractHierarchyCell2);
            if (!this.layout.isResizeParent()) continue;
            hashSet.add(mxGraph2.getModel().getParent(mxGraphAbstractHierarchyCell2.cell));
        }
        if (this.layout.isResizeParent()) {
            this.adjustParents(hashSet);
        }
        if (this.edgeStyle == HierarchicalEdgeStyle.ORTHOGONAL || this.edgeStyle == HierarchicalEdgeStyle.POLYLINE) {
            this.localEdgeProcessing(mxGraphHierarchyModel2);
        }
        for (mxGraphHierarchyEdge mxGraphHierarchyEdge2 : map.values()) {
            this.setEdgePosition(mxGraphHierarchyEdge2);
        }
    }

    protected void adjustParents(Set<Object> set) {
        this.layout.arrangeGroups(mxUtils.sortCells(set, true).toArray(), this.groupPadding);
    }

    protected void localEdgeProcessing(mxGraphHierarchyModel mxGraphHierarchyModel2) {
        Map<Object, mxGraphHierarchyEdge> map = mxGraphHierarchyModel2.getEdgeMapper();
        if (map != null && this.jettyPositions.size() != map.size()) {
            this.jettyPositions = new HashMap<mxGraphHierarchyEdge, double[]>();
        }
        for (int i = 0; i < mxGraphHierarchyModel2.ranks.size(); ++i) {
            mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(i));
            for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : mxGraphHierarchyRank2) {
                if (!mxGraphAbstractHierarchyCell2.isVertex()) continue;
                mxGraphAbstractHierarchyCell[] mxGraphAbstractHierarchyCellArray = mxGraphAbstractHierarchyCell2.getPreviousLayerConnectedCells(i).toArray(new mxGraphAbstractHierarchyCell[mxGraphAbstractHierarchyCell2.getPreviousLayerConnectedCells(i).size()]);
                int n = i - 1;
                for (int j = 0; j < 2; ++j) {
                    if (n > -1 && n < mxGraphHierarchyModel2.ranks.size() && mxGraphAbstractHierarchyCellArray != null && mxGraphAbstractHierarchyCellArray.length > 0) {
                        Object[] objectArray = new WeightedCellSorter[mxGraphAbstractHierarchyCellArray.length];
                        for (int k = 0; k < mxGraphAbstractHierarchyCellArray.length; ++k) {
                            objectArray[k] = new WeightedCellSorter(mxGraphAbstractHierarchyCellArray[k], -((int)mxGraphAbstractHierarchyCellArray[k].getX(n)));
                        }
                        Arrays.sort(objectArray);
                        mxGraphHierarchyNode mxGraphHierarchyNode2 = (mxGraphHierarchyNode)mxGraphAbstractHierarchyCell2;
                        double d = mxGraphHierarchyNode2.x[0] - mxGraphHierarchyNode2.width / 2.0;
                        double d2 = d + mxGraphHierarchyNode2.width;
                        int n2 = 0;
                        int n3 = 0;
                        mxGraphHierarchyEdge[] mxGraphHierarchyEdgeArray = new mxGraphHierarchyEdge[objectArray.length];
                        for (int k = 0; k < objectArray.length; ++k) {
                            mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3 = ((WeightedCellSorter)objectArray[k]).cell;
                            if (mxGraphAbstractHierarchyCell3.isVertex()) {
                                Collection<mxGraphHierarchyEdge> collection = j == 0 ? ((mxGraphHierarchyNode)mxGraphAbstractHierarchyCell2).connectsAsSource : ((mxGraphHierarchyNode)mxGraphAbstractHierarchyCell2).connectsAsTarget;
                                for (mxGraphHierarchyEdge mxGraphHierarchyEdge2 : collection) {
                                    if (mxGraphHierarchyEdge2.source != mxGraphAbstractHierarchyCell3 && mxGraphHierarchyEdge2.target != mxGraphAbstractHierarchyCell3) continue;
                                    n2 += mxGraphHierarchyEdge2.edges.size();
                                    ++n3;
                                    mxGraphHierarchyEdgeArray[k] = mxGraphHierarchyEdge2;
                                }
                                continue;
                            }
                            n2 += ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).edges.size();
                            ++n3;
                            mxGraphHierarchyEdgeArray[k] = (mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3;
                        }
                        double d3 = (n2 + 1) * this.prefHozEdgeSep;
                        if (mxGraphAbstractHierarchyCell2.width > d3 + (double)(2 * this.prefHozEdgeSep)) {
                            d += (double)this.prefHozEdgeSep;
                            d2 -= (double)this.prefHozEdgeSep;
                        }
                        double d4 = d2 - d;
                        double d5 = d4 / (double)n2;
                        double d6 = d + d5 / 2.0;
                        double d7 = this.minEdgeJetty - this.prefVertEdgeOff;
                        double d8 = 0.0;
                        for (int k = 0; k < mxGraphHierarchyEdgeArray.length; ++k) {
                            int n4 = mxGraphHierarchyEdgeArray[k].edges.size();
                            double[] dArray = this.jettyPositions.get(mxGraphHierarchyEdgeArray[k]);
                            if (dArray == null || dArray.length != 4 * n4) {
                                dArray = new double[4 * n4];
                                this.jettyPositions.put(mxGraphHierarchyEdgeArray[k], dArray);
                            }
                            if ((float)k < (float)n2 / 2.0f) {
                                d7 += (double)this.prefVertEdgeOff;
                            } else if ((float)k > (float)n2 / 2.0f) {
                                d7 -= (double)this.prefVertEdgeOff;
                            }
                            for (int i2 = 0; i2 < n4; ++i2) {
                                dArray[i2 * 4 + j * 2] = d6;
                                d6 += d5;
                                dArray[i2 * 4 + j * 2 + 1] = d7;
                            }
                            d8 = Math.max(d8, d7);
                        }
                    }
                    mxGraphAbstractHierarchyCellArray = mxGraphAbstractHierarchyCell2.getNextLayerConnectedCells(i).toArray(new mxGraphAbstractHierarchyCell[mxGraphAbstractHierarchyCell2.getNextLayerConnectedCells(i).size()]);
                    n = i + 1;
                }
            }
        }
    }

    protected void setEdgePosition(mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2) {
        mxGraphHierarchyEdge mxGraphHierarchyEdge2 = (mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell2;
        double d = 0.0;
        if (mxGraphHierarchyEdge2.temp[0] != 101207) {
            Object object;
            int n = mxGraphHierarchyEdge2.maxRank;
            int n2 = mxGraphHierarchyEdge2.minRank;
            if (n == n2) {
                n = mxGraphHierarchyEdge2.source.maxRank;
                n2 = mxGraphHierarchyEdge2.target.minRank;
            }
            Iterator<Object> iterator = mxGraphHierarchyEdge2.edges.iterator();
            int n3 = 0;
            double[] dArray = this.jettyPositions.get(mxGraphHierarchyEdge2);
            Object object2 = object = mxGraphHierarchyEdge2.isReversed() ? mxGraphHierarchyEdge2.target.cell : mxGraphHierarchyEdge2.source.cell;
            while (iterator.hasNext()) {
                double d2;
                double d3;
                double d4;
                int n4;
                double d5;
                int n5;
                Object object3 = iterator.next();
                Object object4 = this.layout.getGraph().getView().getVisibleTerminal(object3, true);
                ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>(mxGraphHierarchyEdge2.x.length);
                boolean bl = mxGraphHierarchyEdge2.isReversed();
                if (object4 != object) {
                    boolean bl2 = bl = !bl;
                }
                if (dArray != null) {
                    n5 = bl ? 2 : 0;
                    double d6 = bl ? this.rankTopY[n2] : this.rankBottomY[n];
                    double d7 = dArray[n3 * 4 + 1 + n5];
                    if (bl) {
                        d7 = -d7;
                    }
                    d6 += d7;
                    d5 = dArray[n3 * 4 + n5];
                    if (this.orientation == 1 || this.orientation == 5) {
                        arrayList.add(new mxPoint(d5, d6));
                    } else {
                        arrayList.add(new mxPoint(d6, d5));
                    }
                }
                n5 = mxGraphHierarchyEdge2.x.length - 1;
                int n6 = -1;
                int n7 = -1;
                int n8 = mxGraphHierarchyEdge2.maxRank - 1;
                if (bl) {
                    n5 = 0;
                    n6 = mxGraphHierarchyEdge2.x.length;
                    n7 = 1;
                    n8 = mxGraphHierarchyEdge2.minRank + 1;
                }
                for (n4 = n5; mxGraphHierarchyEdge2.maxRank != mxGraphHierarchyEdge2.minRank && n4 != n6; n4 += n7) {
                    d5 = mxGraphHierarchyEdge2.x[n4] + d;
                    d4 = (this.rankTopY[n8] + this.rankBottomY[n8 + 1]) / 2.0;
                    d3 = (this.rankTopY[n8 - 1] + this.rankBottomY[n8]) / 2.0;
                    if (bl) {
                        d2 = d4;
                        d4 = d3;
                        d3 = d2;
                    }
                    if (this.orientation == 1 || this.orientation == 5) {
                        arrayList.add(new mxPoint(d5, d4));
                        arrayList.add(new mxPoint(d5, d3));
                    } else {
                        arrayList.add(new mxPoint(d4, d5));
                        arrayList.add(new mxPoint(d3, d5));
                    }
                    this.limitX = Math.max(this.limitX, d5);
                    n8 += n7;
                }
                if (dArray != null) {
                    n4 = bl ? 2 : 0;
                    d5 = bl ? this.rankBottomY[n] : this.rankTopY[n2];
                    d4 = dArray[n3 * 4 + 3 - n4];
                    if (bl) {
                        d4 = -d4;
                    }
                    d3 = d5 - d4;
                    d2 = dArray[n3 * 4 + 2 - n4];
                    if (this.orientation == 1 || this.orientation == 5) {
                        arrayList.add(new mxPoint(d2, d3));
                    } else {
                        arrayList.add(new mxPoint(d3, d2));
                    }
                }
                if (mxGraphHierarchyEdge2.isReversed()) {
                    this.processReversedEdge(mxGraphHierarchyEdge2, object3);
                }
                this.layout.setEdgePoints(object3, arrayList);
                d = d == 0.0 ? this.parallelEdgeSpacing : (d > 0.0 ? -d : -d + this.parallelEdgeSpacing);
                ++n3;
            }
            mxGraphHierarchyEdge2.temp[0] = 101207;
        }
    }

    protected void setVertexLocation(mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2) {
        mxGraphHierarchyNode mxGraphHierarchyNode2 = (mxGraphHierarchyNode)mxGraphAbstractHierarchyCell2;
        Object object = mxGraphHierarchyNode2.cell;
        double d = mxGraphHierarchyNode2.x[0] - mxGraphHierarchyNode2.width / 2.0;
        double d2 = mxGraphHierarchyNode2.y[0] - mxGraphHierarchyNode2.height / 2.0;
        this.rankTopY[mxGraphAbstractHierarchyCell2.minRank] = Math.min(this.rankTopY[mxGraphAbstractHierarchyCell2.minRank], d2);
        this.rankBottomY[mxGraphAbstractHierarchyCell2.minRank] = Math.max(this.rankBottomY[mxGraphAbstractHierarchyCell2.minRank], d2 + mxGraphHierarchyNode2.height);
        if (this.orientation == 1 || this.orientation == 5) {
            this.layout.setVertexLocation(object, d, d2);
        } else {
            this.layout.setVertexLocation(object, d2, d);
        }
        this.limitX = Math.max(this.limitX, d + mxGraphHierarchyNode2.width);
    }

    protected void processReversedEdge(mxGraphHierarchyEdge mxGraphHierarchyEdge2, Object object) {
    }

    public double getInterRankCellSpacing() {
        return this.interRankCellSpacing;
    }

    public void setInterRankCellSpacing(double d) {
        this.interRankCellSpacing = d;
    }

    public double getIntraCellSpacing() {
        return this.intraCellSpacing;
    }

    public void setIntraCellSpacing(double d) {
        this.intraCellSpacing = d;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public double getLimitX() {
        return this.limitX;
    }

    public void setLimitX(double d) {
        this.limitX = d;
    }

    public boolean isFineTuning() {
        return this.fineTuning;
    }

    public void setFineTuning(boolean bl) {
        this.fineTuning = bl;
    }

    public void setLoggerLevel(Level level) {
        try {
            logger.setLevel(level);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected class AreaSpatialCache
    extends Rectangle2D.Double {
        public Set<Object> cells = new HashSet<Object>();

        protected AreaSpatialCache() {
        }
    }

    protected class WeightedCellSorter
    implements Comparable<Object> {
        public int weightedValue = 0;
        public boolean nudge = false;
        public boolean visited = false;
        public int rankIndex;
        public mxGraphAbstractHierarchyCell cell = null;

        public WeightedCellSorter() {
            this(null, 0);
        }

        public WeightedCellSorter(mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2, int n) {
            this.cell = mxGraphAbstractHierarchyCell2;
            this.weightedValue = n;
        }

        @Override
        public int compareTo(Object object) {
            if (object instanceof WeightedCellSorter) {
                if (this.weightedValue > ((WeightedCellSorter)object).weightedValue) {
                    return -1;
                }
                if (this.weightedValue < ((WeightedCellSorter)object).weightedValue) {
                    return 1;
                }
            }
            return 0;
        }
    }

    static enum HierarchicalEdgeStyle {
        ORTHOGONAL,
        POLYLINE,
        STRAIGHT;

    }
}

