/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JEditorPane;
import javax.swing.text.View;

public class PrinterWriter
implements Printable {
    private boolean scaleWidthToFit = true;
    private int currentPage = -1;
    private double pageEndY;
    private double pageStartY;
    private JEditorPane pane;

    public PrinterWriter(JEditorPane jEditorPane) {
        this.pane = jEditorPane;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        double d = 1.0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.pane.setSize((int)pageFormat.getImageableWidth(), Integer.MAX_VALUE);
        this.pane.validate();
        View view = this.pane.getUI().getRootView(this.pane);
        if (this.scaleWidthToFit && this.pane.getMinimumSize().getWidth() > pageFormat.getImageableWidth()) {
            d = pageFormat.getImageableWidth() / this.pane.getMinimumSize().getWidth();
            graphics2D.scale(d, d);
        }
        graphics2D.setClip((int)(pageFormat.getImageableX() / d), (int)(pageFormat.getImageableY() / d), (int)(pageFormat.getImageableWidth() / d), (int)(pageFormat.getImageableHeight() / d));
        if (n > this.currentPage) {
            this.currentPage = n;
            this.pageStartY += this.pageEndY;
            this.pageEndY = graphics2D.getClipBounds().getHeight();
        }
        graphics2D.translate(graphics2D.getClipBounds().getX(), graphics2D.getClipBounds().getY());
        Rectangle rectangle = new Rectangle(0, (int)(-this.pageStartY), (int)this.pane.getMinimumSize().getWidth(), (int)this.pane.getPreferredSize().getHeight());
        if (this.printView(graphics2D, rectangle, view)) {
            return 0;
        }
        this.pageStartY = 0.0;
        this.pageEndY = 0.0;
        this.currentPage = -1;
        return 1;
    }

    private boolean printView(Graphics2D graphics2D, Shape shape, View view) {
        boolean bl = false;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (view.getViewCount() > 0 && !view.getElement().getName().equalsIgnoreCase("td")) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                View view2;
                Shape shape2 = view.getChildAllocation(i, shape);
                if (shape2 == null || !this.printView(graphics2D, shape2, view2 = view.getView(i))) continue;
                bl = true;
            }
        } else if (shape.getBounds().getMaxY() >= rectangle.getY()) {
            bl = true;
            if (shape.getBounds().getHeight() > rectangle.getHeight() && shape.intersects(rectangle)) {
                view.paint(graphics2D, shape);
            } else if (shape.getBounds().getY() >= rectangle.getY()) {
                if (shape.getBounds().getMaxY() <= rectangle.getMaxY()) {
                    view.paint(graphics2D, shape);
                } else if (shape.getBounds().getY() < this.pageEndY) {
                    this.pageEndY = shape.getBounds().getY();
                }
            }
        }
        return bl;
    }
}

