/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import org.scilab.modules.gui.messagebox.MessageBox;
import org.scilab.modules.gui.messagebox.ScilabMessageBox;
import org.scilab.modules.gui.utils.PrinterWriter;
import org.scilab.modules.localization.Messages;

public class PrinterHelper {
    protected PrinterHelper() {
    }

    public static boolean printString(String string, String string2) {
        String string3 = string2 + "\n\n" + string;
        return PrinterHelper.printString(string3);
    }

    public static boolean printString(String string) {
        JEditorPane jEditorPane = new JEditorPane("Text/html", string);
        jEditorPane.setEditable(false);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(new PrinterWriter(jEditorPane));
        try {
            printerJob.print();
        }
        catch (PrinterException printerException) {
            MessageBox messageBox = ScilabMessageBox.createMessageBox();
            messageBox.setMessage(Messages.gettext((String)"An error occurred: ") + printerException.getLocalizedMessage());
            messageBox.setModal(true);
            messageBox.setIcon("error");
            messageBox.displayAndWait();
            return false;
        }
        return true;
    }

    public static boolean printFile(String string) {
        JEditorPane jEditorPane = new JEditorPane();
        try {
            URL uRL = new URL("file:///" + string);
            jEditorPane.setEditable(false);
            jEditorPane.setContentType("text/plain;charset=UTF-8");
            try {
                jEditorPane.setPage(uRL);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return false;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(new PrinterWriter(jEditorPane));
        try {
            printerJob.print();
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
            return false;
        }
        return true;
    }
}

