/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.JMenuItem;
import javax.xml.parsers.ParserConfigurationException;
import org.scilab.modules.commons.gui.ScilabKeyStroke;
import org.scilab.modules.commons.xml.ScilabDocumentBuilderFactory;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.ScilabMenuBar;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.gui.utils.MenuBarConfiguration;
import org.scilab.modules.localization.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class MenuBarBuilder {
    private static final String FILE_NOT_FOUND = "Could not find file: ";
    private static final String CANNOT_CREATE_MENUBAR = "Cannot create MenuBar.\nCheck if file *_menubar.xml is available and valid.";
    private static int figureIndex;

    private MenuBarBuilder() {
        throw new UnsupportedOperationException();
    }

    public static Object buildMenuBar(Class[] classArray, String string) throws SAXException, IOException, ParserConfigurationException {
        MenuBarConfigurationHandler menuBarConfigurationHandler = new MenuBarConfigurationHandler(string);
        return Proxy.newProxyInstance(menuBarConfigurationHandler.getClass().getClassLoader(), classArray, (InvocationHandler)menuBarConfigurationHandler);
    }

    public static MenuBar buildMenuBar(String string) {
        return MenuBarBuilder.buildMenuBar(string, 0);
    }

    public static MenuBar buildMenuBar(String string, int n) {
        figureIndex = n;
        MenuBar menuBar = ScilabMenuBar.createMenuBar();
        try {
            MenuBarConfiguration menuBarConfiguration = (MenuBarConfiguration)MenuBarBuilder.buildMenuBar(new Class[]{MenuBarConfiguration.class}, string);
            menuBarConfiguration.addMenus(menuBar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(CANNOT_CREATE_MENUBAR);
            System.err.println(FILE_NOT_FOUND + illegalArgumentException.getLocalizedMessage());
        }
        catch (SAXException sAXException) {
            System.err.println(CANNOT_CREATE_MENUBAR);
            System.err.println(FILE_NOT_FOUND + sAXException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            System.err.println(CANNOT_CREATE_MENUBAR);
            System.err.println(FILE_NOT_FOUND + iOException.getLocalizedMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(CANNOT_CREATE_MENUBAR);
            System.err.println(FILE_NOT_FOUND + parserConfigurationException.getLocalizedMessage());
        }
        return menuBar;
    }

    private static class MenuBarConfigurationHandler
    implements InvocationHandler {
        protected static final String LABEL = "label";
        protected static final String MENU = "menu";
        protected static final String MNEMONIC = "mnemonic";
        protected static final String SUBMENU = "submenu";
        protected static final String SEPARATOR = "separator";
        protected static final String ENABLED = "enabled";
        protected static final String ACCELERATOR = "accelerator";
        protected static final String CALLBACK = "callback";
        protected static final String TYPE = "type";
        protected static final String INSTRUCTION = "instruction";
        protected static final String TRUE = "true";
        private Document dom;
        private Collection<String> internalMethodNames;

        public MenuBarConfigurationHandler(String string) throws SAXException, IOException, ParserConfigurationException {
            Method[] methodArray;
            if (!new File(string).exists()) {
                throw new IOException();
            }
            this.internalMethodNames = new TreeSet<String>();
            for (Method method : methodArray = this.getClass().getMethods()) {
                this.internalMethodNames.add(method.getName());
            }
            this.dom = ScilabDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(string));
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (this.internalMethodNames.contains(method.getName())) {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, objectArray);
            }
            return null;
        }

        public void addMenus(MenuBar menuBar) {
            NodeList nodeList = this.dom.getElementsByTagName(MENU);
            Menu menu = ScilabMenu.createMenu();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                menu = ScilabMenu.createMenu();
                menu.setText(Messages.gettext((String)nodeList.item(i).getAttributes().getNamedItem(LABEL).getNodeValue()));
                if (nodeList.item(i).getAttributes().getNamedItem(MNEMONIC) != null) {
                    menu.setMnemonic(nodeList.item(i).getAttributes().getNamedItem(MNEMONIC).getNodeValue().charAt(0));
                }
                if (nodeList.item(i).getAttributes().getNamedItem(ENABLED) != null) {
                    menu.setEnabled(nodeList.item(i).getAttributes().getNamedItem(ENABLED).getNodeValue().equals(TRUE));
                }
                this.addSubMenus(menu, i);
                menuBar.add(menu);
            }
        }

        public void addSubMenus(Menu menu, int n) {
            for (Node node = this.dom.getElementsByTagName(MENU).item(n).getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object;
                if (node.getNodeName() == SEPARATOR) {
                    menu.addSeparator();
                    continue;
                }
                if (node.getNodeName() != SUBMENU) continue;
                MenuItem menuItem = ScilabMenuItem.createMenuItem();
                menu.add(menuItem);
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    if (namedNodeMap.item(i).getNodeName() == LABEL) {
                        menuItem.setText(Messages.gettext((String)namedNodeMap.item(i).getNodeValue()));
                        continue;
                    }
                    if (namedNodeMap.item(i).getNodeName() == MNEMONIC) {
                        menuItem.setMnemonic(namedNodeMap.item(i).getNodeValue().charAt(0));
                        continue;
                    }
                    if (namedNodeMap.item(i).getNodeName() == ENABLED) {
                        menuItem.setEnabled(namedNodeMap.item(i).getNodeValue().equals(TRUE));
                        continue;
                    }
                    if (namedNodeMap.item(i).getNodeName() != ACCELERATOR) continue;
                    object = (SwingScilabMenuItem)menuItem.getAsSimpleMenuItem();
                    ((JMenuItem)object).setAccelerator(ScilabKeyStroke.getKeyStroke((String)namedNodeMap.item(i).getNodeValue()));
                }
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeName() == CALLBACK) {
                        object = node2.getAttributes();
                        String string = null;
                        int n2 = -1;
                        for (int i = 0; i < object.getLength(); ++i) {
                            if (object.item(i).getNodeName() == INSTRUCTION) {
                                string = object.item(i).getNodeValue();
                                continue;
                            }
                            if (object.item(i).getNodeName() != TYPE) continue;
                            n2 = Integer.parseInt(object.item(i).getNodeValue());
                        }
                        if (string == null || n2 == -1) continue;
                        menuItem.setCallback(CommonCallBack.createCallback(this.replaceFigureID(string), n2));
                        continue;
                    }
                    if (node2.getNodeName() != SUBMENU) continue;
                    this.addSubMenuItem(menuItem, node2);
                }
            }
        }

        public void addSubMenuItem(MenuItem menuItem, Node node) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            MenuItem menuItem2 = ScilabMenuItem.createMenuItem();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                if (namedNodeMap.item(i).getNodeName() == LABEL) {
                    menuItem2.setText(Messages.gettext((String)namedNodeMap.item(i).getNodeValue()));
                    menuItem2.setText(Messages.gettext((String)namedNodeMap.item(i).getNodeValue()));
                    continue;
                }
                if (namedNodeMap.item(i).getNodeName() == MNEMONIC) {
                    menuItem2.setMnemonic(namedNodeMap.item(i).getNodeValue().charAt(0));
                    continue;
                }
                if (namedNodeMap.item(i).getNodeName() != ENABLED) continue;
                menuItem2.setEnabled(namedNodeMap.item(i).getNodeValue().equals(TRUE));
            }
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeName() == CALLBACK) {
                    NamedNodeMap namedNodeMap2 = node2.getAttributes();
                    String string = null;
                    int n = -1;
                    for (int i = 0; i < namedNodeMap2.getLength(); ++i) {
                        if (namedNodeMap2.item(i).getNodeName() == INSTRUCTION) {
                            string = namedNodeMap2.item(i).getNodeValue();
                            continue;
                        }
                        if (namedNodeMap2.item(i).getNodeName() != TYPE) continue;
                        n = Integer.parseInt(namedNodeMap2.item(i).getNodeValue());
                    }
                    if (string == null || n == -1) continue;
                    menuItem2.setCallback(CommonCallBack.createCallback(this.replaceFigureID(string), n));
                    continue;
                }
                if (node2.getNodeName() != SUBMENU) continue;
                this.addSubMenuItem(menuItem2, node2);
            }
            menuItem.add(menuItem2);
        }

        private String replaceFigureID(String string) {
            return string.replaceAll("\\[SCILAB_FIGURE_ID\\]", Integer.toString(figureIndex));
        }
    }
}

