/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.helpbrowser;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.flexdock.view.View;
import org.scilab.modules.commons.ScilabCommons;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabGUIUtilities;
import org.scilab.modules.gui.bridge.ScilabBridge;
import org.scilab.modules.gui.bridge.helpbrowser.SwingScilabHelpBrowser;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.toolbar.SwingScilabToolBar;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.dockable.ScilabDockable;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.helpbrowser.HelpBrowser;
import org.scilab.modules.gui.helpbrowser.SimpleHelpBrowser;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.tab.ScilabTab;
import org.scilab.modules.gui.tab.Tab;
import org.scilab.modules.gui.tabfactory.HelpBrowserTabFactory;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ScilabToolBar;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.gui.utils.MenuBarBuilder;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.localization.Messages;

public class ScilabHelpBrowser
extends ScilabDockable
implements HelpBrowser {
    public static final String HELPUUID = "d1ef5062-533e-4aee-b12a-66740820d6d1";
    private static final String SCI = ScilabConstants.SCI.getPath();
    private static final String MENUBARXMLFILE = SCI + "/modules/gui/etc/helpbrowser_menubar.xml";
    private static HelpBrowser instance;
    private static Tab helpTab;
    private static String language;
    private static String[] helps;
    private SimpleHelpBrowser component;
    private SwingScilabWindow parentWindow;

    protected ScilabHelpBrowser(String[] stringArray, String string) {
        if (string == null) {
            string = ScilabCommons.getlanguage();
        }
        this.component = ScilabBridge.createHelpBrowser(stringArray, string);
    }

    public static SwingScilabDockablePanel createHelpBrowserTab() {
        helpTab = ScilabTab.createTab(Messages.gettext((String)"Help Browser"), HELPUUID);
        String string = ScilabHelpBrowser.restoreHelpBrowserState();
        if (!SwingScilabHelpBrowser.isMainJarExists(language)) {
            System.err.println("No help file available.");
            return null;
        }
        instance = new ScilabHelpBrowser(helps, language);
        helpTab.addMember(instance);
        MenuBar menuBar = MenuBarBuilder.buildMenuBar(MENUBARXMLFILE);
        helpTab.addMenuBar(menuBar);
        TextBox textBox = ScilabTextBox.createTextBox();
        helpTab.addInfoBar(textBox);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getID() == 401) {
                    Container container = SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)((SwingScilabDockablePanel)helpTab.getAsSimpleTab())));
                    if (keyEvent.getSource() instanceof Component) {
                        Container container2 = SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)keyEvent.getSource());
                        char c = keyEvent.getKeyChar();
                        if (container2 == container && (c == '-' || c == '_' || c == '=' || c == '+') && (keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                            if (c == '-' || c == '_') {
                                ((SwingScilabHelpBrowser)((ScilabHelpBrowser)ScilabHelpBrowser.instance).component).decreaseFont();
                            } else {
                                ((SwingScilabHelpBrowser)((ScilabHelpBrowser)ScilabHelpBrowser.instance).component).increaseFont();
                            }
                            return true;
                        }
                    }
                }
                return false;
            }
        });
        SwingScilabHelpBrowser swingScilabHelpBrowser = (SwingScilabHelpBrowser)((ScilabHelpBrowser)ScilabHelpBrowser.instance).component;
        swingScilabHelpBrowser.setCurrentID(string);
        ToolBar toolBar = ScilabToolBar.createToolBar();
        int n = swingScilabHelpBrowser.getToolbar().getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((SwingScilabToolBar)toolBar.getAsSimpleToolBar()).add(swingScilabHelpBrowser.getToolbar().getComponent(0));
        }
        JButton jButton = new JButton(CommonCallBack.createCallback("about();", 0));
        try {
            jButton.setIcon(FindIconHelper.loadIcon((String)"help-browser"));
            jButton.setToolTipText(Messages.gettext((String)"About Scilab..."));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ((SwingScilabToolBar)toolBar.getAsSimpleToolBar()).add(jButton);
        helpTab.addToolBar(toolBar);
        ((SwingScilabDockablePanel)helpTab.getAsSimpleTab()).setAssociatedXMLIDForHelp("helpbrowser");
        WindowsConfigurationManager.restorationFinished((SwingScilabDockablePanel)helpTab.getAsSimpleTab());
        return (SwingScilabDockablePanel)helpTab.getAsSimpleTab();
    }

    public static HelpBrowser createHelpBrowser(String[] stringArray, String string) {
        if (!SwingScilabHelpBrowser.isMainJarExists(string)) {
            System.err.println("No help file available.");
            return null;
        }
        if (instance == null) {
            language = string;
            helps = stringArray;
            boolean bl = WindowsConfigurationManager.restoreUUID(HELPUUID);
            if (!bl) {
                HelpBrowserTabFactory.getInstance().getTab(HELPUUID);
                ((ScilabHelpBrowser)instance).setParentWindow();
                ((ScilabHelpBrowser)ScilabHelpBrowser.instance).parentWindow.addTab((SwingScilabDockablePanel)helpTab.getAsSimpleTab());
                ((ScilabHelpBrowser)ScilabHelpBrowser.instance).parentWindow.setVisible(true);
            }
            if (ScilabConsole.isExistingConsole() && ScilabConsole.getConsole().getInfoBar() != null && ScilabConsole.getConsole().getInfoBar().getText().equals(Messages.gettext((String)"Loading help browser..."))) {
                ScilabConsole.getConsole().getInfoBar().setText("");
                return null;
            }
        } else if (!string.equals(language)) {
            language = string;
            if (!SwingScilabHelpBrowser.isMainJarExists(string)) {
                System.err.println("No help file available.");
                return instance;
            }
            ((SwingScilabHelpBrowser)((ScilabHelpBrowser)ScilabHelpBrowser.instance).component).loadJar(stringArray, string);
        } else if (!Arrays.deepEquals(stringArray, helps)) {
            helps = stringArray;
            ((SwingScilabHelpBrowser)((ScilabHelpBrowser)ScilabHelpBrowser.instance).component).loadJar(stringArray, string);
        }
        ScilabGUIUtilities.toFront((View)((SwingScilabDockablePanel)helpTab.getAsSimpleTab()), (String)Messages.gettext((String)"Help Browser"));
        return instance;
    }

    public void setParentWindow() {
        this.parentWindow = SwingScilabWindow.createWindow(true);
        this.parentWindow.setLocation(0, 0);
        this.parentWindow.setSize(500, 500);
    }

    public static void startHomePage() {
        if (instance != null) {
            SwingScilabHelpBrowser swingScilabHelpBrowser = (SwingScilabHelpBrowser)((ScilabHelpBrowser)ScilabHelpBrowser.instance).component;
            try {
                swingScilabHelpBrowser.displayHomePage();
            }
            catch (Exception exception) {
                System.err.println("This error should not occurred, please report it at bugzilla.scilab.org\n" + String.valueOf(exception));
            }
        }
    }

    public String getCurrentURL() {
        SwingScilabHelpBrowser swingScilabHelpBrowser = (SwingScilabHelpBrowser)((ScilabHelpBrowser)ScilabHelpBrowser.instance).component;
        return swingScilabHelpBrowser.getCurrentURL();
    }

    public String getCurrentID() {
        SwingScilabHelpBrowser swingScilabHelpBrowser = (SwingScilabHelpBrowser)((ScilabHelpBrowser)ScilabHelpBrowser.instance).component;
        return swingScilabHelpBrowser.getCurrentID();
    }

    @Override
    public void increaseFont() {
        SwingScilabHelpBrowser swingScilabHelpBrowser = (SwingScilabHelpBrowser)((ScilabHelpBrowser)ScilabHelpBrowser.instance).component;
        swingScilabHelpBrowser.increaseFont();
    }

    @Override
    public void decreaseFont() {
        SwingScilabHelpBrowser swingScilabHelpBrowser = (SwingScilabHelpBrowser)((ScilabHelpBrowser)ScilabHelpBrowser.instance).component;
        swingScilabHelpBrowser.decreaseFont();
    }

    @Override
    public void showSearchField() {
        SwingScilabHelpBrowser swingScilabHelpBrowser = (SwingScilabHelpBrowser)((ScilabHelpBrowser)ScilabHelpBrowser.instance).component;
        swingScilabHelpBrowser.showSearchField();
    }

    public void hideSearchField() {
        SwingScilabHelpBrowser swingScilabHelpBrowser = (SwingScilabHelpBrowser)((ScilabHelpBrowser)ScilabHelpBrowser.instance).component;
        swingScilabHelpBrowser.hideSearchField();
    }

    public static HelpBrowser getHelpBrowser() {
        if (instance == null) {
            instance = new ScilabHelpBrowser(null, "en_US");
        }
        return instance;
    }

    public static HelpBrowser getHelpBrowserWithoutCreation() {
        return instance;
    }

    @Override
    public void display() {
        ScilabBridge.display(this);
    }

    @Override
    public void searchKeywork(String string) {
        ScilabBridge.searchKeywork(this, string);
    }

    @Override
    public void fullTextSearch(String string) {
        ScilabBridge.fullTextSearch(this, string);
    }

    public void closeHelpBrowser() {
        this.saveHelpBrowserState();
        instance = null;
    }

    public static void closeHB() {
        ((ScilabHelpBrowser)instance).closeHelpBrowser();
    }

    @Override
    public void close() {
        ClosingOperationsManager.startClosingOperation((SwingScilabDockablePanel)helpTab.getAsSimpleTab());
    }

    @Override
    public void draw() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleHelpBrowser getAsSimpleHelpBrowser() {
        return this.component;
    }

    @Override
    public Size getDims() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Position getPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isVisible() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDims(Size size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPosition(Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVisible(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        return helpTab.getInfoBar();
    }

    public void saveHelpBrowserState() {
        String string = this.getCurrentID();
        if (string != null) {
            ConfigManager.saveHelpBrowserState(string);
        }
    }

    public static String restoreHelpBrowserState() {
        return ConfigManager.getHelpBrowserState();
    }

    static {
        ScilabTabFactory.getInstance().addTabFactory(HelpBrowserTabFactory.getInstance());
    }
}

