/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.ged.graphic_objects.polyline;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.scilab.modules.graphic_objects.PolylineData;
import org.scilab.modules.gui.ged.MessagesGED;
import org.scilab.modules.gui.ged.graphic_objects.SimpleSection;

public class Shift
extends SimpleSection {
    private JPanel sectionPanel;
    private static Shift instance;
    private Integer currentpolyline;
    private JLabel lShiftX = new JLabel();
    private JLabel cShiftX = new JLabel();
    private JButton bShiftX = new JButton();
    private JPanel pShiftX = new JPanel();
    private JLabel lShiftY = new JLabel();
    private JLabel cShiftY = new JLabel();
    private JButton bShiftY = new JButton();
    private JPanel pShiftY = new JPanel();
    private JLabel lShiftZ = new JLabel();
    private JLabel cShiftZ = new JLabel();
    private JButton bShiftZ = new JButton();
    private JPanel pShiftZ = new JPanel();
    private JDialog shiftDialog = new JDialog();
    private JScrollPane shiftScroll = new JScrollPane();
    private JTable shiftTable = new JTable();
    private JButton refresh = new JButton();
    private JButton ok = new JButton();

    public Shift(Integer n) {
        super(MessagesGED.shift, "polyline");
        instance = this;
        this.currentpolyline = n;
        this.sectionPanel = this.getSectionPanel();
        this.initComponents(n);
        this.updateShiftTable(0);
        this.updateShiftTable(1);
        this.updateShiftTable(2);
    }

    public static Shift getInstance() {
        return instance;
    }

    @Override
    public final void initComponents(Integer n) {
        int n2 = 0;
        int n3 = 0;
        this.shiftDialog();
        this.addJLabel(this.sectionPanel, this.lShiftX, MessagesGED.x_shift, n3, n2, 16);
        this.addDataField(this.sectionPanel, this.pShiftX, this.bShiftX, this.cShiftX, n3 + 1, n2);
        this.bShiftX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Shift.this.updateShiftTable(0);
                Shift.this.shiftDialog.setVisible(true);
            }
        });
        this.addJLabel(this.sectionPanel, this.lShiftY, MessagesGED.y_shift, n3, ++n2, 16);
        this.addDataField(this.sectionPanel, this.pShiftY, this.bShiftY, this.cShiftY, n3 + 1, n2);
        this.bShiftY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Shift.this.updateShiftTable(1);
                Shift.this.shiftDialog.setVisible(true);
            }
        });
        this.addJLabel(this.sectionPanel, this.lShiftZ, MessagesGED.z_shift, n3, ++n2, 16);
        this.addDataField(this.sectionPanel, this.pShiftZ, this.bShiftZ, this.cShiftZ, n3 + 1, n2);
        this.bShiftZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Shift.this.updateShiftTable(2);
                Shift.this.shiftDialog.setVisible(true);
            }
        });
        ++n2;
    }

    private void shiftDialog() {
        this.addShiftDialog(this.shiftDialog, this.shiftScroll, this.shiftTable, this.refresh, this.ok);
        this.shiftDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Shift.this.updateShiftTable(0);
                Shift.this.updateShiftTable(1);
                Shift.this.updateShiftTable(2);
            }
        });
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = Shift.this.shiftTable.getColumnName(0);
                if ("X".equals(string)) {
                    Shift.this.updateShiftTable(0);
                } else if ("Y".equals(string)) {
                    Shift.this.updateShiftTable(1);
                } else if ("Z".equals(string)) {
                    Shift.this.updateShiftTable(2);
                }
            }
        });
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Shift.this.updateShiftTable(0);
                Shift.this.updateShiftTable(1);
                Shift.this.updateShiftTable(2);
                Shift.this.shiftDialog.dispose();
            }
        });
        this.shiftTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                Shift.this.shiftTableEvent(tableModelEvent);
            }
        });
    }

    private void shiftTableEvent(TableModelEvent tableModelEvent) {
        Object object;
        if (this.shiftTable.getSelectedRow() != -1 && (object = this.shiftTable.getValueAt(this.shiftTable.getSelectedRow(), 1)) == null) {
            object = 0.0;
        }
    }

    public final void updateShiftTable(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.shiftTable.getModel();
        switch (n) {
            case 0: {
                Object[][] objectArray;
                if (PolylineData.isXShiftSet((int)this.currentpolyline) == 0) {
                    objectArray = this.getShift(0, true);
                    this.cShiftX.setText("null");
                } else {
                    objectArray = this.getShift(0, false);
                    this.cShiftX.setText("1x" + objectArray.length);
                }
                defaultTableModel.setDataVector(objectArray, new String[]{"X", MessagesGED.x_shift});
                break;
            }
            case 1: {
                Object[][] objectArray;
                if (PolylineData.isYShiftSet((int)this.currentpolyline) == 0) {
                    objectArray = this.getShift(1, true);
                    this.cShiftY.setText("null");
                } else {
                    objectArray = this.getShift(1, false);
                    this.cShiftY.setText("1x" + objectArray.length);
                }
                defaultTableModel.setDataVector(objectArray, new String[]{"Y", MessagesGED.y_shift});
                break;
            }
            case 2: {
                Object[][] objectArray;
                if (PolylineData.isZShiftSet((int)this.currentpolyline) == 0) {
                    objectArray = this.getShift(2, true);
                    this.cShiftZ.setText("null");
                } else {
                    objectArray = this.getShift(2, false);
                    this.cShiftZ.setText("1x" + objectArray.length);
                }
                defaultTableModel.setDataVector(objectArray, new String[]{"Z", MessagesGED.z_shift});
            }
        }
    }

    public Object[][] getShift(int n, boolean bl) {
        double[] dArray = null;
        double[] dArray2 = null;
        switch (n) {
            case 0: {
                dArray = (double[])PolylineData.getDataX((int)this.currentpolyline);
                break;
            }
            case 1: {
                dArray = (double[])PolylineData.getDataY((int)this.currentpolyline);
                break;
            }
            case 2: {
                dArray = (double[])PolylineData.getDataZ((int)this.currentpolyline);
            }
        }
        Object[][] objectArray = new Object[dArray.length][2];
        if (!bl) {
            switch (n) {
                case 0: {
                    dArray2 = (double[])PolylineData.getShiftX((int)this.currentpolyline);
                    break;
                }
                case 1: {
                    dArray2 = (double[])PolylineData.getShiftY((int)this.currentpolyline);
                    break;
                }
                case 2: {
                    dArray2 = (double[])PolylineData.getShiftZ((int)this.currentpolyline);
                }
            }
            for (int i = 0; i < dArray.length; ++i) {
                objectArray[i][0] = dArray[i];
                objectArray[i][1] = dArray2[i];
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                objectArray[i][0] = dArray[i];
                objectArray[i][1] = 0;
            }
        }
        return objectArray;
    }
}

