/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.ged.graphic_objects.contouredObject;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MarkStyle {
    CIRCLE_SOLID{

        @Override
        public Graphics2D getMarkStyle() {
            g2d.setPaint(foreground);
            g2d.drawOval(5, 2, 14, 14);
            g2d.fillOval(5, 2, 14, 14);
            return g2d;
        }
    }
    ,
    PLUS{

        @Override
        public Graphics2D getMarkStyle() {
            g2d.setPaint(foreground);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawLine(12, 4, 12, 16);
            g2d.drawLine(6, 10, 18, 10);
            return g2d;
        }
    }
    ,
    CROSS{

        @Override
        public Graphics2D getMarkStyle() {
            g2d.setPaint(foreground);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawLine(6, 6, 16, 16);
            g2d.drawLine(16, 6, 6, 16);
            return g2d;
        }
    }
    ,
    CIRCLE_PLUS{

        @Override
        public Graphics2D getMarkStyle() {
            g2d.setPaint(background);
            g2d.fillOval(5, 2, 14, 14);
            g2d.setPaint(foreground);
            g2d.drawOval(5, 2, 14, 14);
            g2d.drawLine(12, 3, 12, 15);
            g2d.drawLine(6, 9, 18, 9);
            return g2d;
        }
    }
    ,
    DIAMOND_SOLID{

        @Override
        public Graphics2D getMarkStyle() {
            g2d.setPaint(background);
            g2d.rotate(Math.toRadians(45.0), 6.0, 6.0);
            g2d.fillRect(7, -1, 11, 11);
            g2d.setPaint(foreground);
            return g2d;
        }
    }
    ,
    DIAMOND{

        @Override
        public Graphics2D getMarkStyle() {
            g2d.setPaint(background);
            g2d.rotate(Math.toRadians(45.0), 6.0, 6.0);
            g2d.fillRect(7, -1, 11, 11);
            g2d.setPaint(foreground);
            g2d.drawRect(7, -1, 11, 11);
            return g2d;
        }
    }
    ,
    UP{

        @Override
        public Graphics2D getMarkStyle() {
            int[] nArray = new int[]{5, 12, 19};
            int[] nArray2 = new int[]{14, 3, 14};
            int n = nArray.length;
            g2d.setPaint(background);
            g2d.fillPolygon(nArray, nArray2, n);
            g2d.setPaint(foreground);
            g2d.drawPolygon(nArray, nArray2, n);
            return g2d;
        }
    }
    ,
    DOWN{

        @Override
        public Graphics2D getMarkStyle() {
            int[] nArray = new int[]{5, 12, 19};
            int[] nArray2 = new int[]{3, 14, 3};
            int n = nArray.length;
            g2d.setPaint(background);
            g2d.fillPolygon(nArray, nArray2, n);
            g2d.setPaint(foreground);
            g2d.drawPolygon(nArray, nArray2, n);
            return g2d;
        }
    }
    ,
    DIAMOND_PLUS{

        @Override
        public Graphics2D getMarkStyle() {
            g2d.setPaint(background);
            g2d.rotate(Math.toRadians(45.0), 6.0, 6.0);
            g2d.fillRect(7, -1, 11, 11);
            g2d.setPaint(foreground);
            g2d.drawRect(7, -1, 11, 11);
            g2d.rotate(Math.toRadians(-45.0), 6.0, 6.0);
            g2d.drawLine(12, 3, 12, 16);
            g2d.drawLine(5, 10, 18, 10);
            return g2d;
        }
    }
    ,
    CIRCLE{

        @Override
        public Graphics2D getMarkStyle() {
            g2d.setPaint(background);
            g2d.fillOval(5, 2, 14, 14);
            g2d.setPaint(foreground);
            g2d.drawOval(5, 2, 14, 14);
            return g2d;
        }
    }
    ,
    ASTERISK{

        @Override
        public Graphics2D getMarkStyle() {
            g2d.setPaint(foreground);
            g2d.drawLine(7, 5, 17, 15);
            g2d.drawLine(17, 5, 7, 15);
            g2d.drawLine(12, 4, 12, 16);
            g2d.drawLine(6, 10, 18, 10);
            return g2d;
        }
    }
    ,
    SQUARE{

        @Override
        public Graphics2D getMarkStyle() {
            g2d.setPaint(background);
            g2d.fillRect(6, 2, 12, 12);
            g2d.setPaint(foreground);
            g2d.drawRect(6, 2, 12, 12);
            return g2d;
        }
    }
    ,
    FORWARD{

        @Override
        public Graphics2D getMarkStyle() {
            int[] nArray = new int[]{6, 6, 19};
            int[] nArray2 = new int[]{2, 16, 9};
            int n = nArray.length;
            g2d.setPaint(background);
            g2d.fillPolygon(nArray, nArray2, n);
            g2d.setPaint(foreground);
            g2d.drawPolygon(nArray, nArray2, n);
            return g2d;
        }
    }
    ,
    BACKWARD{

        @Override
        public Graphics2D getMarkStyle() {
            int[] nArray = new int[]{6, 19, 19};
            int[] nArray2 = new int[]{9, 2, 16};
            int n = nArray.length;
            g2d.setPaint(background);
            g2d.fillPolygon(nArray, nArray2, n);
            g2d.setPaint(foreground);
            g2d.drawPolygon(nArray, nArray2, n);
            return g2d;
        }
    }
    ,
    STAR{

        @Override
        public Graphics2D getMarkStyle() {
            Point point = new Point(15, 9);
            double d = 0.6283185307179586;
            GeneralPath generalPath = new GeneralPath();
            for (int i = 0; i < 10; ++i) {
                double d2 = (i & 1) == 0 ? 8.0 : 3.0;
                Point2D.Double double_ = new Point2D.Double((double)point.x + Math.cos((double)i * d) * d2, (double)point.y + Math.sin((double)i * d) * d2);
                if (i == 0) {
                    generalPath.moveTo(double_.getX(), double_.getY());
                    continue;
                }
                generalPath.lineTo(double_.getX(), double_.getY());
            }
            generalPath.closePath();
            g2d.rotate(Math.toRadians(54.0), point.getX(), point.getY());
            g2d.setPaint(background);
            g2d.fill(generalPath);
            g2d.setPaint(foreground);
            g2d.draw(generalPath);
            return g2d;
        }
    };

    private static Graphics2D g2d;
    private static Color background;
    private static Color foreground;

    public abstract Graphics2D getMarkStyle();

    public void setGraphics2D(Graphics2D graphics2D) {
        g2d = graphics2D;
    }

    public void setBackground(Color color) {
        background = color;
    }

    public void setForeground(Color color) {
        foreground = color;
    }

    static {
        background = Color.WHITE;
        foreground = Color.BLACK;
    }
}

