/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.GLBuffers;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.cef.CefBrowserSettings;
import org.cef.CefClient;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefDropTargetListener;
import org.cef.browser.CefPaintEvent;
import org.cef.browser.CefRenderer;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefDragData;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefScreenInfo;

class CefBrowserOsr
extends CefBrowser_N
implements CefRenderHandler {
    private CefRenderer renderer_;
    private GLCanvas canvas_;
    private long window_handle_ = 0L;
    private boolean justCreated_ = false;
    private Rectangle browser_rect_ = new Rectangle(0, 0, 1, 1);
    private Point screenPoint_ = new Point(0, 0);
    private double scaleFactor_ = 1.0;
    private int depth = 32;
    private int depth_per_component = 8;
    private boolean isTransparent_;
    private CopyOnWriteArrayList<Consumer<CefPaintEvent>> onPaintListeners = new CopyOnWriteArrayList();

    CefBrowserOsr(CefClient cefClient, String string, boolean bl, CefRequestContext cefRequestContext, CefBrowserSettings cefBrowserSettings) {
        this(cefClient, string, bl, cefRequestContext, null, null, cefBrowserSettings);
    }

    private CefBrowserOsr(CefClient cefClient, String string, boolean bl, CefRequestContext cefRequestContext, CefBrowserOsr cefBrowserOsr, Point point, CefBrowserSettings cefBrowserSettings) {
        super(cefClient, string, cefRequestContext, cefBrowserOsr, point, cefBrowserSettings);
        this.isTransparent_ = bl;
        this.renderer_ = new CefRenderer(bl);
        this.createGLCanvas();
    }

    @Override
    public void createImmediately() {
        this.justCreated_ = true;
        this.createBrowserIfRequired(false);
    }

    @Override
    public Component getUIComponent() {
        return this.canvas_;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return this;
    }

    @Override
    protected CefBrowser_N createDevToolsBrowser(CefClient cefClient, String string, CefRequestContext cefRequestContext, CefBrowser_N cefBrowser_N, Point point) {
        return new CefBrowserOsr(cefClient, string, this.isTransparent_, cefRequestContext, this, point, null);
    }

    private synchronized long getWindowHandle() {
        NativeSurface nativeSurface;
        if (this.window_handle_ == 0L && (nativeSurface = this.canvas_.getNativeSurface()) != null) {
            nativeSurface.lockSurface();
            this.window_handle_ = this.getWindowHandle(nativeSurface.getSurfaceHandle());
            nativeSurface.unlockSurface();
            assert (this.window_handle_ != 0L);
        }
        return this.window_handle_;
    }

    private void createGLCanvas() {
        GLProfile gLProfile = GLProfile.getMaxFixedFunc((boolean)true);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.canvas_ = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities){
            private Method scaleFactorAccessor;
            private boolean removed_;
            {
                this.scaleFactorAccessor = null;
                this.removed_ = true;
            }

            public void paint(Graphics graphics) {
                block7: {
                    CefBrowserOsr.this.createBrowserIfRequired(true);
                    if (graphics instanceof Graphics2D) {
                        GraphicsConfiguration graphicsConfiguration = ((Graphics2D)graphics).getDeviceConfiguration();
                        CefBrowserOsr.this.depth = graphicsConfiguration.getColorModel().getPixelSize();
                        CefBrowserOsr.this.depth_per_component = graphicsConfiguration.getColorModel().getComponentSize()[0];
                        if (OS.isMacintosh() && System.getProperty("java.runtime.version").startsWith("1.8")) {
                            try {
                                Object object;
                                if (this.scaleFactorAccessor == null) {
                                    this.scaleFactorAccessor = ((Object)((Object)this)).getClass().getClassLoader().loadClass("sun.awt.CGraphicsDevice").getDeclaredMethod("getScaleFactor", new Class[0]);
                                }
                                if ((object = this.scaleFactorAccessor.invoke((Object)graphicsConfiguration.getDevice(), new Object[0])) instanceof Integer) {
                                    CefBrowserOsr.this.scaleFactor_ = ((Integer)object).doubleValue();
                                    break block7;
                                }
                                CefBrowserOsr.this.scaleFactor_ = 1.0;
                            }
                            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                                CefBrowserOsr.this.scaleFactor_ = 1.0;
                            }
                        } else {
                            CefBrowserOsr.this.scaleFactor_ = ((Graphics2D)graphics).getTransform().getScaleX();
                        }
                    }
                }
                super.paint(graphics);
            }

            public void addNotify() {
                super.addNotify();
                if (this.removed_) {
                    CefBrowserOsr.this.notifyAfterParentChanged();
                    this.removed_ = false;
                }
            }

            public void removeNotify() {
                if (!this.removed_) {
                    if (!CefBrowserOsr.this.isClosed()) {
                        CefBrowserOsr.this.notifyAfterParentChanged();
                    }
                    this.removed_ = true;
                }
                super.removeNotify();
            }
        };
        this.canvas_.addGLEventListener(new GLEventListener(){

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                int n5 = n3;
                int n6 = n4;
                if (OS.isMacintosh()) {
                    n5 = (int)((double)n3 / CefBrowserOsr.this.scaleFactor_);
                    n6 = (int)((double)n4 / CefBrowserOsr.this.scaleFactor_);
                }
                CefBrowserOsr.this.browser_rect_.setBounds(n, n2, n5, n6);
                CefBrowserOsr.this.screenPoint_ = CefBrowserOsr.this.canvas_.getLocationOnScreen();
                CefBrowserOsr.this.wasResized(n5, n6);
            }

            public void init(GLAutoDrawable gLAutoDrawable) {
                CefBrowserOsr.this.renderer_.initialize(gLAutoDrawable.getGL().getGL2());
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
                CefBrowserOsr.this.renderer_.cleanup(gLAutoDrawable.getGL().getGL2());
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                CefBrowserOsr.this.renderer_.render(gLAutoDrawable.getGL().getGL2());
            }
        });
        this.canvas_.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }
        });
        this.canvas_.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }
        });
        this.canvas_.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                CefBrowserOsr.this.sendMouseWheelEvent(mouseWheelEvent);
            }
        });
        this.canvas_.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                CefBrowserOsr.this.sendKeyEvent(keyEvent);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                CefBrowserOsr.this.sendKeyEvent(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                CefBrowserOsr.this.sendKeyEvent(keyEvent);
            }
        });
        this.canvas_.setFocusable(true);
        this.canvas_.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CefBrowserOsr.this.setFocus(false);
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                CefBrowserOsr.this.setFocus(true);
            }
        });
        new DropTarget((Component)this.canvas_, new CefDropTargetListener(this));
    }

    @Override
    public Rectangle getViewRect(CefBrowser cefBrowser) {
        return this.browser_rect_;
    }

    @Override
    public Point getScreenPoint(CefBrowser cefBrowser, Point point) {
        Point point2 = new Point(this.screenPoint_);
        point2.translate(point.x, point.y);
        return point2;
    }

    @Override
    public void onPopupShow(CefBrowser cefBrowser, boolean bl) {
        if (!bl) {
            this.renderer_.clearPopupRects();
            this.invalidate();
        }
    }

    @Override
    public void onPopupSize(CefBrowser cefBrowser, Rectangle rectangle) {
        this.renderer_.onPopupSize(rectangle);
    }

    @Override
    public void addOnPaintListener(Consumer<CefPaintEvent> consumer) {
        this.onPaintListeners.add(consumer);
    }

    @Override
    public void setOnPaintListener(Consumer<CefPaintEvent> consumer) {
        this.onPaintListeners.clear();
        this.onPaintListeners.add(consumer);
    }

    @Override
    public void removeOnPaintListener(Consumer<CefPaintEvent> consumer) {
        this.onPaintListeners.remove(consumer);
    }

    @Override
    public void onPaint(CefBrowser cefBrowser, boolean bl, Rectangle[] rectangleArray, ByteBuffer byteBuffer, int n, int n2) {
        GLContext gLContext;
        GLContext gLContext2 = gLContext = this.canvas_ != null ? this.canvas_.getContext() : null;
        if (gLContext == null) {
            return;
        }
        if (gLContext.makeCurrent() == 0) {
            return;
        }
        this.renderer_.onPaint(this.canvas_.getGL().getGL2(), bl, rectangleArray, byteBuffer, n, n2);
        gLContext.release();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefBrowserOsr.this.canvas_.display();
            }
        });
        if (!this.onPaintListeners.isEmpty()) {
            CefPaintEvent cefPaintEvent = new CefPaintEvent(cefBrowser, bl, rectangleArray, byteBuffer, n, n2);
            for (Consumer<CefPaintEvent> consumer : this.onPaintListeners) {
                consumer.accept(cefPaintEvent);
            }
        }
    }

    @Override
    public boolean onCursorChange(CefBrowser cefBrowser, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefBrowserOsr.this.canvas_.setCursor(new Cursor(n));
            }
        });
        return true;
    }

    private static int getDndAction(int n) {
        int n2 = 0;
        if ((n & 1) == 1) {
            n2 = 1;
        } else if ((n & 0x10) == 16) {
            n2 = 2;
        } else if ((n & 2) == 2) {
            n2 = 0x40000000;
        }
        return n2;
    }

    @Override
    public boolean startDragging(CefBrowser cefBrowser, CefDragData cefDragData, int n, int n2, int n3) {
        final int n4 = CefBrowserOsr.getDndAction(n);
        MouseEvent mouseEvent = new MouseEvent((Component)this.canvas_, 506, 0L, 0, n2, n3, 0, false);
        DragGestureEvent dragGestureEvent = new DragGestureEvent(new SyntheticDragGestureRecognizer((Component)this.canvas_, n4, mouseEvent), n4, new Point(n2, n3), new ArrayList<MouseEvent>(Arrays.asList(mouseEvent)));
        DragSource.getDefaultDragSource().startDrag(dragGestureEvent, null, new StringSelection(cefDragData.getFragmentText()), new DragSourceAdapter(){

            @Override
            public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                CefBrowserOsr.this.dragSourceEndedAt(dragSourceDropEvent.getLocation(), n4);
                CefBrowserOsr.this.dragSourceSystemDragEnded();
            }
        });
        return true;
    }

    @Override
    public void updateDragCursor(CefBrowser cefBrowser, int n) {
    }

    private void createBrowserIfRequired(boolean bl) {
        long l = 0L;
        if (bl) {
            l = this.getWindowHandle();
        }
        if (this.getNativeRef("CefBrowser") == 0L) {
            if (this.getParentBrowser() != null) {
                this.createDevTools(this.getParentBrowser(), this.getClient(), l, true, this.isTransparent_, null, this.getInspectAt());
            } else {
                this.createBrowser(this.getClient(), l, this.getUrl(), true, this.isTransparent_, null, this.getRequestContext());
            }
        } else if (bl && this.justCreated_) {
            this.notifyAfterParentChanged();
            this.setFocus(true);
            this.justCreated_ = false;
        }
    }

    private void notifyAfterParentChanged() {
        this.getClient().onAfterParentChanged(this);
    }

    @Override
    public boolean getScreenInfo(CefBrowser cefBrowser, CefScreenInfo cefScreenInfo) {
        cefScreenInfo.Set(this.scaleFactor_, this.depth, this.depth_per_component, false, this.browser_rect_.getBounds(), this.browser_rect_.getBounds());
        return true;
    }

    @Override
    public CompletableFuture<BufferedImage> createScreenshot(final boolean bl) {
        final int n = (int)Math.ceil((double)this.canvas_.getWidth() * this.scaleFactor_);
        final int n2 = (int)Math.ceil((double)this.canvas_.getHeight() * this.scaleFactor_);
        final GL2 gL2 = this.canvas_.getGL().getGL2();
        final int n3 = this.renderer_.getTextureID();
        final boolean bl2 = n3 == 0;
        final Callable<BufferedImage> callable = new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() {
                BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
                ByteBuffer byteBuffer = GLBuffers.newDirectByteBuffer((int)(n * n2 * 4));
                gL2.getContext().makeCurrent();
                try {
                    if (bl2) {
                        gL2.glReadPixels(0, 0, n, n2, 6408, 5121, (Buffer)byteBuffer);
                    } else {
                        gL2.glEnable(3553);
                        gL2.glBindTexture(3553, n3);
                        gL2.glGetTexImage(3553, 0, 6408, 5121, (Buffer)byteBuffer);
                        gL2.glDisable(3553);
                    }
                }
                finally {
                    gL2.getContext().release();
                }
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n6 = byteBuffer.get() & 0xFF;
                        int n22 = byteBuffer.get() & 0xFF;
                        int n32 = byteBuffer.get() & 0xFF;
                        int n4 = byteBuffer.get() & 0xFF;
                        int n5 = n4 << 24 | n6 << 16 | n22 << 8 | n32 << 0;
                        bufferedImage.setRGB(j, bl2 ? n2 - i - 1 : i, n5);
                    }
                }
                if (!bl && CefBrowserOsr.this.scaleFactor_ != 1.0) {
                    BufferedImage bufferedImage2 = new BufferedImage((int)((double)bufferedImage.getWidth() / CefBrowserOsr.this.scaleFactor_), (int)((double)bufferedImage.getHeight() / CefBrowserOsr.this.scaleFactor_), 2);
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.scale(1.0 / CefBrowserOsr.this.scaleFactor_, 1.0 / CefBrowserOsr.this.scaleFactor_);
                    AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
                    bufferedImage2 = affineTransformOp.filter(bufferedImage, bufferedImage2);
                    return bufferedImage2;
                }
                return bufferedImage;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                BufferedImage bufferedImage = (BufferedImage)callable.call();
                return CompletableFuture.completedFuture(bufferedImage);
            }
            catch (Exception exception) {
                CompletableFuture<BufferedImage> completableFuture = new CompletableFuture<BufferedImage>();
                completableFuture.completeExceptionally(exception);
                return completableFuture;
            }
        }
        final CompletableFuture<BufferedImage> completableFuture = new CompletableFuture<BufferedImage>(){

            private void safeguardGet() {
                if (SwingUtilities.isEventDispatchThread()) {
                    throw new RuntimeException("Waiting on this Future using the AWT Event Thread is illegal, because it can potentially deadlock the thread.");
                }
            }

            @Override
            public BufferedImage get() throws InterruptedException, ExecutionException {
                this.safeguardGet();
                return (BufferedImage)super.get();
            }

            @Override
            public BufferedImage get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                this.safeguardGet();
                return (BufferedImage)super.get(l, timeUnit);
            }
        };
        this.canvas_.addGLEventListener(new GLEventListener(){

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                CefBrowserOsr.this.canvas_.removeGLEventListener((GLEventListener)this);
                try {
                    completableFuture.complete((BufferedImage)callable.call());
                }
                catch (Exception exception) {
                    completableFuture.completeExceptionally(exception);
                }
            }
        });
        this.canvas_.repaint();
        return completableFuture;
    }

    private static final class SyntheticDragGestureRecognizer
    extends DragGestureRecognizer {
        public SyntheticDragGestureRecognizer(Component component, int n, MouseEvent mouseEvent) {
            super(new DragSource(), component, n);
            this.appendEvent(mouseEvent);
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }
}

