/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.rosetta.util;

import com.artenum.rosetta.interfaces.core.CompletionManager;
import com.artenum.rosetta.interfaces.core.ConsoleConfiguration;
import com.artenum.rosetta.interfaces.core.GenericInterpreter;
import com.artenum.rosetta.interfaces.core.InputParsingManager;
import com.artenum.rosetta.interfaces.ui.CompletionWindow;
import com.artenum.rosetta.interfaces.ui.InputCommandView;
import com.artenum.rosetta.interfaces.ui.OutputView;
import com.artenum.rosetta.interfaces.ui.PromptView;
import com.artenum.rosetta.ui.Console;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class ConsoleBuilder {
    public static Console buildConsole(ConsoleConfiguration configuration, Component parentComponent) {
        Console console = new Console();
        PromptView promptView = configuration.getPromptView();
        OutputView outputView = configuration.getOutputView();
        InputCommandView inputCommandView = configuration.getInputCommandView();
        InputParsingManager inputParsingManager = configuration.getInputParsingManager();
        GenericInterpreter interpreter = configuration.getGenericInterpreter();
        CompletionManager completionManager = configuration.getCompletionManager();
        CompletionWindow completionWindow = configuration.getCompletionWindow();
        console.setPromptView(promptView);
        console.setOutputView(outputView);
        console.setInputCommandView(inputCommandView);
        outputView.setStyledDocument(configuration.getOutputViewStyledDocument());
        inputCommandView.setStyledDocument(configuration.getInputCommandViewStyledDocument());
        inputParsingManager.setInputCommandView(inputCommandView);
        promptView.setInputParsingManager(inputParsingManager);
        outputView.setEditable(false);
        outputView.append(configuration.getWelcomeLine());
        outputView.setCaretPositionToEnd();
        console.setScrollableBlockIncrement(configuration.getScrollableBlockIncrement());
        console.setScrollableUnitIncrement(configuration.getScrollableUnitIncrement());
        console.setVerticalWrapAllowed(configuration.getVerticalWrapAllowed());
        console.setHorizontalWrapAllowed(configuration.getHorizontalWrapAllowed());
        try {
            console.setFont(new Font(configuration.getFontName(), configuration.getFontStyle(), configuration.getFontSize()));
        }
        catch (Exception e) {
            System.out.println("Could not read font settings, switching to defaults.");
        }
        interpreter.setErrorWriter(outputView.getErrorWriter());
        interpreter.setWriter(outputView.getWriter());
        if (completionManager != null) {
            completionManager.setInputParsingManager(inputParsingManager);
            completionManager.setInterpretor(interpreter);
            completionWindow.setGraphicalContext(parentComponent);
            completionWindow.setInputParsingManager(inputParsingManager);
            completionWindow.setFocusOut((JComponent)inputCommandView);
        }
        console.setBackground(Color.decode(configuration.getBackgroundColor()));
        console.setForeground(Color.decode(configuration.getForegroundColor()));
        promptView.updatePrompt();
        ConsoleBuilder.overideInputMap(((JComponent)inputCommandView).getInputMap(), configuration.getKeyMapping());
        ConsoleBuilder.overideActionMap(((JComponent)inputCommandView).getActionMap(), configuration.getActionMapping());
        return console;
    }

    private static void overideInputMap(InputMap sourceMap, InputMap newMap) {
        for (KeyStroke key : newMap.allKeys()) {
            sourceMap.put(key, newMap.get(key));
        }
    }

    private static void overideActionMap(ActionMap sourceMap, ActionMap newMap) {
        for (Object key : newMap.allKeys()) {
            sourceMap.put(key, newMap.get(key));
        }
    }
}

