/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.ruler;

import java.text.DecimalFormat;
import java.util.List;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class RulerDrawingResult {
    private final double[] ticksValues;
    private final double[] subTicksValues;
    private final int subTicksDensity;
    private final double maxDistToTicksDirNorm;
    private final Vector3d normalizedTicksDirection;
    private final DecimalFormat format;

    RulerDrawingResult(DecimalFormat decimalFormat, List<Double> list, List<Double> list2, int n, double d, Vector3d vector3d) {
        this.format = decimalFormat;
        this.ticksValues = this.listToArray(list);
        this.subTicksValues = this.listToArray(list2);
        this.subTicksDensity = n;
        this.maxDistToTicksDirNorm = d;
        this.normalizedTicksDirection = new Vector3d(vector3d);
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    private double[] listToArray(List<Double> list) {
        double[] dArray = new double[list.size()];
        int n = 0;
        for (double d : list) {
            dArray[n++] = d;
        }
        return dArray;
    }

    public double[] getTicksValues() {
        return (double[])this.ticksValues.clone();
    }

    public double[] getSubTicksValues() {
        return (double[])this.subTicksValues.clone();
    }

    public int getSubTicksDensity() {
        return this.subTicksDensity;
    }

    public double getMaxDistToTicksDirNorm() {
        return this.maxDistToTicksDirNorm;
    }

    public Vector3d getNormalizedTicksDirection() {
        return this.normalizedTicksDirection;
    }
}

