/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import org.scilab.forge.scirenderer.implementation.g2d.motor.ConvexObject;
import org.scilab.forge.scirenderer.implementation.g2d.motor.G2DStroke;
import org.scilab.forge.scirenderer.implementation.g2d.motor.InvalidPolygonException;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.forge.scirenderer.tranformations.Vector4d;

public class PolyLine
extends ConvexObject {
    private boolean monochromatic;
    private G2DStroke stroke;
    protected double[] clip = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};

    public PolyLine(Vector3d[] vector3dArray, Color[] colorArray, G2DStroke g2DStroke) throws InvalidPolygonException {
        super(vector3dArray, colorArray);
        if (vector3dArray.length <= 1) {
            throw new InvalidPolygonException("A polyline cannot have one or zero point");
        }
        this.monochromatic = PolyLine.isMonochromatic(colorArray);
        this.stroke = g2DStroke;
    }

    public static List<PolyLine> getPolyLines(Vector3d[] vector3dArray, Color[] colorArray, G2DStroke g2DStroke, boolean bl) {
        int n;
        Color[] colorArray2;
        if (bl) {
            Vector3d[] vector3dArray2 = new Vector3d[vector3dArray.length + 1];
            colorArray2 = new Color[vector3dArray.length + 1];
            for (n = 0; n < vector3dArray.length; ++n) {
                vector3dArray2[n] = vector3dArray[n];
                colorArray2[n] = colorArray[n];
            }
            vector3dArray2[vector3dArray.length] = vector3dArray2[0];
            colorArray2[vector3dArray.length] = colorArray2[0];
            vector3dArray = vector3dArray2;
            colorArray = colorArray2;
        }
        int n2 = 0;
        colorArray2 = new ArrayList(1);
        while ((n2 = PolyLine.trimLeft(vector3dArray, n2)) != -1) {
            n = PolyLine.findNanOrInf(vector3dArray, n2 + 1);
            int n3 = n - n2;
            Vector3d[] vector3dArray3 = new Vector3d[n3];
            Color[] colorArray3 = new Color[n3];
            for (int i = 0; i < n3; ++i) {
                vector3dArray3[i] = vector3dArray[n2 + i];
                colorArray3[i] = colorArray[n2 + i];
            }
            n2 = n + 1;
            try {
                colorArray2.add(new PolyLine(vector3dArray3, colorArray3, g2DStroke));
            }
            catch (InvalidPolygonException invalidPolygonException) {}
        }
        return colorArray2;
    }

    @Override
    public List<ConvexObject> breakObject(Vector4d vector4d) {
        double[] dArray = vector4d.getData();
        ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>(1);
        if (dArray[2] == 0.0) {
            Vector3d vector3d = new Vector3d(dArray);
            ConvexObject.makeClip(this.clip, dArray);
            int n = 0;
            boolean bl = false;
            for (int i = 0; i < this.vertices.length; ++i) {
                boolean bl2 = PolyLine.isBehind(this.vertices[i], vector3d, dArray[3]);
                if (bl2 && !bl) {
                    n = i;
                    bl = true;
                    continue;
                }
                if (bl2 || !bl) continue;
                bl = false;
                try {
                    arrayList.add(this.cut(n, i, vector3d, dArray[3]));
                    continue;
                }
                catch (InvalidPolygonException invalidPolygonException) {
                    // empty catch block
                }
            }
            if (bl) {
                try {
                    arrayList.add(this.cut(n, this.vertices.length, vector3d, dArray[3]));
                }
                catch (InvalidPolygonException invalidPolygonException) {}
            }
        } else {
            arrayList.add(this);
        }
        return arrayList;
    }

    @Override
    public List<ConvexObject> breakObject(ConvexObject convexObject) {
        return null;
    }

    @Override
    protected boolean isDegenerate() {
        return false;
    }

    @Override
    protected boolean isNanOrInf() {
        return false;
    }

    @Override
    public Vector3d getNormal() {
        return null;
    }

    @Override
    protected boolean isPlanar() {
        return true;
    }

    private PolyLine cut(int n, int n2, Vector3d vector3d, double d) throws InvalidPolygonException {
        boolean bl;
        boolean bl2 = n != 0;
        boolean bl3 = bl = n2 != this.vertices.length;
        if (!bl2 && !bl) {
            return this;
        }
        if (bl2 && bl) {
            int n3 = n2 - n + 2;
            Vector3d[] vector3dArray = new Vector3d[n3];
            Color[] colorArray = new Color[n3];
            for (int i = 1; i < n3 - 1; ++i) {
                vector3dArray[i] = this.vertices[n + i - 1];
                colorArray[i] = this.getColor(n + i - 1);
            }
            double d2 = (d + this.vertices[n].scalar(vector3d)) / this.vertices[n].minus(this.vertices[n - 1]).scalar(vector3d);
            vector3dArray[0] = Vector3d.getBarycenter(this.vertices[n - 1], this.vertices[n], d2, 1.0 - d2);
            colorArray[0] = PolyLine.getColorsBarycenter(this.getColor(n - 1), this.getColor(n), d2, 1.0 - d2);
            d2 = (d + this.vertices[n2].scalar(vector3d)) / this.vertices[n2].minus(this.vertices[n2 - 1]).scalar(vector3d);
            vector3dArray[n3 - 1] = Vector3d.getBarycenter(this.vertices[n2 - 1], this.vertices[n2], d2, 1.0 - d2);
            colorArray[n3 - 1] = PolyLine.getColorsBarycenter(this.getColor(n2 - 1), this.getColor(n2), d2, 1.0 - d2);
            return new PolyLine(vector3dArray, colorArray, this.stroke);
        }
        if (bl2) {
            double d3 = (d + this.vertices[n].scalar(vector3d)) / this.vertices[n].minus(this.vertices[n - 1]).scalar(vector3d);
            int n4 = n2 - n + 1;
            Vector3d[] vector3dArray = new Vector3d[n4];
            Color[] colorArray = new Color[n4];
            for (int i = 1; i < n4; ++i) {
                vector3dArray[i] = this.vertices[n + i - 1];
                colorArray[i] = this.getColor(n + i - 1);
            }
            vector3dArray[0] = Vector3d.getBarycenter(this.vertices[n - 1], this.vertices[n], d3, 1.0 - d3);
            colorArray[0] = PolyLine.getColorsBarycenter(this.getColor(n - 1), this.getColor(n), d3, 1.0 - d3);
            return new PolyLine(vector3dArray, colorArray, this.stroke);
        }
        double d4 = (d + this.vertices[n2].scalar(vector3d)) / this.vertices[n2].minus(this.vertices[n2 - 1]).scalar(vector3d);
        int n5 = n2 - n + 1;
        Vector3d[] vector3dArray = new Vector3d[n5];
        Color[] colorArray = new Color[n5];
        for (int i = 0; i < n5 - 1; ++i) {
            vector3dArray[i] = this.vertices[n + i];
            colorArray[i] = this.getColor(n + i);
        }
        vector3dArray[n5 - 1] = Vector3d.getBarycenter(this.vertices[n2 - 1], this.vertices[n2], d4, 1.0 - d4);
        colorArray[n5 - 1] = PolyLine.getColorsBarycenter(this.getColor(n2 - 1), this.getColor(n2), d4, 1.0 - d4);
        return new PolyLine(vector3dArray, colorArray, this.stroke);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        Shape shape = graphics2D.getClip();
        Shape shape2 = ConvexObject.getClip(this.clip);
        if (shape2 != null) {
            graphics2D.clip(shape2);
        }
        if (this.monochromatic) {
            graphics2D.setColor(this.getColor(0));
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(this.getProjectedPolyLine());
        } else {
            Vector3d vector3d = this.vertices[0];
            Color color = this.getColor(0);
            double d = 0.0;
            float[] fArray = this.stroke.getDashArray();
            float f = this.stroke.getLineWidth();
            for (int i = 1; i < this.vertices.length; ++i) {
                G2DStroke g2DStroke = new G2DStroke(f, fArray, (float)d);
                graphics2D.setStroke(g2DStroke);
                graphics2D.setColor(color);
                graphics2D.draw(new Line2D.Double(vector3d.getX(), vector3d.getY(), this.vertices[i].getX(), this.vertices[i].getY()));
                d += Math.hypot(vector3d.getX() - this.vertices[i].getX(), vector3d.getY() - this.vertices[i].getY());
            }
        }
        if (shape2 != null) {
            graphics2D.setClip(shape);
        }
        graphics2D.setStroke(stroke);
    }

    private static int trimLeft(Vector3d[] vector3dArray, int n) {
        for (int i = n; i < vector3dArray.length; ++i) {
            if (PolyLine.isNanOrInf(vector3dArray[i])) continue;
            return i;
        }
        return -1;
    }

    private static int findNanOrInf(Vector3d[] vector3dArray, int n) {
        for (int i = n; i < vector3dArray.length; ++i) {
            if (!PolyLine.isNanOrInf(vector3dArray[i])) continue;
            return i;
        }
        return vector3dArray.length;
    }
}

