/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.util;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.flexdock.util.ResourceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LookAndFeelSettings {
    public static final String TAB_PANE_BORDER_INSETS = "TabbedPane.contentBorderInsets";
    public static final String DOM_RESOURCE = "org/flexdock/util/laf-defaults.xml";
    public static final String TAB_EDGE_INSET_KEY = "tabEdgeInset";
    private static final String PROPERTY_KEY = "property";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final LookAndFeelSettings SINGLETON = new LookAndFeelSettings();
    private Hashtable propertyMappings = new Hashtable();
    private boolean skinLFSupport;

    private LookAndFeelSettings() {
        Document document = ResourceManager.getDocument(DOM_RESOURCE);
        NodeList nodes = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            String key = ((Element)node).getTagName();
            Properties value = this.getProperties((Element)node);
            this.propertyMappings.put(key, value);
        }
        this.skinLFSupport = this.isSkinLFInClasspath();
    }

    private Properties getProperties(Element element) {
        Properties p = new Properties();
        NodeList nodes = element.getElementsByTagName(PROPERTY_KEY);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element prop = (Element)nodes.item(i);
            String key = prop.getAttribute(KEY);
            String value = prop.getAttribute(VALUE);
            if (key == null || value == null) continue;
            p.setProperty(key, value);
        }
        return p;
    }

    private String getProperty(String propType, String key) {
        Properties p = key == null ? null : (Properties)this.propertyMappings.get(propType);
        return p == null ? null : p.getProperty(key);
    }

    private void setProperty(String propType, String key, String value) {
        Properties p;
        Properties properties = p = key == null ? null : (Properties)this.propertyMappings.get(propType);
        if (p != null) {
            if (value == null) {
                p.remove(key);
            } else {
                p.setProperty(key, value);
            }
        }
    }

    public static boolean isSkinLFSupported() {
        return LookAndFeelSettings.SINGLETON.skinLFSupport;
    }

    public static int getTabEdgeInset(int tabPlacement) {
        String plafKey = SINGLETON.getCurrentPlafName();
        String edgeStr = SINGLETON.getProperty(TAB_EDGE_INSET_KEY, plafKey);
        Integer edge = LookAndFeelSettings.getInteger(edgeStr);
        if (edge != null && edge > 0) {
            return edge;
        }
        Insets tabInsets = UIManager.getInsets(TAB_PANE_BORDER_INSETS);
        if (tabInsets == null) {
            return 1;
        }
        switch (tabPlacement) {
            case 1: {
                return tabInsets.top;
            }
            case 3: {
                return tabInsets.bottom;
            }
            case 2: {
                return tabInsets.left;
            }
            case 4: {
                return tabInsets.right;
            }
        }
        return 1;
    }

    public static void setTabEdgeInset(String plafKey, int inset) {
        if (plafKey != null) {
            SINGLETON.setProperty(TAB_EDGE_INSET_KEY, plafKey, String.valueOf(inset));
        }
    }

    private String getCurrentPlafName() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf == null) {
            return null;
        }
        if (LookAndFeelSettings.isSkinLFSupported() && laf.getClass() == SkinLookAndFeel.class) {
            Skin skin = SkinLookAndFeel.getSkin();
            return skin == null ? null : skin.getClass().getName();
        }
        return laf.getClass().getName();
    }

    private boolean isSkinLFInClasspath() {
        try {
            Class<SkinLookAndFeel> c = SkinLookAndFeel.class;
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Integer getInteger(String string) {
        try {
            return string == null ? null : new Integer(string);
        }
        catch (Exception e) {
            return null;
        }
    }
}

